/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu.items;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.inv.content.SlotPos;
import com.archyx.aureliumskills.menu.MenuLoader;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ConfigurableItem {
    protected final AureliumSkills plugin;
    protected final ItemType itemType;
    protected SlotPos pos;
    protected ItemStack baseItem;
    protected String displayName;
    protected List<String> lore;
    protected Map<Integer, Set<String>> lorePlaceholders;
    protected final String[] definedPlaceholders;

    public ConfigurableItem(AureliumSkills plugin, ItemType itemType, String[] definedPlaceholders) {
        this.plugin = plugin;
        this.itemType = itemType;
        this.definedPlaceholders = definedPlaceholders;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public SlotPos getPos() {
        return this.pos;
    }

    protected List<String> applyPlaceholders(List<String> lore, Player player) {
        if (this.plugin.isPlaceholderAPIEnabled() && OptionL.getBoolean(Option.MENUS_PLACEHOLDER_API)) {
            ArrayList<String> appliedList = new ArrayList<String>();
            for (String entry : lore) {
                appliedList.add(PlaceholderAPI.setPlaceholders((Player)player, (String)entry));
            }
            return appliedList;
        }
        return lore;
    }

    protected String applyPlaceholders(String input, Player player) {
        if (this.plugin.isPlaceholderAPIEnabled() && OptionL.getBoolean(Option.MENUS_PLACEHOLDER_API)) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)input);
        }
        return input;
    }

    public void load(ConfigurationSection config) {
        try {
            this.pos = SlotPos.of(config.getInt("row"), config.getInt("column"));
            this.baseItem = MenuLoader.parseItem(Objects.requireNonNull(config.getString("material")));
            this.displayName = TextUtil.replace(Objects.requireNonNull(config.getString("display_name")), "&", "\u00a7");
            this.lore = new ArrayList<String>();
            this.lorePlaceholders = new HashMap<Integer, Set<String>>();
            int lineNum = 0;
            for (String line : config.getStringList("lore")) {
                HashSet<String> linePlaceholders = new HashSet<String>();
                this.lore.add(TextUtil.replace(line, "&", "\u00a7"));
                for (String placeholder : this.definedPlaceholders) {
                    if (!line.contains("{" + placeholder + "}")) continue;
                    linePlaceholders.add(placeholder);
                }
                this.lorePlaceholders.put(lineNum, linePlaceholders);
                ++lineNum;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getLogger().warning("[AureliumSkills] Error parsing item " + this.itemType.toString() + ", check error above for details!");
        }
    }
}

