/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.inv.ClickableItem;
import com.archyx.aureliumskills.inv.SmartInventory;
import com.archyx.aureliumskills.inv.content.InventoryContents;
import com.archyx.aureliumskills.inv.content.InventoryProvider;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.MenuOption;
import com.archyx.aureliumskills.menu.MenuType;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.menu.items.SkullItem;
import com.archyx.aureliumskills.menu.templates.StatTemplate;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.stats.Stats;
import java.util.Locale;
import org.bukkit.entity.Player;

public class StatsMenu
implements InventoryProvider {
    private final AureliumSkills plugin;
    private final Locale locale;
    private final MenuOption options;

    public StatsMenu(AureliumSkills plugin, Locale locale, MenuOption menuOption) {
        this.plugin = plugin;
        this.locale = locale;
        this.options = menuOption;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            if (this.options.isFillEnabled()) {
                contents.fill(ClickableItem.empty(this.options.getFillItem()));
            }
            SkullItem skullItem = (SkullItem)this.options.getItem(ItemType.SKULL);
            contents.set(skullItem.getPos(), ClickableItem.empty(skullItem.getItem(player, playerData, this.locale)));
            StatTemplate statTemplate = (StatTemplate)this.options.getTemplate(TemplateType.STAT);
            contents.set(statTemplate.getPos(Stats.STRENGTH), ClickableItem.empty(statTemplate.getItem(Stats.STRENGTH, playerData, player, this.locale)));
            contents.set(statTemplate.getPos(Stats.HEALTH), ClickableItem.empty(statTemplate.getItem(Stats.HEALTH, playerData, player, this.locale)));
            contents.set(statTemplate.getPos(Stats.REGENERATION), ClickableItem.empty(statTemplate.getItem(Stats.REGENERATION, playerData, player, this.locale)));
            contents.set(statTemplate.getPos(Stats.LUCK), ClickableItem.empty(statTemplate.getItem(Stats.LUCK, playerData, player, this.locale)));
            contents.set(statTemplate.getPos(Stats.WISDOM), ClickableItem.empty(statTemplate.getItem(Stats.WISDOM, playerData, player, this.locale)));
            contents.set(statTemplate.getPos(Stats.TOUGHNESS), ClickableItem.empty(statTemplate.getItem(Stats.TOUGHNESS, playerData, player, this.locale)));
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    public static SmartInventory getInventory(Player player, AureliumSkills plugin) {
        Locale locale = plugin.getLang().getLocale(player);
        MenuOption menuOption = plugin.getMenuLoader().getMenu(MenuType.STATS);
        return SmartInventory.builder().provider(new StatsMenu(plugin, locale, menuOption)).size(menuOption.getRows(), 9).title(Lang.getMessage(MenuMessage.STATS_MENU_TITLE, locale)).manager(plugin.getInventoryManager()).build();
    }
}

