/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.inv.ClickableItem;
import com.archyx.aureliumskills.inv.SmartInventory;
import com.archyx.aureliumskills.inv.content.InventoryContents;
import com.archyx.aureliumskills.inv.content.InventoryProvider;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.LevelProgressionMenu;
import com.archyx.aureliumskills.menu.MenuOption;
import com.archyx.aureliumskills.menu.MenuType;
import com.archyx.aureliumskills.menu.items.CloseItem;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.menu.items.YourSkillsItem;
import com.archyx.aureliumskills.menu.templates.SkillTemplate;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import java.util.Locale;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class SkillsMenu
implements InventoryProvider {
    private final PlayerData playerData;
    private final Locale locale;
    private final MenuOption options;
    private final AureliumSkills plugin;

    public SkillsMenu(PlayerData playerData, Locale locale, MenuOption menuOption, AureliumSkills plugin) {
        this.playerData = playerData;
        this.locale = locale;
        this.options = menuOption;
        this.plugin = plugin;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        if (this.options.isFillEnabled()) {
            contents.fill(ClickableItem.empty(this.options.getFillItem()));
        }
        CloseItem closeItem = (CloseItem)this.options.getItem(ItemType.CLOSE);
        contents.set(closeItem.getPos(), ClickableItem.of(closeItem.getItem(player, this.locale), e -> player.closeInventory()));
        YourSkillsItem yourSkillsItem = (YourSkillsItem)this.options.getItem(ItemType.YOUR_SKILLS);
        contents.set(yourSkillsItem.getPos(), ClickableItem.empty(yourSkillsItem.getItem(player, this.locale)));
        SkillTemplate skillTemplate = (SkillTemplate)this.options.getTemplate(TemplateType.SKILL);
        if (OptionL.isEnabled(Skills.FARMING)) {
            contents.set(skillTemplate.getPosition(Skills.FARMING), ClickableItem.of(skillTemplate.getItem(Skills.FARMING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.FARMING)));
        }
        if (OptionL.isEnabled(Skills.FORAGING)) {
            contents.set(skillTemplate.getPosition(Skills.FORAGING), ClickableItem.of(skillTemplate.getItem(Skills.FORAGING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.FORAGING)));
        }
        if (OptionL.isEnabled(Skills.MINING)) {
            contents.set(skillTemplate.getPosition(Skills.MINING), ClickableItem.of(skillTemplate.getItem(Skills.MINING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.MINING)));
        }
        if (OptionL.isEnabled(Skills.FISHING)) {
            contents.set(skillTemplate.getPosition(Skills.FISHING), ClickableItem.of(skillTemplate.getItem(Skills.FISHING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.FISHING)));
        }
        if (OptionL.isEnabled(Skills.EXCAVATION)) {
            contents.set(skillTemplate.getPosition(Skills.EXCAVATION), ClickableItem.of(skillTemplate.getItem(Skills.EXCAVATION, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.EXCAVATION)));
        }
        if (OptionL.isEnabled(Skills.ARCHERY)) {
            contents.set(skillTemplate.getPosition(Skills.ARCHERY), ClickableItem.of(skillTemplate.getItem(Skills.ARCHERY, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.ARCHERY)));
        }
        if (OptionL.isEnabled(Skills.DEFENSE)) {
            contents.set(skillTemplate.getPosition(Skills.DEFENSE), ClickableItem.of(skillTemplate.getItem(Skills.DEFENSE, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.DEFENSE)));
        }
        if (OptionL.isEnabled(Skills.FIGHTING)) {
            contents.set(skillTemplate.getPosition(Skills.FIGHTING), ClickableItem.of(skillTemplate.getItem(Skills.FIGHTING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.FIGHTING)));
        }
        if (OptionL.isEnabled(Skills.ENDURANCE)) {
            contents.set(skillTemplate.getPosition(Skills.ENDURANCE), ClickableItem.of(skillTemplate.getItem(Skills.ENDURANCE, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.ENDURANCE)));
        }
        if (OptionL.isEnabled(Skills.AGILITY)) {
            contents.set(skillTemplate.getPosition(Skills.AGILITY), ClickableItem.of(skillTemplate.getItem(Skills.AGILITY, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.AGILITY)));
        }
        if (OptionL.isEnabled(Skills.ALCHEMY)) {
            contents.set(skillTemplate.getPosition(Skills.ALCHEMY), ClickableItem.of(skillTemplate.getItem(Skills.ALCHEMY, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.ALCHEMY)));
        }
        if (OptionL.isEnabled(Skills.ENCHANTING)) {
            contents.set(skillTemplate.getPosition(Skills.ENCHANTING), ClickableItem.of(skillTemplate.getItem(Skills.ENCHANTING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.ENCHANTING)));
        }
        if (OptionL.isEnabled(Skills.SORCERY)) {
            contents.set(skillTemplate.getPosition(Skills.SORCERY), ClickableItem.of(skillTemplate.getItem(Skills.SORCERY, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.SORCERY)));
        }
        if (OptionL.isEnabled(Skills.HEALING)) {
            contents.set(skillTemplate.getPosition(Skills.HEALING), ClickableItem.of(skillTemplate.getItem(Skills.HEALING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.HEALING)));
        }
        if (OptionL.isEnabled(Skills.FORGING)) {
            contents.set(skillTemplate.getPosition(Skills.FORGING), ClickableItem.of(skillTemplate.getItem(Skills.FORGING, this.playerData, player, this.locale), e -> this.open(player, this.playerData, Skills.FORGING)));
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    public static int getPage(Skill skill, PlayerData playerData) {
        int maxLevelPage;
        int page = (playerData.getSkillLevel(skill) - 2) / 24;
        if (page > (maxLevelPage = (OptionL.getMaxLevel(skill) - 2) / 24)) {
            page = maxLevelPage;
        }
        return page;
    }

    private void open(Player player, PlayerData playerData, Skill skill) {
        int page;
        SmartInventory inventory;
        if (player.hasPermission("aureliumskills." + skill.name().toLowerCase(Locale.ENGLISH)) && (inventory = LevelProgressionMenu.getInventory(player, skill, page = SkillsMenu.getPage(skill, playerData), this.plugin)) != null) {
            inventory.open(player, page);
        }
    }

    @Nullable
    public static SmartInventory getInventory(Player player, AureliumSkills plugin) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return null;
        }
        Locale locale = playerData.getLocale();
        MenuOption menuOption = plugin.getMenuLoader().getMenu(MenuType.SKILLS);
        return SmartInventory.builder().provider(new SkillsMenu(playerData, locale, menuOption, plugin)).size(menuOption.getRows(), 9).title(Lang.getMessage(MenuMessage.SKILLS_MENU_TITLE, locale)).manager(plugin.getInventoryManager()).build();
    }
}

