/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.menu.MenuOption;
import com.archyx.aureliumskills.menu.MenuType;
import com.archyx.aureliumskills.menu.items.ConfigurableItem;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.menu.templates.ConfigurableTemplate;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.util.version.VersionUtils;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class MenuLoader {
    private final Map<MenuType, MenuOption> menus;
    private final AureliumSkills plugin;

    public MenuLoader(AureliumSkills plugin) {
        this.plugin = plugin;
        this.menus = new HashMap<MenuType, MenuOption>();
    }

    public void load() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        File file = new File(this.plugin.getDataFolder(), "menus.yml");
        if (!file.exists()) {
            this.plugin.saveResource("menus.yml", false);
        }
        FileConfiguration config = this.updateFile(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        int menusLoaded = 0;
        int itemsLoaded = 0;
        int templatesLoaded = 0;
        long start = System.currentTimeMillis();
        for (MenuType menuType : MenuType.values()) {
            ConfigurationSection section;
            Class<?> loader;
            ConfigurationSection menu = config.getConfigurationSection(menuType.getPath());
            if (menu == null) continue;
            MenuOption menuOption = new MenuOption(menuType);
            menuOption.setTitle(menu.getString("title"));
            menuOption.setRows(menu.getInt("rows"));
            menuOption.setFillEnabled(menu.getBoolean("fill.enabled", true));
            ItemStack fillItem = MenuLoader.parseItem(menu.getString("fill.material"), XMaterial.BLACK_STAINED_GLASS_PANE.parseMaterial());
            ItemMeta meta = fillItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(" ");
                fillItem.setItemMeta(meta);
            }
            menuOption.setFillItem(fillItem);
            for (ItemType itemType : menuType.getItems()) {
                ConfigurableItem configurableItem;
                loader = itemType.getLoader();
                try {
                    configurableItem = (ConfigurableItem)loader.getConstructors()[0].newInstance(new Object[]{this.plugin});
                }
                catch (IllegalArgumentException e) {
                    configurableItem = (ConfigurableItem)loader.newInstance();
                }
                section = menu.getConfigurationSection("items." + itemType.name().toLowerCase(Locale.ROOT));
                if (section == null) continue;
                configurableItem.load(section);
                menuOption.putItem(configurableItem);
                ++itemsLoaded;
            }
            for (Enum enum_ : menuType.getTemplates()) {
                ConfigurableTemplate configurableTemplate;
                loader = ((TemplateType)enum_).getLoader();
                try {
                    configurableTemplate = (ConfigurableTemplate)loader.getConstructors()[0].newInstance(new Object[]{this.plugin});
                }
                catch (IllegalArgumentException e) {
                    configurableTemplate = (ConfigurableTemplate)loader.newInstance();
                }
                section = menu.getConfigurationSection("templates." + enum_.name().toLowerCase(Locale.ROOT));
                if (section == null) continue;
                configurableTemplate.load(section);
                menuOption.putTemplate(configurableTemplate);
                ++templatesLoaded;
            }
            this.menus.put(menuType, menuOption);
            ++menusLoaded;
        }
        long end = System.currentTimeMillis();
        Bukkit.getLogger().info("[AureliumSkills] Loaded " + menusLoaded + " menus, " + itemsLoaded + " items, and " + templatesLoaded + " templates in " + (end - start) + " ms");
    }

    public MenuOption getMenu(MenuType type) {
        return this.menus.get((Object)type);
    }

    public static ItemStack parseItem(String input) {
        return MenuLoader.parseItem(input, Material.STONE);
    }

    public static ItemStack parseItem(String input, Material fallback) {
        if (input != null) {
            String[] splitInput = input.split(" ", 2);
            String material = splitInput[0];
            try {
                ItemStack item = XMaterial.valueOf(material.toUpperCase()).parseItem();
                if (item != null) {
                    String[] args;
                    ItemMeta originalMeta = item.getItemMeta();
                    if (originalMeta != null) {
                        originalMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        item.setItemMeta(originalMeta);
                    }
                    if (splitInput.length > 1 && (args = splitInput[1].split(" ")).length > 0) {
                        for (String argument : args) {
                            if (argument.split(":").length <= 1) continue;
                            String key = argument.split(":")[0];
                            String value = argument.split(":")[1];
                            if (key.equalsIgnoreCase("potion_type") && item.getItemMeta() instanceof PotionMeta) {
                                PotionMeta meta = (PotionMeta)item.getItemMeta();
                                meta.setBasePotionData(new PotionData(PotionType.valueOf((String)value.toUpperCase())));
                                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                                item.setItemMeta((ItemMeta)meta);
                                continue;
                            }
                            if (key.equalsIgnoreCase("glow") && value.equalsIgnoreCase("true")) {
                                ItemMeta meta = item.getItemMeta();
                                if (meta == null) continue;
                                meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1, true);
                                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                                item.setItemMeta(meta);
                                continue;
                            }
                            if (key.equalsIgnoreCase("hide_attributes") && value.equalsIgnoreCase("false")) {
                                ItemMeta meta = item.getItemMeta();
                                if (meta == null || !meta.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES)) continue;
                                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                                item.setItemMeta(meta);
                                continue;
                            }
                            if (!key.equalsIgnoreCase("custom_model_data") || !VersionUtils.isAtLeastVersion(14)) continue;
                            int data = Integer.parseInt(value);
                            ItemMeta meta = item.getItemMeta();
                            if (meta == null) continue;
                            meta.setCustomModelData(Integer.valueOf(data));
                            item.setItemMeta(meta);
                        }
                    }
                } else {
                    Bukkit.getLogger().warning("[AureliumSkills] Error parsing material with input " + input + ", the input material " + material + " is invalid!");
                    item = new ItemStack(fallback);
                }
                return item;
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[AureliumSkills] Error parsing material with input " + input);
                e.printStackTrace();
                return new ItemStack(fallback);
            }
        }
        return new ItemStack(fallback);
    }

    private FileConfiguration updateFile(File file, FileConfiguration config) {
        YamlConfiguration imbConfig;
        int imbVersion;
        int currentVersion;
        InputStream stream = this.plugin.getResource("menus.yml");
        if (stream != null && (currentVersion = config.getInt("file_version")) != (imbVersion = (imbConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream))).getInt("file_version"))) {
            try {
                if (currentVersion == 1) {
                    this.convertToRewardsUpdate(config, (FileConfiguration)imbConfig);
                }
                if (currentVersion <= 2) {
                    this.fixStatTemplate(config, (FileConfiguration)imbConfig);
                }
                ConfigurationSection configSection = imbConfig.getConfigurationSection("");
                int keysAdded = 0;
                if (configSection != null) {
                    for (String key : configSection.getKeys(true)) {
                        if (config.contains(key)) continue;
                        config.set(key, imbConfig.get(key));
                        ++keysAdded;
                    }
                }
                config.set("file_version", (Object)imbVersion);
                config.save(file);
                Bukkit.getLogger().info("[AureliumSkills] menus.yml was updated to a new file version, " + keysAdded + " new keys were added.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void convertToRewardsUpdate(FileConfiguration config, FileConfiguration imbConfig) {
        String[] paths;
        for (String path : paths = new String[]{"skills_menu.templates.skill.lore", "level_progression_menu.skill.lore"}) {
            config.set(path, imbConfig.get(path));
            this.plugin.getLogger().warning("The value of " + path + " in menus.yml was reset to default for the rewards update, this is normal");
        }
    }

    private void fixStatTemplate(FileConfiguration config, FileConfiguration imbConfig) {
        String path = "stats_menu.templates.stat.lore";
        config.set(path, imbConfig.get(path));
        this.plugin.getLogger().warning("The value of " + path + " in menus.yml was reset to default to fix a bug, this is normal");
    }
}

