/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.menu;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.inv.ClickableItem;
import com.archyx.aureliumskills.inv.SmartInventory;
import com.archyx.aureliumskills.inv.content.InventoryContents;
import com.archyx.aureliumskills.inv.content.InventoryProvider;
import com.archyx.aureliumskills.inv.content.Pagination;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.menu.MenuOption;
import com.archyx.aureliumskills.menu.MenuType;
import com.archyx.aureliumskills.menu.SkillsMenu;
import com.archyx.aureliumskills.menu.items.BackItem;
import com.archyx.aureliumskills.menu.items.CloseItem;
import com.archyx.aureliumskills.menu.items.ItemType;
import com.archyx.aureliumskills.menu.items.NextPageItem;
import com.archyx.aureliumskills.menu.items.PreviousPageItem;
import com.archyx.aureliumskills.menu.items.RankItem;
import com.archyx.aureliumskills.menu.items.SkillItem;
import com.archyx.aureliumskills.menu.templates.InProgressTemplate;
import com.archyx.aureliumskills.menu.templates.LockedTemplate;
import com.archyx.aureliumskills.menu.templates.TemplateType;
import com.archyx.aureliumskills.menu.templates.UnlockedTemplate;
import com.archyx.aureliumskills.skills.Skill;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LevelProgressionMenu
implements InventoryProvider {
    private final PlayerData playerData;
    private final Skill skill;
    private final Locale locale;
    private final List<Integer> track;
    private final MenuOption options;
    private final AureliumSkills plugin;
    private final int pages;

    public LevelProgressionMenu(PlayerData playerData, Locale locale, Skill skill, MenuOption menuOption, AureliumSkills plugin) {
        this.playerData = playerData;
        this.locale = locale;
        this.skill = skill;
        this.options = menuOption;
        this.plugin = plugin;
        this.pages = (OptionL.getMaxLevel(skill) - 2) / 24 + 1;
        this.track = new ArrayList<Integer>();
        for (int i = 0; i < this.pages; ++i) {
            this.track.add(i * 36);
            this.track.add(9 + i * 36);
            this.track.add(18 + i * 36);
            this.track.add(27 + i * 36);
            this.track.add(28 + i * 36);
            this.track.add(29 + i * 36);
            this.track.add(20 + i * 36);
            this.track.add(11 + i * 36);
            this.track.add(2 + i * 36);
            this.track.add(3 + i * 36);
            this.track.add(4 + i * 36);
            this.track.add(13 + i * 36);
            this.track.add(22 + i * 36);
            this.track.add(31 + i * 36);
            this.track.add(32 + i * 36);
            this.track.add(33 + i * 36);
            this.track.add(24 + i * 36);
            this.track.add(15 + i * 36);
            this.track.add(6 + i * 36);
            this.track.add(7 + i * 36);
            this.track.add(8 + i * 36);
            this.track.add(17 + i * 36);
            this.track.add(26 + i * 36);
            this.track.add(35 + i * 36);
        }
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        int currentLevel = this.playerData.getSkillLevel(this.skill);
        if (this.options.isFillEnabled()) {
            contents.fill(ClickableItem.empty(this.options.getFillItem()));
        }
        SkillItem skillItem = (SkillItem)this.options.getItem(ItemType.SKILL);
        contents.set(skillItem.getPos(), ClickableItem.empty(skillItem.getItem(this.skill, this.playerData, player, this.locale)));
        BackItem backItem = (BackItem)this.options.getItem(ItemType.BACK);
        contents.set(backItem.getPos(), ClickableItem.of(backItem.getItem(player, this.locale), e -> SkillsMenu.getInventory(player, this.plugin).open(player)));
        CloseItem closeItem = (CloseItem)this.options.getItem(ItemType.CLOSE);
        contents.set(closeItem.getPos(), ClickableItem.of(closeItem.getItem(player, this.locale), e -> player.closeInventory()));
        RankItem rankItem = (RankItem)this.options.getItem(ItemType.RANK);
        contents.set(rankItem.getPos(), ClickableItem.empty(rankItem.getItem(this.skill, player, this.locale)));
        Pagination pagination = contents.pagination();
        ClickableItem[] items = new ClickableItem[36 * this.pages];
        if (this.options.isFillEnabled() && this.options.getFillItem() != null) {
            for (int i = 0; i < items.length; ++i) {
                items[i] = ClickableItem.empty(this.options.getFillItem());
            }
        }
        UnlockedTemplate unlocked = (UnlockedTemplate)this.options.getTemplate(TemplateType.UNLOCKED);
        InProgressTemplate inProgress = (InProgressTemplate)this.options.getTemplate(TemplateType.IN_PROGRESS);
        LockedTemplate locked = (LockedTemplate)this.options.getTemplate(TemplateType.LOCKED);
        for (int i = pagination.getPage() * 24; i < pagination.getPage() * 24 + 24; ++i) {
            if (i + 2 <= OptionL.getMaxLevel(this.skill)) {
                if (i + 2 <= currentLevel) {
                    items[this.track.get((int)i).intValue()] = ClickableItem.empty(unlocked.getItem(this.skill, i + 2, player, this.locale));
                    continue;
                }
                if (i + 2 == currentLevel + 1) {
                    items[this.track.get((int)i).intValue()] = ClickableItem.empty(inProgress.getItem(this.skill, this.playerData, i + 2, player, this.locale));
                    continue;
                }
                items[this.track.get((int)i).intValue()] = ClickableItem.empty(locked.getItem(this.skill, i + 2, player, this.locale));
                continue;
            }
            items[this.track.get((int)i).intValue()] = this.options.isFillEnabled() && this.options.getFillItem() != null ? ClickableItem.empty(this.options.getFillItem()) : ClickableItem.empty(new ItemStack(Material.AIR));
        }
        pagination.setItems(items);
        pagination.setItemsPerPage(36);
        int a = 0;
        for (int i = 9; i < 45; ++i) {
            int row = i / 9;
            int column = i % 9;
            contents.set(row, column, pagination.getPageItems()[a]);
            ++a;
        }
        NextPageItem nextPageItem = (NextPageItem)this.options.getItem(ItemType.NEXT_PAGE);
        if (pagination.getPage() + 1 < this.pages) {
            contents.set(nextPageItem.getPos(), ClickableItem.of(nextPageItem.getItem(player, this.locale), e -> {
                int page = pagination.next().getPage();
                SmartInventory inventory = LevelProgressionMenu.getInventory(player, this.skill, page, this.plugin);
                if (inventory != null) {
                    inventory.open(player, page);
                }
            }));
        }
        PreviousPageItem previousPageItem = (PreviousPageItem)this.options.getItem(ItemType.PREVIOUS_PAGE);
        if (pagination.getPage() - 1 >= 0) {
            contents.set(previousPageItem.getPos(), ClickableItem.of(previousPageItem.getItem(player, this.locale), e -> {
                int previous = pagination.previous().getPage();
                SmartInventory inventory = LevelProgressionMenu.getInventory(player, this.skill, previous, this.plugin);
                if (inventory != null) {
                    inventory.open(player, previous);
                }
            }));
        }
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    @Nullable
    public static SmartInventory getInventory(Player player, Skill skill, int page, AureliumSkills plugin) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return null;
        }
        Locale locale = playerData.getLocale();
        MenuOption menuOption = plugin.getMenuLoader().getMenu(MenuType.LEVEL_PROGRESSION);
        return SmartInventory.builder().provider(new LevelProgressionMenu(playerData, locale, skill, menuOption, plugin)).size(menuOption.getRows(), 9).title(Lang.getMessage(MenuMessage.LEVEL_PROGRESSION_MENU_TITLE, locale).replace("{skill}", skill.getDisplayName(locale)).replace("{page}", String.valueOf(page + 1))).manager(plugin.getInventoryManager()).build();
    }
}

