/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ReadiedManaAbility;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.foraging.ForagingSource;
import com.archyx.aureliumskills.util.block.BlockFaceUtil;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Treecapitator
extends ReadiedManaAbility {
    public Treecapitator(AureliumSkills plugin) {
        super(plugin, MAbility.TREECAPITATOR, ManaAbilityMessage.TREECAPITATOR_START, ManaAbilityMessage.TREECAPITATOR_END, new String[]{"_AXE"}, new Action[]{Action.RIGHT_CLICK_AIR, Action.RIGHT_CLICK_BLOCK});
    }

    @Override
    public void onActivate(Player player, PlayerData playerData) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    @Override
    public void onStop(Player player, PlayerData playerData) {
    }

    @Override
    protected boolean materialMatches(String checked) {
        if ((checked.equals("WOODEN_AXE") || checked.equals("WOOD_AXE")) && this.plugin.getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
            return false;
        }
        for (String material : this.materials) {
            if (!checked.contains(material)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (this.plugin.getRegionManager().isPlacedBlock(block)) {
            return;
        }
        if (this.isTrunk(block) || block.getType().toString().contains("STRIPPED")) {
            Player player = event.getPlayer();
            if (this.isActivated(player)) {
                this.breakTree(player, block);
                return;
            }
            if (this.isReady(player) && this.isHoldingMaterial(player) && this.hasEnoughMana(player) && this.hasEnoughMana(player)) {
                this.activate(player);
                this.breakTree(player, block);
            }
        }
    }

    public void breakTree(Player player, Block block) {
        ForagingSource source;
        if (this.plugin.getManaAbilityManager().isActivated(player.getUniqueId(), MAbility.TREECAPITATOR) && (source = ForagingSource.getSource(block)) != null) {
            this.breakBlock(player, block, new TreecapitatorTree(this.plugin, block));
        }
    }

    private void breakBlock(final Player player, Block block, final TreecapitatorTree tree) {
        if (tree.getBlocksBroken() > tree.getMaxBlocks()) {
            return;
        }
        for (final Block rel : BlockFaceUtil.getSurroundingBlocks(block)) {
            boolean isTrunk = this.isTrunk(rel);
            boolean isLeaf = this.isLeaf(rel);
            if (!isTrunk && !isLeaf && !rel.getType().toString().equals("SHROOMLIGHT") || this.plugin.getRegionManager().isPlacedBlock(rel)) continue;
            ForagingSource source = ForagingSource.getSource(rel);
            rel.breakNaturally();
            tree.incrementBlocksBroken();
            if (source != null) {
                this.plugin.getLeveler().addXp(player, Skills.FORAGING, this.getXp(player, source, Ability.FORAGER));
            }
            Block originalBlock = tree.getOriginalBlock();
            if (rel.getX() > originalBlock.getX() + 6 || rel.getZ() > originalBlock.getZ() + 6 || rel.getY() > originalBlock.getY() + 31) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    Treecapitator.this.breakBlock(player, rel, tree);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private boolean isTrunk(Block block) {
        ForagingSource source = ForagingSource.getSource(block);
        if (source != null) {
            return source.isTrunk();
        }
        return false;
    }

    private boolean isLeaf(Block block) {
        ForagingSource source = ForagingSource.getSource(block);
        if (source != null) {
            return source.isLeaf();
        }
        return false;
    }

    private static class TreecapitatorTree {
        private final AureliumSkills plugin;
        private final Block originalBlock;
        private int blocksBroken;
        private int maxBlocks;

        public TreecapitatorTree(AureliumSkills plugin, Block originalBlock) {
            this.plugin = plugin;
            this.originalBlock = originalBlock;
            this.setMaxBlocks();
        }

        public Block getOriginalBlock() {
            return this.originalBlock;
        }

        public int getBlocksBroken() {
            return this.blocksBroken;
        }

        public void incrementBlocksBroken() {
            ++this.blocksBroken;
        }

        public int getMaxBlocks() {
            return this.maxBlocks;
        }

        private void setMaxBlocks() {
            ForagingSource source = ForagingSource.getSource(this.originalBlock);
            String matName = this.originalBlock.getType().toString();
            if (source == null && matName.contains("STRIPPED")) {
                String[] woodNames;
                for (String woodName : woodNames = new String[]{"OAK", "SPRUCE", "BIRCH", "JUNGLE", "ACACIA", "DARK_OAK", "CRIMSON", "WARPED"}) {
                    if (!matName.contains(woodName)) continue;
                    if (woodName.equals("CRIMSON") || woodName.equals("WARPED")) {
                        source = ForagingSource.valueOf(woodName + "_STEM");
                        break;
                    }
                    source = ForagingSource.valueOf(woodName + "_LOG");
                    break;
                }
            }
            if (source != null) {
                switch (source) {
                    case OAK_LOG: 
                    case BIRCH_LOG: 
                    case ACACIA_LOG: {
                        this.maxBlocks = 100;
                        break;
                    }
                    case SPRUCE_LOG: 
                    case CRIMSON_STEM: 
                    case WARPED_STEM: {
                        this.maxBlocks = 125;
                        break;
                    }
                    case JUNGLE_LOG: {
                        this.maxBlocks = 200;
                        break;
                    }
                    case DARK_OAK_LOG: {
                        this.maxBlocks = 150;
                    }
                }
            } else {
                this.maxBlocks = 100;
            }
            double multiplier = this.plugin.getManaAbilityManager().getOptionAsDouble(MAbility.TREECAPITATOR, "max_blocks_multiplier");
            this.maxBlocks = (int)((double)this.maxBlocks * multiplier);
        }
    }
}

