/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.api.event.TerraformBlockBreakEvent;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ReadiedManaAbility;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.excavation.ExcavationSource;
import com.archyx.aureliumskills.source.SourceTag;
import java.util.LinkedList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class Terraform
extends ReadiedManaAbility {
    public Terraform(AureliumSkills plugin) {
        super(plugin, MAbility.TERRAFORM, ManaAbilityMessage.TERRAFORM_START, ManaAbilityMessage.TERRAFORM_END, new String[]{"SHOVEL", "SPADE"}, new Action[]{Action.RIGHT_CLICK_BLOCK, Action.RIGHT_CLICK_AIR});
    }

    @Override
    public void onActivate(Player player, PlayerData playerData) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    @Override
    public void onStop(Player player, PlayerData playerData) {
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (!OptionL.isEnabled(Skills.EXCAVATION)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (this.blockAbility(player)) {
            return;
        }
        if (!this.plugin.getAbilityManager().isEnabled(MAbility.TERRAFORM)) {
            return;
        }
        if (block.hasMetadata("block-ignore")) {
            return;
        }
        if (!block.hasMetadata("AureliumSkills-Terraform") && event.getClass() == BlockBreakEvent.class) {
            this.applyTerraform(player, block);
        }
    }

    private void applyTerraform(Player player, Block block) {
        ExcavationSource source = ExcavationSource.getSource(block);
        if (source == null) {
            return;
        }
        if (!this.hasTag(source, SourceTag.TERRAFORM_APPLICABLE)) {
            return;
        }
        if (this.isActivated(player)) {
            this.terraformBreak(player, block);
            return;
        }
        if (this.isReady(player) && this.isHoldingMaterial(player) && this.hasEnoughMana(player)) {
            this.activate(player);
            this.terraformBreak(player, block);
        }
    }

    private void terraformBreak(Player player, Block block) {
        Material material = block.getType();
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        LinkedList<Block> toCheck = new LinkedList<Block>();
        toCheck.add(block);
        int count = 0;
        while ((block = (Block)toCheck.poll()) != null && count < 61) {
            if (block.getType() != material) continue;
            block.setMetadata("AureliumSkills-Terraform", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            this.breakBlock(player, block);
            for (BlockFace face : faces) {
                toCheck.add(block.getRelative(face));
            }
            ++count;
        }
    }

    private void breakBlock(Player player, Block block) {
        if (!this.plugin.getTownySupport().canBreak(player, block)) {
            block.removeMetadata("AureliumSkills-Terraform", (Plugin)this.plugin);
            return;
        }
        TerraformBlockBreakEvent event = new TerraformBlockBreakEvent(block, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.breakNaturally(player.getInventory().getItemInMainHand());
        }
        block.removeMetadata("AureliumSkills-Terraform", (Plugin)this.plugin);
    }
}

