/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityProvider;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class SharpHook
extends ManaAbilityProvider {
    public SharpHook(AureliumSkills plugin) {
        super(plugin, MAbility.SHARP_HOOK, ManaAbilityMessage.SHARP_HOOK_USE, null);
    }

    @Override
    public void onActivate(Player player, PlayerData playerData) {
        if (this.plugin.getManaAbilityManager().getOptionAsBooleanElseTrue(MAbility.SHARP_HOOK, "enable_sound")) {
            if (XMaterial.isNewVersion()) {
                player.playSound(player.getLocation(), Sound.ENTITY_FISHING_BOBBER_RETRIEVE, 1.0f, 1.5f);
            } else {
                player.playSound(player.getLocation(), "entity.bobber.retrieve", 1.0f, 1.5f);
            }
        }
    }

    @Override
    public void onStop(Player player, PlayerData playerData) {
    }

    @EventHandler
    public void sharpHook(PlayerInteractEvent event) {
        ProjectileSource source;
        FishHook fishHook;
        if (!OptionL.isEnabled(Skills.FISHING) || !this.plugin.getAbilityManager().isEnabled(MAbility.SHARP_HOOK)) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.FISHING_ROD) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.getManaAbilityLevel(MAbility.SHARP_HOOK) <= 0) {
            return;
        }
        for (Entity entity : player.getNearbyEntities(0.1, 0.1, 0.1)) {
            if (!(entity instanceof FishHook)) continue;
            fishHook = (FishHook)entity;
            source = fishHook.getShooter();
            if (!fishHook.isValid() || !(source instanceof Player) || !source.equals(player)) continue;
            return;
        }
        block1: for (Entity entity : player.getNearbyEntities(33.0, 33.0, 33.0)) {
            if (!(entity instanceof FishHook)) continue;
            fishHook = (FishHook)entity;
            source = fishHook.getShooter();
            if (!fishHook.isValid() || !(source instanceof Player) || !source.equals(player)) continue;
            for (Entity hooked : fishHook.getNearbyEntities(0.1, 0.1, 0.1)) {
                LivingEntity livingEntity;
                if (!(hooked instanceof LivingEntity) || (livingEntity = (LivingEntity)hooked).isDead() || !livingEntity.isValid()) continue;
                int cooldown = this.manager.getPlayerCooldown(player.getUniqueId(), MAbility.SHARP_HOOK);
                if (cooldown == 0) {
                    if (!this.areValidLocations(player, livingEntity)) break block1;
                    this.activateSharpHook(player, playerData, livingEntity);
                    break block1;
                }
                if (this.manager.getErrorTimer(player.getUniqueId(), MAbility.SHARP_HOOK) != 0) break block1;
                Locale locale = playerData.getLocale();
                this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(Lang.getMessage(ManaAbilityMessage.NOT_READY, locale), "{cooldown}", NumberUtil.format1((double)cooldown / 20.0)));
                this.manager.setErrorTimer(player.getUniqueId(), MAbility.SHARP_HOOK, 2);
                break block1;
            }
        }
    }

    private void activateSharpHook(Player player, PlayerData playerData, LivingEntity caught) {
        if (this.hasEnoughMana(player)) {
            double damage = this.plugin.getManaAbilityManager().getValue(MAbility.SHARP_HOOK, playerData);
            double healthBefore = caught.getHealth();
            caught.damage(damage, (Entity)player);
            double healthAfter = caught.getHealth();
            if (healthBefore != healthAfter) {
                this.activate(player);
            }
        }
    }

    private boolean areValidLocations(Player damager, LivingEntity hooked) {
        World hookedWorld;
        Location damagerLocation = damager.getLocation();
        Location hookedLocation = hooked.getLocation();
        World damagerWorld = damagerLocation.getWorld();
        if (damagerWorld != null & (hookedWorld = hookedLocation.getWorld()) != null && !damagerWorld.equals(hookedWorld)) {
            return false;
        }
        return !(damagerLocation.distanceSquared(hookedLocation) > 1089.0);
    }

    @Override
    protected int getDuration(PlayerData playerData) {
        return 0;
    }
}

