/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityProvider;
import com.archyx.aureliumskills.util.math.NumberUtil;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class ReadiedManaAbility
extends ManaAbilityProvider {
    private final Action[] actions;
    protected final String[] materials;
    private static final int READY_DURATION = 80;

    public ReadiedManaAbility(AureliumSkills plugin, MAbility manaAbility, ManaAbilityMessage activateMessage, ManaAbilityMessage stopMessage, String[] materials, Action[] actions) {
        super(plugin, manaAbility, activateMessage, stopMessage);
        this.materials = materials;
        this.actions = actions;
    }

    protected boolean isExcludedBlock(Block block) {
        return false;
    }

    protected boolean isActivated(Player player) {
        return this.manager.isActivated(player.getUniqueId(), this.mAbility);
    }

    protected boolean isReady(Player player) {
        return this.manager.isReady(player.getUniqueId(), this.mAbility) && !this.isActivated(player);
    }

    protected boolean isHoldingMaterial(Player player) {
        return this.materialMatches(player.getInventory().getItemInMainHand().getType().toString());
    }

    protected boolean materialMatches(String checked) {
        for (String material : this.materials) {
            if (!checked.contains(material)) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onReady(PlayerInteractEvent event) {
        if (!OptionL.isEnabled(this.skill)) {
            return;
        }
        if (!this.plugin.getAbilityManager().isEnabled(this.mAbility)) {
            return;
        }
        boolean valid = false;
        for (Action action : this.actions) {
            if (event.getAction() != action) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null && this.isExcludedBlock(block)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.isHoldingMaterial(player)) {
            return;
        }
        if (!this.isAllowReady(player, event)) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        Locale locale = playerData.getLocale();
        if (playerData.getManaAbilityLevel(this.mAbility) <= 0) {
            return;
        }
        if (this.manager.isActivated(player.getUniqueId(), this.mAbility)) {
            return;
        }
        if (this.manager.isReady(player.getUniqueId(), this.mAbility)) {
            return;
        }
        if (this.manager.getPlayerCooldown(player.getUniqueId(), this.mAbility) == 0) {
            this.manager.setReady(player.getUniqueId(), this.mAbility, true);
            this.plugin.getAbilityManager().sendMessage(player, ChatColor.GRAY + Lang.getMessage(ManaAbilityMessage.valueOf(this.mAbility.name() + "_RAISE"), locale));
            this.scheduleUnready(player, locale);
        } else if (this.manager.getErrorTimer(player.getUniqueId(), this.mAbility) == 0) {
            this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(ManaAbilityMessage.NOT_READY, locale).replace("{cooldown}", NumberUtil.format0((double)this.plugin.getManaAbilityManager().getPlayerCooldown(player.getUniqueId(), this.mAbility) / 20.0)));
            this.manager.setErrorTimer(player.getUniqueId(), this.mAbility, 2);
        }
    }

    private void scheduleUnready(final Player player, final Locale locale) {
        new BukkitRunnable(){

            public void run() {
                if (!ReadiedManaAbility.this.manager.isActivated(player.getUniqueId(), ReadiedManaAbility.this.mAbility) && ReadiedManaAbility.this.manager.isReady(player.getUniqueId(), ReadiedManaAbility.this.mAbility)) {
                    ReadiedManaAbility.this.manager.setReady(player.getUniqueId(), ReadiedManaAbility.this.mAbility, false);
                    ReadiedManaAbility.this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(ManaAbilityMessage.valueOf(ReadiedManaAbility.this.mAbility.name() + "_LOWER"), locale));
                }
            }
        }.runTaskLater((Plugin)this.plugin, 80L);
    }

    private boolean isAllowReady(Player player, PlayerInteractEvent event) {
        if (this.manager.getOptionAsBooleanElseFalse(this.mAbility, "require_sneak") && !player.isSneaking()) {
            return false;
        }
        if (this.isBlockPlace(event, player, this.mAbility)) {
            return false;
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return false;
        }
        return player.hasPermission("aureliumskills." + this.skill.toString().toLowerCase(Locale.ENGLISH));
    }

    private boolean isBlockPlace(PlayerInteractEvent event, Player player, MAbility mAbility) {
        if (this.plugin.getManaAbilityManager().getOptionAsBooleanElseTrue(mAbility, "check_offhand") && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (player.isSneaking() && this.plugin.getManaAbilityManager().getOptionAsBooleanElseTrue(mAbility, "sneak_offhand_bypass")) {
                return false;
            }
            ItemStack item = player.getInventory().getItemInOffHand();
            if (item.getType() == Material.AIR) {
                return false;
            }
            return item.getType().isBlock();
        }
        return false;
    }
}

