/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.ManaAbilityActivateEvent;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityManager;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.sorcery.SorceryLeveler;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public abstract class ManaAbilityProvider
extends AbilityProvider
implements Listener {
    protected final AureliumSkills plugin;
    protected final ManaAbilityManager manager;
    protected final MAbility mAbility;
    protected final Skill skill;
    protected final SorceryLeveler sorceryLeveler;
    protected final ManaAbilityMessage activateMessage;
    protected final ManaAbilityMessage stopMessage;

    public ManaAbilityProvider(AureliumSkills plugin, MAbility mAbility, ManaAbilityMessage activateMessage, @Nullable ManaAbilityMessage stopMessage) {
        super(plugin, mAbility.getSkill());
        this.plugin = plugin;
        this.manager = plugin.getManaAbilityManager();
        this.mAbility = mAbility;
        this.skill = mAbility.getSkill();
        this.sorceryLeveler = plugin.getSorceryLeveler();
        this.activateMessage = activateMessage;
        this.stopMessage = stopMessage;
    }

    public void activate(final Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        int duration = this.getDuration(playerData);
        ManaAbilityActivateEvent event = new ManaAbilityActivateEvent(player, this.mAbility, duration);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.manager.setActivated(player, this.mAbility, true);
        this.onActivate(player, playerData);
        this.consumeMana(player, playerData);
        if (duration != 0) {
            new BukkitRunnable(){

                public void run() {
                    ManaAbilityProvider.this.stop(player);
                    ManaAbilityProvider.this.manager.setActivated(player, ManaAbilityProvider.this.mAbility, false);
                    ManaAbilityProvider.this.manager.setReady(player.getUniqueId(), ManaAbilityProvider.this.mAbility, false);
                }
            }.runTaskLater((Plugin)this.plugin, (long)duration);
        } else {
            this.stop(player);
            this.manager.setActivated(player, this.mAbility, false);
            this.manager.setReady(player.getUniqueId(), this.mAbility, false);
        }
    }

    public abstract void onActivate(Player var1, PlayerData var2);

    public void stop(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        this.onStop(player, playerData);
        this.manager.setPlayerCooldown(player, this.mAbility);
        if (this.stopMessage != null) {
            this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(this.stopMessage, this.plugin.getLang().getLocale(player)));
        }
    }

    public abstract void onStop(Player var1, PlayerData var2);

    protected int getDuration(PlayerData playerData) {
        return (int)Math.round(this.getValue(this.mAbility, playerData) * 20.0);
    }

    protected void consumeMana(Player player, PlayerData playerData) {
        double manaConsumed = this.manager.getManaCost(this.mAbility, playerData);
        playerData.setMana(playerData.getMana() - manaConsumed);
        this.sorceryLeveler.level(player, manaConsumed);
        this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(Lang.getMessage(this.activateMessage, playerData.getLocale()), "{mana}", NumberUtil.format0(manaConsumed)));
    }

    protected boolean hasEnoughMana(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return false;
        }
        Locale locale = playerData.getLocale();
        if (playerData.getMana() >= this.plugin.getManaAbilityManager().getManaCost(this.mAbility, playerData)) {
            return true;
        }
        this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(Lang.getMessage(ManaAbilityMessage.NOT_ENOUGH_MANA, locale), "{mana}", NumberUtil.format0(this.plugin.getManaAbilityManager().getManaCost(this.mAbility, playerData)), "{current_mana}", String.valueOf(Math.round(playerData.getMana())), "{max_mana}", String.valueOf(Math.round(playerData.getMaxMana()))));
        return false;
    }
}

