/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.api.event.ManaAbilityRefreshEvent;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.configuration.OptionValue;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityOption;
import com.archyx.aureliumskills.mana.ManaAbilityProvider;
import com.archyx.aureliumskills.skills.Skill;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class ManaAbilityManager
implements Listener {
    private final Map<UUID, Map<MAbility, Integer>> cooldowns;
    private final Map<UUID, Map<MAbility, Boolean>> ready;
    private final Map<UUID, Map<MAbility, Boolean>> activated;
    private final Map<UUID, Map<MAbility, Integer>> errorTimer;
    private final Map<MAbility, ManaAbilityProvider> providers;
    private final AureliumSkills plugin;

    public ManaAbilityManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.cooldowns = new HashMap<UUID, Map<MAbility, Integer>>();
        this.ready = new HashMap<UUID, Map<MAbility, Boolean>>();
        this.activated = new HashMap<UUID, Map<MAbility, Boolean>>();
        this.errorTimer = new HashMap<UUID, Map<MAbility, Integer>>();
        this.providers = new HashMap<MAbility, ManaAbilityProvider>();
    }

    public void init() {
        this.registerProviders();
        this.startTimer();
    }

    private void registerProviders() {
        for (MAbility mAbility : MAbility.values()) {
            Class<? extends ManaAbilityProvider> providerClass = mAbility.getProvider();
            if (providerClass == null) continue;
            try {
                Constructor<? extends ManaAbilityProvider> constructor = providerClass.getConstructor(AureliumSkills.class);
                ManaAbilityProvider provider = constructor.newInstance(new Object[]{this.plugin});
                this.register(provider);
                this.providers.put(mAbility, provider);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.plugin.getLogger().warning("Failed to register mana ability provider for " + mAbility.toString().toLowerCase(Locale.ROOT));
            }
        }
    }

    private void register(ManaAbilityProvider provider) {
        Bukkit.getPluginManager().registerEvents((Listener)provider, (Plugin)this.plugin);
    }

    @Nullable
    public ManaAbilityProvider getProvider(MAbility mAbility) {
        return this.providers.get(mAbility);
    }

    public void setActivated(Player player, MAbility mAbility, boolean isActivated) {
        Map map = this.activated.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        map.put(mAbility, isActivated);
    }

    public void setPlayerCooldown(UUID id, MAbility ability, int cooldown) {
        Map<MAbility, Integer> abilityCooldowns = this.cooldowns.get(id);
        if (abilityCooldowns != null) {
            abilityCooldowns.put(ability, cooldown);
        } else {
            abilityCooldowns = new HashMap<MAbility, Integer>();
            abilityCooldowns.put(ability, cooldown);
            this.cooldowns.put(id, abilityCooldowns);
        }
    }

    public void setPlayerCooldown(Player player, MAbility mAbility) {
        double cooldown;
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null && (cooldown = this.getCooldown(mAbility, playerData)) != 0.0) {
            this.setPlayerCooldown(player.getUniqueId(), mAbility, (int)(cooldown * 20.0));
        }
    }

    public int getPlayerCooldown(UUID id, MAbility ability) {
        Map<MAbility, Integer> abilityCooldowns = this.cooldowns.get(id);
        if (abilityCooldowns == null) {
            this.cooldowns.put(id, new HashMap());
            return 0;
        }
        Integer cooldown = abilityCooldowns.get(ability);
        if (cooldown != null) {
            return cooldown;
        }
        abilityCooldowns.put(ability, 0);
        return 0;
    }

    public boolean isReady(UUID id, MAbility ability) {
        Map<MAbility, Boolean> readyMap = this.ready.get(id);
        if (readyMap == null) {
            this.ready.put(id, new HashMap());
            return false;
        }
        Boolean readyValue = readyMap.get(ability);
        if (readyValue != null) {
            return readyValue;
        }
        readyMap.put(ability, false);
        return false;
    }

    public int getErrorTimer(UUID id, MAbility ability) {
        Map<MAbility, Integer> errorTimers = this.errorTimer.get(id);
        if (errorTimers == null) {
            this.errorTimer.put(id, new HashMap());
            return 0;
        }
        Integer timer = errorTimers.get(ability);
        if (timer != null) {
            return timer;
        }
        errorTimers.put(ability, 2);
        return 0;
    }

    public void setErrorTimer(UUID id, MAbility ability, int time) {
        Map errorTimers = this.errorTimer.computeIfAbsent(id, k -> new HashMap());
        errorTimers.put(ability, time);
    }

    public boolean isActivated(UUID id, MAbility ability) {
        Map<MAbility, Boolean> activatedMap = this.activated.get(id);
        if (activatedMap == null) {
            this.activated.put(id, new HashMap());
            return false;
        }
        Boolean activatedValue = activatedMap.get(ability);
        if (activatedValue != null) {
            return activatedValue;
        }
        activatedMap.put(ability, false);
        return false;
    }

    public void setReady(UUID id, MAbility ability, boolean isReady) {
        Map readyMap = this.ready.computeIfAbsent(id, k -> new HashMap());
        readyMap.put(ability, isReady);
    }

    private void startTimer() {
        new BukkitRunnable(){

            public void run() {
                for (UUID id : ManaAbilityManager.this.cooldowns.keySet()) {
                    Map abilityCooldowns = (Map)ManaAbilityManager.this.cooldowns.get(id);
                    if (abilityCooldowns != null) {
                        for (MAbility ab : abilityCooldowns.keySet()) {
                            PlayerData playerData;
                            int cooldown = (Integer)abilityCooldowns.get(ab);
                            if (cooldown >= 2) {
                                abilityCooldowns.put(ab, cooldown - 2);
                            } else if (cooldown == 1) {
                                abilityCooldowns.put(ab, 0);
                            }
                            if (cooldown != 2 && cooldown != 1 || (playerData = ManaAbilityManager.this.plugin.getPlayerManager().getPlayerData(id)) == null) continue;
                            ManaAbilityRefreshEvent event = new ManaAbilityRefreshEvent(playerData.getPlayer(), ab);
                            Bukkit.getPluginManager().callEvent((Event)event);
                        }
                        continue;
                    }
                    ManaAbilityManager.this.cooldowns.put(id, new HashMap());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        new BukkitRunnable(){

            public void run() {
                for (UUID id : ManaAbilityManager.this.errorTimer.keySet()) {
                    Map errorTimers = (Map)ManaAbilityManager.this.errorTimer.get(id);
                    if (errorTimers != null) {
                        for (MAbility ab : errorTimers.keySet()) {
                            int timer = (Integer)errorTimers.get(ab);
                            if (timer <= 0) continue;
                            errorTimers.put(ab, timer - 1);
                        }
                        continue;
                    }
                    ManaAbilityManager.this.errorTimer.put(id, new HashMap());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        UUID id = event.getPlayer().getUniqueId();
        if (!this.cooldowns.containsKey(id)) {
            this.cooldowns.put(id, new HashMap());
        }
        if (!this.ready.containsKey(id)) {
            this.ready.put(id, new HashMap());
        }
        if (!this.activated.containsKey(id)) {
            this.activated.put(id, new HashMap());
        }
        if (!this.errorTimer.containsKey(id)) {
            this.errorTimer.put(id, new HashMap());
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Map<MAbility, Boolean> activatedMap;
        UUID id = event.getPlayer().getUniqueId();
        Map<MAbility, Integer> abilityCooldowns = this.cooldowns.get(id);
        if (abilityCooldowns != null) {
            boolean noCooldowns = true;
            for (Integer cooldown : abilityCooldowns.values()) {
                if (cooldown == 0) continue;
                noCooldowns = false;
                break;
            }
            if (noCooldowns) {
                this.cooldowns.remove(id);
            }
        }
        if ((activatedMap = this.activated.get(id)) != null) {
            boolean noneActivated = true;
            for (Boolean activated : activatedMap.values()) {
                if (!activated.booleanValue()) continue;
                noneActivated = false;
                break;
            }
            if (noneActivated) {
                this.activated.remove(id);
            }
        }
        this.ready.remove(id);
        this.errorTimer.remove(id);
    }

    public double getValue(MAbility mAbility, int level) {
        return this.getBaseValue(mAbility) + this.getValuePerLevel(mAbility) * (double)(level - 1);
    }

    public double getValue(MAbility mAbility, PlayerData playerData) {
        return this.getValue(mAbility, playerData.getManaAbilityLevel(mAbility));
    }

    public double getDisplayValue(MAbility mAbility, int level) {
        if (mAbility == MAbility.SHARP_HOOK && this.getOptionAsBooleanElseTrue(mAbility, "display_damage_with_scaling")) {
            return this.getValue(mAbility, level) * OptionL.getDouble(Option.HEALTH_HP_INDICATOR_SCALING);
        }
        return this.getValue(mAbility, level);
    }

    public double getBaseValue(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getBaseValue();
        }
        return mAbility.getDefaultBaseValue();
    }

    public double getValuePerLevel(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getValuePerLevel();
        }
        return mAbility.getDefaultValuePerLevel();
    }

    public double getCooldown(MAbility mAbility, int level) {
        double cooldown = this.getBaseCooldown(mAbility) + this.getCooldownPerLevel(mAbility) * (double)(level - 1);
        return cooldown > 0.0 ? cooldown : 0.0;
    }

    public double getCooldown(MAbility mAbility, PlayerData playerData) {
        double cooldown = this.getBaseCooldown(mAbility) + this.getCooldownPerLevel(mAbility) * (double)(playerData.getManaAbilityLevel(mAbility) - 1);
        return cooldown > 0.0 ? cooldown : 0.0;
    }

    public double getBaseCooldown(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getBaseCooldown();
        }
        return mAbility.getDefaultBaseCooldown();
    }

    public double getCooldownPerLevel(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getCooldownPerLevel();
        }
        return mAbility.getDefaultCooldownPerLevel();
    }

    public double getManaCost(MAbility mAbility, PlayerData playerData) {
        return this.getBaseManaCost(mAbility) + this.getManaCostPerLevel(mAbility) * (double)(playerData.getManaAbilityLevel(mAbility) - 1);
    }

    public double getManaCost(MAbility mAbility, int level) {
        return this.getBaseManaCost(mAbility) + this.getManaCostPerLevel(mAbility) * (double)(level - 1);
    }

    public double getBaseManaCost(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getBaseManaCost();
        }
        return mAbility.getDefaultBaseManaCost();
    }

    public double getManaCostPerLevel(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getManaCostPerLevel();
        }
        return mAbility.getDefaultManaCostPerLevel();
    }

    public int getUnlock(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getUnlock();
        }
        return 7;
    }

    public int getLevelUp(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getLevelUp();
        }
        return 7;
    }

    public int getMaxLevel(MAbility mAbility) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getMaxLevel();
        }
        return 0;
    }

    @Nullable
    public MAbility getManaAbility(Skill skill, int level) {
        MAbility mAbility = skill.getManaAbility();
        if (mAbility != null && level >= this.getUnlock(mAbility) && (level - this.getUnlock(mAbility)) % this.getLevelUp(mAbility) == 0) {
            return mAbility;
        }
        return null;
    }

    @Nullable
    public OptionValue getOption(MAbility mAbility, String key) {
        ManaAbilityOption option = this.plugin.getAbilityManager().getAbilityOption(mAbility);
        if (option != null) {
            return option.getOption(key);
        }
        return mAbility.getDefaultOptions().get(key);
    }

    public boolean getOptionAsBooleanElseTrue(MAbility mAbility, String key) {
        OptionValue value = this.getOption(mAbility, key);
        if (value != null) {
            return value.asBoolean();
        }
        return true;
    }

    public boolean getOptionAsBooleanElseFalse(MAbility mAbility, String key) {
        OptionValue value = this.getOption(mAbility, key);
        if (value != null) {
            return value.asBoolean();
        }
        return false;
    }

    public int getOptionAsInt(MAbility mAbility, String key, int defaultValue) {
        OptionValue value = this.getOption(mAbility, key);
        if (value != null) {
            return value.asInt();
        }
        return defaultValue;
    }

    public double getOptionAsDouble(MAbility mAbility, String key) {
        OptionValue value = this.getOption(mAbility, key);
        if (value != null) {
            return value.asDouble();
        }
        return mAbility.getDefaultOptions().get(key).asDouble();
    }

    @Nullable
    public Set<String> getOptionKeys(MAbility mAbility) {
        if (mAbility.getDefaultOptions() != null) {
            return mAbility.getDefaultOptions().keySet();
        }
        return null;
    }
}

