/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.ability.AbstractAbility;
import com.archyx.aureliumskills.configuration.OptionValue;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.Absorption;
import com.archyx.aureliumskills.mana.ChargedShot;
import com.archyx.aureliumskills.mana.LightningBlade;
import com.archyx.aureliumskills.mana.ManaAbilityProvider;
import com.archyx.aureliumskills.mana.Replenish;
import com.archyx.aureliumskills.mana.SharpHook;
import com.archyx.aureliumskills.mana.SpeedMine;
import com.archyx.aureliumskills.mana.Terraform;
import com.archyx.aureliumskills.mana.Treecapitator;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public enum MAbility implements AbstractAbility
{
    REPLENISH(() -> Skills.FARMING, 5.0, 5.0, 200.0, -5.0, 20, 20, new String[]{"require_sneak", "check_offhand", "sneak_offhand_bypass", "replant_delay", "show_particles", "prevent_unripe_break"}, new Object[]{false, true, true, 4, true, true}, Replenish.class),
    TREECAPITATOR(() -> Skills.FORAGING, 5.0, 5.0, 200.0, -5.0, 20, 20, new String[]{"require_sneak", "check_offhand", "sneak_offhand_bypass", "max_blocks_multiplier"}, new Object[]{false, true, true, 1.0}, Treecapitator.class),
    SPEED_MINE(() -> Skills.MINING, 5.0, 5.0, 200.0, -5.0, 20, 20, new String[]{"require_sneak", "check_offhand", "sneak_offhand_bypass", "haste_level"}, new Object[]{false, true, true, 10}, SpeedMine.class),
    SHARP_HOOK(() -> Skills.FISHING, 0.5, 0.5, 2.0, -0.1, 5, 2, new String[]{"display_damage_with_scaling", "enable_sound"}, new Object[]{true, true}, SharpHook.class),
    TERRAFORM(() -> Skills.EXCAVATION, 5.0, 4.0, 200.0, -5.0, 20, 20, new String[]{"require_sneak", "check_offhand", "sneak_offhand_bypass"}, new Object[]{false, true, true}, Terraform.class),
    CHARGED_SHOT(() -> Skills.ARCHERY, 0.5, 0.3, 0.0, 0.0, 5, 5, new String[]{"enable_message", "enable_sound"}, new Object[]{true, true}, ChargedShot.class),
    ABSORPTION(() -> Skills.DEFENSE, 2.0, 3.0, 200.0, -5.0, 10, 10, new String[]{"enable_particles"}, new Object[]{true}, Absorption.class),
    LIGHTNING_BLADE(() -> Skills.FIGHTING, 5.0, 5.0, 200.0, -5.0, 20, 20, new String[]{"base_duration", "duration_per_level"}, new Object[]{5.0, 4.0}, LightningBlade.class);

    private final Supplier<Skill> skill;
    private final double baseValue;
    private final double valuePerLevel;
    private final double baseCooldown;
    private final double cooldownPerLevel;
    private final int baseManaCost;
    private final int manaCostPerLevel;
    private Map<String, OptionValue> options;
    private Class<? extends ManaAbilityProvider> provider;

    private MAbility(Supplier<Skill> skill, double baseValue, double valuePerLevel, double baseCooldown, double cooldownPerLevel, int baseManaCost, int manaCostPerLevel) {
        this.skill = skill;
        this.baseValue = baseValue;
        this.valuePerLevel = valuePerLevel;
        this.baseCooldown = baseCooldown;
        this.cooldownPerLevel = cooldownPerLevel;
        this.baseManaCost = baseManaCost;
        this.manaCostPerLevel = manaCostPerLevel;
    }

    private MAbility(Supplier<Skill> skill, double baseValue, double valuePerLevel, double baseCooldown, double cooldownPerLevel, int baseManaCost, int manaCostPerLevel, String[] optionKeys, Object[] optionValues) {
        this(skill, baseValue, valuePerLevel, baseCooldown, cooldownPerLevel, baseManaCost, manaCostPerLevel);
        this.options = new HashMap<String, OptionValue>();
        for (int i = 0; i < optionKeys.length; ++i) {
            if (i >= optionValues.length) continue;
            this.options.put(optionKeys[i], new OptionValue(optionValues[i]));
        }
    }

    private MAbility(Supplier<Skill> skill, double baseValue, double valuePerLevel, double baseCooldown, double cooldownPerLevel, int baseManaCost, int manaCostPerLevel, String[] optionKeys, Object[] optionValues, Class<? extends ManaAbilityProvider> provider) {
        this(skill, baseValue, valuePerLevel, baseCooldown, cooldownPerLevel, baseManaCost, manaCostPerLevel, optionKeys, optionValues);
        this.provider = provider;
    }

    @Override
    public Skill getSkill() {
        return this.skill.get();
    }

    @Override
    public double getDefaultBaseValue() {
        return this.baseValue;
    }

    @Override
    public double getDefaultValuePerLevel() {
        return this.valuePerLevel;
    }

    public double getDefaultCooldown(int level) {
        double cooldown = this.getDefaultBaseCooldown() + this.getDefaultCooldownPerLevel() * (double)(level - 1);
        return cooldown > 0.0 ? cooldown : 0.0;
    }

    public double getDefaultBaseCooldown() {
        return this.baseCooldown;
    }

    public double getDefaultCooldownPerLevel() {
        return this.cooldownPerLevel;
    }

    public int getDefaultManaCost(int level) {
        return this.getDefaultBaseManaCost() + this.getDefaultManaCostPerLevel() * (level - 1);
    }

    public int getDefaultBaseManaCost() {
        return this.baseManaCost;
    }

    public int getDefaultManaCostPerLevel() {
        return this.manaCostPerLevel;
    }

    public int getDefaultUnlock() {
        return 7;
    }

    public int getDefaultLevelUp() {
        return 7;
    }

    public int getDefaultMaxLevel() {
        return 0;
    }

    public String getDisplayName(Locale locale) {
        return Lang.getMessage(ManaAbilityMessage.valueOf(this.name().toUpperCase() + "_NAME"), locale);
    }

    public String getDescription(Locale locale) {
        return Lang.getMessage(ManaAbilityMessage.valueOf(this.name().toUpperCase() + "_DESC"), locale);
    }

    public Map<String, OptionValue> getDefaultOptions() {
        return this.options;
    }

    @Nullable
    public Class<? extends ManaAbilityProvider> getProvider() {
        return this.provider;
    }
}

