/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ReadiedManaAbility;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.xseries.XMaterial;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class LightningBlade
extends ReadiedManaAbility {
    public LightningBlade(AureliumSkills plugin) {
        super(plugin, MAbility.LIGHTNING_BLADE, ManaAbilityMessage.LIGHTNING_BLADE_START, ManaAbilityMessage.LIGHTNING_BLADE_END, new String[]{"SWORD"}, new Action[]{Action.RIGHT_CLICK_AIR, Action.RIGHT_CLICK_BLOCK});
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void activationListener(EntityDamageByEntityEvent event) {
        if (!OptionL.isEnabled(Skills.FIGHTING)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (this.blockAbility(player)) {
            return;
        }
        if (!this.isHoldingMaterial(player)) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (this.isActivated(player)) {
            return;
        }
        if (this.isReady(player)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (this.hasEnoughMana(player)) {
                this.activate(player);
            }
        }
    }

    @Override
    protected int getDuration(PlayerData playerData) {
        double baseDuration = this.manager.getOptionAsDouble(this.mAbility, "base_duration");
        double durationPerLevel = this.manager.getOptionAsDouble(this.mAbility, "duration_per_level");
        double durationSeconds = baseDuration + durationPerLevel * (double)(playerData.getManaAbilityLevel(this.mAbility) - 1);
        return (int)Math.round(durationSeconds * 20.0);
    }

    @Override
    public void onActivate(Player player, PlayerData playerData) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attribute == null) {
            return;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!modifier.getName().equals("AureliumSkills-LightningBlade")) continue;
            attribute.removeModifier(modifier);
        }
        double currentValue = attribute.getValue();
        double addedValue = this.plugin.getManaAbilityManager().getValue(MAbility.LIGHTNING_BLADE, playerData) / 100.0 * currentValue;
        attribute.addModifier(new AttributeModifier("AureliumSkills-LightningBlade", addedValue, AttributeModifier.Operation.ADD_NUMBER));
        if (XMaterial.isNewVersion()) {
            player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 0.5f, 1.0f);
        } else {
            player.playSound(player.getLocation(), "entity.illusion_illager.prepare_mirror", 0.5f, 1.0f);
        }
    }

    @Override
    public void onStop(Player player, PlayerData playerData) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attribute == null) {
            return;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!modifier.getName().equals("AureliumSkills-LightningBlade")) continue;
            attribute.removeModifier(modifier);
        }
    }

    @EventHandler
    public void lightningBladeJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getManaAbilityManager().isActivated(player.getUniqueId(), MAbility.LIGHTNING_BLADE)) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attribute == null) {
            return;
        }
        for (AttributeModifier modifier : attribute.getModifiers()) {
            if (!modifier.getName().equals("AureliumSkills-LightningBlade")) continue;
            attribute.removeModifier(modifier);
        }
    }
}

