/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.AbilityData;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityManager;
import com.archyx.aureliumskills.mana.ManaAbilityProvider;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChargedShot
extends ManaAbilityProvider {
    public ChargedShot(AureliumSkills plugin) {
        super(plugin, MAbility.CHARGED_SHOT, ManaAbilityMessage.CHARGED_SHOT_SHOOT, null);
        this.tickChargedShotCooldown();
    }

    @EventHandler
    public void onToggle(PlayerInteractEvent event) {
        if (this.blockDisabled(MAbility.CHARGED_SHOT)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (item.getType() != Material.BOW) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getManaAbilityLevel(MAbility.CHARGED_SHOT) == 0) {
                return;
            }
            Locale locale = playerData.getLocale();
            AbilityData abilityData = playerData.getAbilityData(MAbility.CHARGED_SHOT);
            if (abilityData.getInt("cooldown") == 0) {
                if (!abilityData.getBoolean("enabled")) {
                    abilityData.setData("enabled", true);
                    this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(ManaAbilityMessage.CHARGED_SHOT_ENABLE, locale));
                } else {
                    abilityData.setData("enabled", false);
                    this.plugin.getAbilityManager().sendMessage(player, Lang.getMessage(ManaAbilityMessage.CHARGED_SHOT_DISABLE, locale));
                }
                abilityData.setData("cooldown", 8);
            }
        }
    }

    private void tickChargedShotCooldown() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    AbilityData abilityData;
                    int cooldown;
                    PlayerData playerData = ChargedShot.this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null || !playerData.containsAbilityData(MAbility.CHARGED_SHOT) || (cooldown = (abilityData = playerData.getAbilityData(MAbility.CHARGED_SHOT)).getInt("cooldown")) == 0) continue;
                    abilityData.setData("cooldown", cooldown - 1);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 3L, 5L);
    }

    @EventHandler
    public void activationListener(EntityShootBowEvent event) {
        if (this.blockDisabled(MAbility.CHARGED_SHOT)) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.blockAbility(player)) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getAbilityData(MAbility.CHARGED_SHOT).getBoolean("enabled")) {
                if (playerData.getManaAbilityLevel(MAbility.CHARGED_SHOT) == 0) {
                    return;
                }
                ManaAbilityManager manager = this.plugin.getManaAbilityManager();
                int cooldown = manager.getPlayerCooldown(player.getUniqueId(), MAbility.SHARP_HOOK);
                if (cooldown == 0) {
                    playerData.getMetadata().put("charged_shot_projectile", event.getProjectile());
                    playerData.getMetadata().put("charged_shot_force", Float.valueOf(event.getForce()));
                    this.activate(player);
                } else if (manager.getErrorTimer(player.getUniqueId(), MAbility.SHARP_HOOK) == 0) {
                    Locale locale = playerData.getLocale();
                    this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(Lang.getMessage(ManaAbilityMessage.NOT_READY, locale), "{cooldown}", NumberUtil.format1((double)cooldown / 20.0)));
                    manager.setErrorTimer(player.getUniqueId(), MAbility.SHARP_HOOK, 2);
                }
            }
        }
    }

    public void applyChargedShot(EntityDamageByEntityEvent event) {
        if (event.getDamager().hasMetadata("ChargedShotMultiplier")) {
            double multiplier = ((MetadataValue)event.getDamager().getMetadata("ChargedShotMultiplier").get(0)).asDouble();
            event.setDamage(event.getDamage() * multiplier);
        }
    }

    @Override
    public void onActivate(Player player, PlayerData playerData) {
        double manaConsumed = this.getManaConsumed(playerData);
        if (manaConsumed <= 0.0) {
            return;
        }
        double damagePercent = manaConsumed * this.plugin.getManaAbilityManager().getValue(MAbility.CHARGED_SHOT, playerData);
        Object obj = playerData.getMetadata().get("charged_shot_projectile");
        if (!(obj instanceof Entity)) {
            return;
        }
        Entity projectile = (Entity)obj;
        projectile.setMetadata("ChargedShotMultiplier", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)(1.0 + damagePercent / 100.0)));
        if (this.plugin.getManaAbilityManager().getOptionAsBooleanElseTrue(MAbility.CHARGED_SHOT, "enable_sound")) {
            if (XMaterial.isNewVersion()) {
                player.playSound(player.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, 0.5f, 1.0f);
            } else {
                player.playSound(player.getLocation(), "entity.evocation_illager.cast_spell", 0.5f, 1.0f);
            }
        }
    }

    @Override
    public void onStop(Player player, PlayerData playerData) {
        playerData.getMetadata().remove("charged_shot_projectile");
        playerData.getMetadata().remove("charged_shot_force");
    }

    @Override
    protected void consumeMana(Player player, PlayerData playerData) {
        double manaConsumed = this.getManaConsumed(playerData);
        if (manaConsumed <= 0.0) {
            return;
        }
        double damagePercent = manaConsumed * this.plugin.getManaAbilityManager().getValue(MAbility.CHARGED_SHOT, playerData);
        playerData.setMana(playerData.getMana() - manaConsumed);
        this.sorceryLeveler.level(player, manaConsumed);
        if (this.plugin.getManaAbilityManager().getOptionAsBooleanElseTrue(MAbility.CHARGED_SHOT, "enable_message")) {
            this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(Lang.getMessage(this.activateMessage, playerData.getLocale()), "{mana}", NumberUtil.format0(manaConsumed), "{percent}", NumberUtil.format0(damagePercent)));
        }
    }

    private double getManaConsumed(PlayerData playerData) {
        Object obj = playerData.getMetadata().get("charged_shot_force");
        float force = 0.0f;
        if (obj instanceof Float) {
            force = ((Float)obj).floatValue();
        }
        return Math.min(this.manager.getManaCost(MAbility.CHARGED_SHOT, playerData) * (double)force, playerData.getMana());
    }

    @Override
    protected int getDuration(PlayerData playerData) {
        return 0;
    }
}

