/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.mana;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.ManaAbilityMessage;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ReadiedManaAbility;
import com.archyx.aureliumskills.xseries.XMaterial;
import com.archyx.aureliumskills.xseries.particles.ParticleDisplay;
import com.archyx.aureliumskills.xseries.particles.XParticle;
import java.awt.Color;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class Absorption
extends ReadiedManaAbility {
    public Absorption(AureliumSkills plugin) {
        super(plugin, MAbility.ABSORPTION, ManaAbilityMessage.ABSORPTION_START, ManaAbilityMessage.ABSORPTION_END, new String[]{"SHIELD"}, new Action[]{Action.LEFT_CLICK_AIR, Action.LEFT_CLICK_BLOCK});
    }

    @Override
    public void onActivate(Player player, PlayerData playerData) {
        playerData.getAbilityData(MAbility.ABSORPTION).setData("activated", true);
        if (XMaterial.isNewVersion()) {
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.0f);
        } else {
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
    }

    @Override
    public void onStop(Player player, PlayerData playerData) {
        playerData.getAbilityData(MAbility.ABSORPTION).setData("activated", false);
    }

    public void handleAbsorption(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        if (playerData.getAbilityData(MAbility.ABSORPTION).getBoolean("activated") && this.isActivated(player)) {
            this.handleAbsorbedHit(event, player, playerData);
        } else if (this.isReady(player)) {
            if (this.isActivated(player)) {
                return;
            }
            if (this.hasEnoughMana(player)) {
                this.activate(player);
                this.handleAbsorbedHit(event, player, playerData);
            }
        }
    }

    private void handleAbsorbedHit(EntityDamageByEntityEvent event, Player player, PlayerData playerData) {
        double mana = playerData.getMana() - event.getDamage() * 2.0;
        if (mana > 0.0) {
            playerData.setMana(mana);
            event.setCancelled(true);
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GUARDIAN_HURT, 1.0f, 1.0f);
            if (this.plugin.getManaAbilityManager().getOptionAsBooleanElseTrue(MAbility.ABSORPTION, "enable_particles")) {
                XParticle.circle(1.0, 1.0, 1.0, 20.0, 0.0, ParticleDisplay.colored(player.getLocation().add(0.0, 1.0, 0.0), Color.MAGENTA, 1.0f));
            }
        }
    }
}

