/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.loot.parser;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.loot.Loot;
import com.archyx.aureliumskills.source.Source;
import com.archyx.aureliumskills.source.SourceTag;
import com.archyx.aureliumskills.util.misc.Parser;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class LootParser
extends Parser {
    protected final AureliumSkills plugin;

    public LootParser(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public abstract Loot parse(Map<?, ?> var1);

    protected int parseWeight(Map<?, ?> map) {
        if (map.containsKey("weight")) {
            return this.getInt(map, "weight");
        }
        return 10;
    }

    protected String parseMessage(Map<?, ?> map) {
        if (map.containsKey("message")) {
            return TextUtil.replace(this.getString(map, "message"), "&", "\u00a7");
        }
        return "";
    }

    @NotNull
    protected Set<Source> parseSources(Map<?, ?> map) {
        if (map.containsKey("sources")) {
            HashSet<Source> sources = new HashSet<Source>();
            for (String entry : this.getStringList(map, "sources")) {
                Source source = this.plugin.getSourceRegistry().valueOf(entry);
                if (source != null) {
                    sources.add(source);
                    continue;
                }
                SourceTag tag = SourceTag.valueOf(entry.toUpperCase(Locale.ROOT));
                sources.addAll(this.plugin.getSourceManager().getTag(tag));
            }
            return sources;
        }
        return new HashSet<Source>();
    }

    protected double parseXp(Map<?, ?> map) {
        if (map.containsKey("xp")) {
            return this.getDouble(map, "xp");
        }
        return -1.0;
    }
}

