/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.loot.parser;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.loot.Loot;
import com.archyx.aureliumskills.loot.builder.ItemLootBuilder;
import com.archyx.aureliumskills.loot.parser.LootParser;
import com.archyx.aureliumskills.nbtapi.NBTItem;
import com.archyx.aureliumskills.util.item.MaterialUtil;
import com.archyx.aureliumskills.util.misc.Validate;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.xseries.XEnchantment;
import com.archyx.aureliumskills.xseries.XMaterial;
import dev.dbassett.skullcreator.SkullCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemLootParser
extends LootParser {
    public ItemLootParser(AureliumSkills plugin) {
        super(plugin);
    }

    @Override
    public Loot parse(Map<?, ?> map) {
        ItemStack item = this.parseItem(map);
        Validate.notNull(item, "Failed to parse item");
        int[] amount = this.parseAmount(map);
        return new ItemLootBuilder(this.plugin).item(item).minAmount(amount[0]).maxAmount(amount[1]).message(this.parseMessage(map)).weight(this.parseWeight(map)).sources(this.parseSources(map)).xp(this.parseXp(map)).build();
    }

    private ItemStack parseItem(Map<?, ?> map) {
        ItemStack item;
        if (map.containsKey("key")) {
            return this.parseItemKey(map);
        }
        String materialString = this.getString(map, "material");
        if (!materialString.contains(":")) {
            String materialName = materialString.toUpperCase(Locale.ROOT);
            Material material = MaterialUtil.parse(materialName);
            if (material == null) {
                throw new IllegalArgumentException("Unknown material " + materialString);
            }
            item = new ItemStack(material);
        } else {
            String[] splitMaterial = materialString.split(":");
            if (splitMaterial.length == 2) {
                String materialName = splitMaterial[0].toUpperCase(Locale.ROOT);
                Material material = MaterialUtil.parse(materialName);
                if (material == null) {
                    throw new IllegalArgumentException("Unknown material " + materialName);
                }
                short s = NumberUtils.toShort((String)splitMaterial[1]);
                item = new ItemStack(material, 1, s);
            } else {
                throw new IllegalArgumentException("Material with data value can only have one :");
            }
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (map.containsKey("display_name")) {
            meta = item.getItemMeta();
            String displayName = TextUtil.replaceNonEscaped(this.getString(map, "display_name"), "&", "\u00a7");
            meta.setDisplayName(displayName);
            item.setItemMeta(meta);
        }
        if (map.containsKey("lore")) {
            meta = item.getItemMeta();
            List<String> lore = this.getStringList(map, "lore");
            ArrayList formattedLore = new ArrayList();
            for (String line : lore) {
                formattedLore.add(TextUtil.replaceNonEscaped(line, "&", "\u00a7"));
            }
            meta.setLore((List)formattedLore);
            item.setItemMeta(meta);
        }
        if (map.containsKey("enchantments")) {
            meta = item.getItemMeta();
            List<String> enchantmentStrings = this.getStringList(map, "enchantments");
            for (String string : enchantmentStrings) {
                Optional<XEnchantment> xEnchantment;
                String[] splitEntry = string.split(" ");
                String enchantmentName = splitEntry[0];
                int level = 1;
                if (splitEntry.length > 1) {
                    level = NumberUtils.toInt((String)splitEntry[1], (int)1);
                }
                if ((xEnchantment = XEnchantment.matchXEnchantment(enchantmentName.toUpperCase(Locale.ROOT))).isPresent()) {
                    Enchantment enchantment = xEnchantment.get().parseEnchantment();
                    if (enchantment != null) {
                        if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
                            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                            esm.addStoredEnchant(enchantment, level, true);
                            item.setItemMeta((ItemMeta)esm);
                            continue;
                        }
                        meta.addEnchant(enchantment, level, true);
                        item.setItemMeta(meta);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid enchantment name " + enchantmentName);
                }
                throw new IllegalArgumentException("Invalid enchantment name " + enchantmentName);
            }
        }
        if (map.containsKey("potion_data")) {
            Map<?, ?> potionDataMap = this.getMap(map, "potion_data");
            PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
            PotionType potionType = PotionType.valueOf((String)this.getString(potionDataMap, "type").toUpperCase(Locale.ROOT));
            boolean extended = false;
            if (potionDataMap.containsKey("extended")) {
                extended = this.getBoolean(potionDataMap, "extended");
            }
            boolean upgraded = false;
            if (potionDataMap.containsKey("upgraded")) {
                upgraded = this.getBoolean(potionDataMap, "upgraded");
            }
            PotionData potionData = new PotionData(potionType, extended, upgraded);
            potionMeta.setBasePotionData(potionData);
            item.setItemMeta((ItemMeta)potionMeta);
        }
        if (map.containsKey("custom_effects")) {
            PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
            for (Map map2 : this.getMapList(map, "custom_effects")) {
                String effectName = this.getString(map2, "type");
                PotionEffectType type = PotionEffectType.getByName((String)effectName);
                if (type != null) {
                    int duration = this.getInt(map2, "duration");
                    int amplifier = this.getInt(map2, "amplifier");
                    potionMeta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
                    potionMeta.setColor(type.getColor());
                    continue;
                }
                throw new IllegalArgumentException("Invalid potion effect type " + effectName);
            }
            item.setItemMeta((ItemMeta)potionMeta);
        }
        if (this.getBooleanOrDefault(map, "glow", false)) {
            meta = item.getItemMeta();
            meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
        if (map.containsKey("flags")) {
            meta = item.getItemMeta();
            List<String> flags = this.getStringList(map, "flags");
            for (String string : flags) {
                ItemFlag itemFlag = ItemFlag.valueOf((String)string.toUpperCase(Locale.ROOT));
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
            item.setItemMeta(meta);
        }
        if (map.containsKey("durability")) {
            meta = item.getItemMeta();
            int durability = this.getInt(map, "durability");
            if (XMaterial.isNewVersion()) {
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    short s = item.getType().getMaxDurability();
                    damageable.setDamage(Math.min(s - durability, s));
                    item.setItemMeta(meta);
                }
            } else {
                short maxDurability = item.getType().getMaxDurability();
                item.setDurability((short)Math.max(maxDurability - durability, maxDurability));
            }
        }
        if (map.containsKey("skull_meta")) {
            this.parseSkullMeta(item, item.getItemMeta(), this.getMap(map, "skull_meta"));
        }
        if (map.containsKey("nbt")) {
            Map<?, ?> nbtMap = this.getMap(map, "nbt");
            item = this.parseNBT(item, nbtMap);
        }
        return item;
    }

    private void parseSkullMeta(ItemStack item, ItemMeta meta, Map<?, ?> map) {
        if (!(meta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        if (map.containsKey("uuid")) {
            UUID id = UUID.fromString(this.getString(map, "uuid"));
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
            item.setItemMeta(meta);
        }
        if (map.containsKey("base64")) {
            SkullCreator.itemWithBase64(item, this.getString(map, "base64"));
        }
        if (map.containsKey("url")) {
            SkullCreator.itemWithUrl(item, this.getString(map, "url"));
        }
    }

    private ItemStack parseItemKey(Map<?, ?> map) {
        String itemKey = this.getString(map, "key");
        ItemStack item = this.plugin.getItemRegistry().getItem(itemKey);
        if (item != null) {
            return item;
        }
        throw new IllegalArgumentException("Item with key " + itemKey + " not found in item registry");
    }

    private ItemStack parseNBT(ItemStack item, Map<?, ?> map) {
        NBTItem nbtItem = new NBTItem(item);
        this.applyMapToNBT(nbtItem, map);
        return nbtItem.getItem();
    }

    private void applyMapToNBT(NBTItem item, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) continue;
            if (value instanceof Map) {
                this.applyMapToNBT(item, (Map)value);
                continue;
            }
            item.setObject((String)key, value);
        }
    }

    protected int[] parseAmount(Map<?, ?> map) {
        if (map.containsKey("amount")) {
            Object object = this.getElement(map, "amount");
            if (object instanceof Integer) {
                Integer amount = (Integer)object;
                return new int[]{amount, amount};
            }
            if (object instanceof String) {
                int minAmount;
                String amountString = (String)object;
                String[] splitString = amountString.split("-");
                int maxAmount = minAmount = NumberUtils.toInt((String)splitString[0]);
                if (splitString.length > 1) {
                    maxAmount = NumberUtils.toInt((String)splitString[1], (int)minAmount);
                }
                return new int[]{minAmount, maxAmount};
            }
        }
        return new int[]{1, 1};
    }
}

