/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.loot.handler;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityProvider;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.commands.CommandExecutor;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.CustomMessageKey;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.loot.Loot;
import com.archyx.aureliumskills.loot.LootPool;
import com.archyx.aureliumskills.loot.type.CommandLoot;
import com.archyx.aureliumskills.loot.type.ItemLoot;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.source.Source;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class LootHandler
extends AbilityProvider {
    private final Random random = new Random();
    private final Ability ability;

    public LootHandler(AureliumSkills plugin, Skill skill, Ability ability) {
        super(plugin, skill);
        this.ability = ability;
    }

    protected void giveCommandLoot(Player player, CommandLoot loot, Source source) {
        CommandExecutor executor;
        String finalCommand = TextUtil.replace(loot.getCommand(), "{player}", player.getName());
        if (this.plugin.isPlaceholderAPIEnabled()) {
            finalCommand = PlaceholderAPI.setPlaceholders((Player)player, (String)finalCommand);
        }
        if ((executor = loot.getExecutor()) == CommandExecutor.CONSOLE) {
            Bukkit.dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), (String)finalCommand);
        } else if (executor == CommandExecutor.PLAYER) {
            Bukkit.dispatchCommand((CommandSender)player, (String)finalCommand);
        }
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source);
    }

    protected void giveBlockItemLoot(Player player, ItemLoot loot, BlockBreakEvent event, @Nullable Source source, LootDropCause cause) {
        Block block = event.getBlock();
        ItemStack drop = loot.getItem().clone();
        drop.setAmount(this.generateAmount(loot.getMinAmount(), loot.getMaxAmount()));
        Location location = block.getLocation().add(0.5, 0.5, 0.5);
        PlayerLootDropEvent dropEvent = new PlayerLootDropEvent(player, drop, location, cause);
        if (cause != null) {
            Bukkit.getPluginManager().callEvent((Event)dropEvent);
            if (dropEvent.isCancelled()) {
                return;
            }
        }
        if (dropEvent.getItemStack().getType() == Material.AIR) {
            return;
        }
        block.getWorld().dropItem(dropEvent.getLocation(), dropEvent.getItemStack());
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source);
    }

    protected void giveFishingItemLoot(Player player, ItemLoot loot, PlayerFishEvent event, @Nullable Source source, LootDropCause cause) {
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        Item itemEntity = (Item)event.getCaught();
        int amount = this.generateAmount(loot.getMinAmount(), loot.getMaxAmount());
        if (amount == 0) {
            return;
        }
        ItemStack drop = loot.getItem().clone();
        drop.setAmount(amount);
        Location location = event.getCaught().getLocation();
        PlayerLootDropEvent dropEvent = new PlayerLootDropEvent(player, drop, location, cause);
        if (cause != null) {
            Bukkit.getPluginManager().callEvent((Event)dropEvent);
            if (dropEvent.isCancelled()) {
                return;
            }
        }
        itemEntity.setItemStack(drop);
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Loot selectLoot(LootPool pool, @Nullable Source source) {
        ArrayList<Loot> lootList = new ArrayList<Loot>();
        block0: for (Loot loot : pool.getLoot()) {
            if (loot.getSources().size() > 0 && source != null) {
                for (Source lootSource : loot.getSources()) {
                    if (!lootSource.equals(source)) continue;
                    lootList.add(loot);
                    continue block0;
                }
                continue;
            }
            lootList.add(loot);
        }
        int totalWeight = 0;
        for (Loot loot : lootList) {
            totalWeight += loot.getWeight();
        }
        if (totalWeight == 0) {
            return null;
        }
        int n = this.random.nextInt(totalWeight);
        boolean bl = false;
        Loot selectedLoot = null;
        for (Loot loot : lootList) {
            void var6_13;
            if (n >= var6_13 && n < var6_13 + loot.getWeight()) {
                selectedLoot = loot;
                break;
            }
            var6_13 += loot.getWeight();
        }
        return selectedLoot;
    }

    private void giveXp(Player player, Loot loot, @Nullable Source source) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (loot.getXp() == -1.0 && source != null) {
            this.plugin.getLeveler().addXp(player, this.skill, this.getXp(player, source, this.ability));
        } else if (loot.getXp() > 0.0) {
            this.plugin.getLeveler().addXp(player, this.skill, this.getXp(player, loot.getXp()));
        }
    }

    private double getXp(Player player, double input) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            double output = input;
            if (this.ability != null && this.plugin.getAbilityManager().isEnabled(this.ability)) {
                double modifier = 1.0;
                output *= (modifier += this.plugin.getAbilityManager().getValue(this.ability, playerData.getAbilityLevel(this.ability)) / 100.0);
            }
            return output;
        }
        return 0.0;
    }

    private int generateAmount(int minAmount, int maxAmount) {
        return new Random().nextInt(maxAmount - minAmount + 1) + minAmount;
    }

    private void attemptSendMessage(Player player, Loot loot) {
        String message = loot.getMessage();
        if (message != null && !message.equals("")) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            CustomMessageKey key = new CustomMessageKey(message);
            Locale locale = playerData.getLocale();
            String finalMessage = Lang.getMessage(key, locale);
            if (finalMessage == null) {
                finalMessage = message;
            }
            if (this.plugin.isPlaceholderAPIEnabled()) {
                finalMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)finalMessage);
            }
            player.sendMessage(finalMessage);
        }
    }

    protected double getCommonChance(LootPool pool, PlayerData playerData) {
        return pool.getBaseChance() + pool.getChancePerLuck() * playerData.getStatLevel(Stats.LUCK);
    }
}

