/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.loot.handler;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.loot.Loot;
import com.archyx.aureliumskills.loot.LootPool;
import com.archyx.aureliumskills.loot.LootTable;
import com.archyx.aureliumskills.loot.handler.LootHandler;
import com.archyx.aureliumskills.loot.type.CommandLoot;
import com.archyx.aureliumskills.loot.type.ItemLoot;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.source.Source;
import java.util.Random;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public abstract class BlockLootHandler
extends LootHandler
implements Listener {
    private final Random random = new Random();

    public BlockLootHandler(AureliumSkills plugin, Skill skill, Ability ability) {
        super(plugin, skill, ability);
    }

    public abstract Source getSource(Block var1);

    public abstract double getChance(LootPool var1, PlayerData var2);

    public abstract LootDropCause getCause(LootPool var1);

    @EventHandler(priority=EventPriority.HIGH)
    public void onBreak(BlockBreakEvent event) {
        if (!OptionL.isEnabled(this.skill)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (this.getSource(block) == null) {
            return;
        }
        Player player = event.getPlayer();
        if (this.blockAbility(player)) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        Source originalSource = this.getSource(block);
        LootTable table = this.plugin.getLootTableManager().getLootTable(this.skill);
        if (table == null) {
            return;
        }
        for (LootPool pool : table.getPools()) {
            LootDropCause cause;
            double chance;
            if (this.selectBlockLoot(pool, player, chance = this.getChance(pool, playerData), originalSource, event, cause = this.getCause(pool))) break;
        }
    }

    private boolean selectBlockLoot(LootPool pool, Player player, double chance, Source originalSource, BlockBreakEvent event, LootDropCause cause) {
        Loot selectedLoot;
        if (this.random.nextDouble() < chance && (selectedLoot = this.selectLoot(pool, originalSource)) != null) {
            if (selectedLoot instanceof ItemLoot) {
                ItemLoot itemLoot = (ItemLoot)selectedLoot;
                this.giveBlockItemLoot(player, itemLoot, event, originalSource, cause);
            } else if (selectedLoot instanceof CommandLoot) {
                CommandLoot commandLoot = (CommandLoot)selectedLoot;
                this.giveCommandLoot(player, commandLoot, originalSource);
            }
            if (pool.overridesVanillaLoot()) {
                event.setDropItems(false);
            }
            return true;
        }
        return false;
    }
}

