/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.loot;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.loot.LegacyLootConverter;
import com.archyx.aureliumskills.loot.Loot;
import com.archyx.aureliumskills.loot.LootPool;
import com.archyx.aureliumskills.loot.LootTable;
import com.archyx.aureliumskills.loot.parser.CommandLootParser;
import com.archyx.aureliumskills.loot.parser.ItemLootParser;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.misc.DataUtil;
import com.archyx.aureliumskills.util.misc.Parser;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class LootTableManager
extends Parser {
    private final Map<Skill, LootTable> lootTables;
    private final AureliumSkills plugin;

    public LootTableManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.lootTables = new HashMap<Skill, LootTable>();
        this.loadLootTables();
    }

    public void generateDefaultLootTables() {
        File excavationFile;
        File fishingFile = new File(this.plugin.getDataFolder() + "/loot", "fishing.yml");
        if (!fishingFile.exists()) {
            this.plugin.saveResource("loot/fishing.yml", false);
        }
        if (!(excavationFile = new File(this.plugin.getDataFolder() + "/loot", "excavation.yml")).exists()) {
            this.plugin.saveResource("loot/excavation.yml", false);
        }
    }

    public void loadLootTables() {
        boolean convertFishing = !new File(this.plugin.getDataFolder() + "/loot", "fishing.yml").exists();
        boolean convertExcavation = !new File(this.plugin.getDataFolder() + "/loot", "excavation.yml").exists();
        File lootDirectory = new File(this.plugin.getDataFolder() + "/loot");
        if (!lootDirectory.exists() || convertFishing || convertExcavation) {
            this.generateDefaultLootTables();
        }
        if (!lootDirectory.isDirectory()) {
            return;
        }
        try {
            new LegacyLootConverter(this.plugin).convertLegacyFile(convertFishing, convertExcavation);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to convert legacy loot file, see below for error");
            e.printStackTrace();
        }
        this.lootTables.clear();
        File[] files = lootDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File lootTableFile : files) {
            if (!lootTableFile.isFile() || !lootTableFile.getName().endsWith(".yml")) continue;
            String skillName = lootTableFile.getName().replace(".yml", "");
            Skill skill = this.plugin.getSkillRegistry().getSkill(skillName);
            if (skill == null) {
                return;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)lootTableFile);
            this.matchConfig((FileConfiguration)config, lootTableFile);
            LootTable lootTable = this.loadLootTable(lootTableFile, (FileConfiguration)config);
            if (lootTable == null) continue;
            this.lootTables.put(skill, lootTable);
        }
        int tablesLoaded = 0;
        int poolsLoaded = 0;
        int lootLoaded = 0;
        for (LootTable table : this.lootTables.values()) {
            for (LootPool pool : table.getPools()) {
                ++poolsLoaded;
                lootLoaded += pool.getLoot().size();
            }
            ++tablesLoaded;
        }
        this.plugin.getLogger().info("Loaded " + lootLoaded + " loot entries in " + poolsLoaded + " pools and " + tablesLoaded + " tables");
    }

    private LootTable loadLootTable(File file, FileConfiguration config) {
        ConfigurationSection poolsSection = config.getConfigurationSection("pools");
        if (poolsSection == null) {
            return null;
        }
        ArrayList<LootPool> pools = new ArrayList<LootPool>();
        for (String poolName : poolsSection.getKeys(false)) {
            ConfigurationSection currentPool = poolsSection.getConfigurationSection(poolName);
            if (currentPool == null) continue;
            double baseChance = currentPool.getDouble("base_chance", 1.0) / 100.0;
            double chancePerLuck = currentPool.getDouble("chance_per_luck", 0.0) / 100.0;
            int selectionPriority = currentPool.getInt("selection_priority", 1);
            boolean overrideVanillaLoot = currentPool.getBoolean("override_vanilla_loot", false);
            List lootMapList = currentPool.getMapList("loot");
            ArrayList<Loot> lootList = new ArrayList<Loot>();
            int index = 0;
            for (Map lootEntryMap : lootMapList) {
                Loot loot;
                block9: {
                    loot = null;
                    try {
                        String type = DataUtil.getString(lootEntryMap, "type");
                        if (type.equalsIgnoreCase("item")) {
                            if (this.getBooleanOrDefault(lootEntryMap, "ignore_legacy", false) && XMaterial.getVersion() <= 12) {
                                ++index;
                                continue;
                            }
                            loot = new ItemLootParser(this.plugin).parse(lootEntryMap);
                            break block9;
                        }
                        if (type.equalsIgnoreCase("command")) {
                            loot = new CommandLootParser(this.plugin).parse(lootEntryMap);
                            break block9;
                        }
                        throw new IllegalArgumentException("Unknown loot type: " + type);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error parsing loot in file loot/" + file.getName() + " at path pools." + poolName + ".loot." + index + ", see below for error:");
                        e.printStackTrace();
                    }
                }
                if (loot != null) {
                    lootList.add(loot);
                }
                ++index;
            }
            LootPool pool = new LootPool(poolName, lootList, baseChance, chancePerLuck, selectionPriority, overrideVanillaLoot);
            pools.add(pool);
        }
        pools.sort((pool1, pool2) -> pool2.getSelectionPriority() - pool1.getSelectionPriority());
        return new LootTable(pools);
    }

    @Nullable
    public LootTable getLootTable(Skill skill) {
        return this.lootTables.get(skill);
    }

    public void matchConfig(FileConfiguration config, File file) {
        config.options().copyDefaults(true);
        try {
            YamlConfiguration defConfig;
            ConfigurationSection configurationSection;
            boolean changesMade = false;
            InputStream is = this.plugin.getResource("loot/" + file.getName());
            if (is != null && (configurationSection = (defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(is))).getConfigurationSection("")) != null) {
                for (String key : configurationSection.getKeys(true)) {
                    if (config.contains(key)) continue;
                    config.set(key, defConfig.get(key));
                    if (changesMade) continue;
                    changesMade = true;
                }
                if (changesMade) {
                    config.save(file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

