/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.loot;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.util.file.FileUtil;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffectType;

public class LegacyLootConverter {
    private final AureliumSkills plugin;

    public LegacyLootConverter(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public void convertLegacyFile(boolean convertFishing, boolean convertExcavation) throws IOException {
        File legacyFile = new File(this.plugin.getDataFolder(), "loot.yml");
        if (!legacyFile.exists()) {
            return;
        }
        YamlConfiguration legacyConfig = YamlConfiguration.loadConfiguration((File)legacyFile);
        if (convertFishing) {
            File fishingFile = new File(this.plugin.getDataFolder() + "/loot/fishing.yml");
            YamlConfiguration fishingConfig = YamlConfiguration.loadConfiguration((File)fishingFile);
            List fishingRareLoot = legacyConfig.getStringList("lootTables.fishing-rare");
            this.convertSection((FileConfiguration)fishingConfig, fishingRareLoot, "pools.rare");
            List fishingEpicLoot = legacyConfig.getStringList("lootTables.fishing-epic");
            this.convertSection((FileConfiguration)fishingConfig, fishingEpicLoot, "pools.epic");
            fishingConfig.save(fishingFile);
        }
        if (convertExcavation) {
            File excavationFile = new File(this.plugin.getDataFolder() + "/loot/excavation.yml");
            YamlConfiguration excavationConfig = YamlConfiguration.loadConfiguration((File)excavationFile);
            List excavationRareLoot = legacyConfig.getStringList("lootTables.excavation-rare");
            this.convertSection((FileConfiguration)excavationConfig, excavationRareLoot, "pools.rare");
            List excavationEpicLoot = legacyConfig.getStringList("lootTables.excavation-epic");
            this.convertSection((FileConfiguration)excavationConfig, excavationEpicLoot, "pools.epic");
            excavationConfig.save(excavationFile);
        }
        if (convertFishing || convertExcavation) {
            this.renameLegacyFile(legacyFile);
            this.plugin.getLogger().info("Converted old loot.yml file to new files in the loot folder");
        }
    }

    private void convertSection(FileConfiguration config, List<String> legacyLoot, String sectionPath) {
        ArrayList mapList = new ArrayList();
        for (String entry : legacyLoot) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (entry.startsWith("cmd:")) {
                map.put("type", "command");
                String commandString = TextUtil.replace(entry, "cmd:", "");
                map.put("command", commandString);
                map.put("executor", "console");
            } else {
                map.put("type", "item");
                String[] split = entry.split(" ");
                if (split.length < 3) {
                    this.plugin.getLogger().warning("Failed to convert the following legacy loot entry because min, max, and material were not specified: " + entry);
                    continue;
                }
                int minAmount = NumberUtils.toInt((String)split[0]);
                int maxAmount = NumberUtils.toInt((String)split[1]);
                String materialName = split[2];
                map.put("material", materialName.toLowerCase(Locale.ROOT));
                if (minAmount == maxAmount) {
                    map.put("amount", minAmount);
                } else {
                    map.put("amount", minAmount + "-" + maxAmount);
                }
                block17: for (int i = 3; i < split.length; ++i) {
                    String[] splitPair = split[i].split(":", 2);
                    if (splitPair.length != 2) continue;
                    String key = splitPair[0];
                    String value = splitPair[1].replace("_", " ");
                    String originalValue = splitPair[1];
                    switch (key) {
                        case "name": {
                            map.put("display_name", value);
                            continue block17;
                        }
                        case "lore": {
                            LinkedList<String> lore = new LinkedList<String>(Arrays.asList(value.split("\\|")));
                            map.put("lore", lore);
                            continue block17;
                        }
                        case "glow": {
                            if (!Boolean.parseBoolean(value)) continue block17;
                            map.put("glow", true);
                            continue block17;
                        }
                        case "enchantments": {
                            ArrayList<String> enchantments = new ArrayList<String>(Arrays.asList(originalValue.split("\\|")));
                            ArrayList<String> enchantmentList = new ArrayList<String>();
                            for (String enchantString : enchantments) {
                                String[] splitEnchantString = enchantString.split(":", 2);
                                String enchantName = splitEnchantString[0];
                                int enchantLevel = 1;
                                if (splitEnchantString.length == 2) {
                                    enchantLevel = Integer.parseInt(splitEnchantString[1]);
                                }
                                enchantmentList.add(enchantName.toLowerCase(Locale.ROOT) + " " + enchantLevel);
                            }
                            map.put("enchantments", enchantmentList);
                            continue block17;
                        }
                        case "potion_type": {
                            HashMap<String, String> potionData = new HashMap<String, String>();
                            potionData.put("type", originalValue.toUpperCase(Locale.ROOT));
                            map.put("potion_data", potionData);
                            continue block17;
                        }
                        case "custom_effect": {
                            PotionEffectType type;
                            String[] values = originalValue.split(",");
                            ArrayList customEffects = new ArrayList();
                            if (values.length == 3 && (type = PotionEffectType.getByName((String)values[0])) != null) {
                                HashMap<String, Object> effect = new HashMap<String, Object>();
                                effect.put("type", type.toString());
                                effect.put("duration", Integer.parseInt(values[1]));
                                effect.put("amplifier", Integer.parseInt(values[2]));
                                customEffects.add(effect);
                            }
                            map.put("custom_effects", customEffects);
                        }
                    }
                }
            }
            map.put("weight", 10);
            mapList.add(map);
        }
        config.set(sectionPath + ".loot", mapList);
    }

    private void renameLegacyFile(File file) {
        String renamedName = FileUtil.renameNoDuplicates(file, "loot-OLD.yml", this.plugin.getDataFolder());
        if (renamedName != null) {
            this.plugin.getLogger().info("Successfully renamed loot.yml to " + renamedName);
        } else {
            this.plugin.getLogger().warning("Failed to renamed old loot.yml file");
        }
    }
}

