/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.listeners;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerManager;
import com.archyx.aureliumskills.data.storage.MySqlStorageProvider;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.util.version.UpdateChecker;
import dev.dbassett.skullcreator.SkullCreator;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;

public class PlayerJoinQuit
implements Listener {
    private final AureliumSkills plugin;

    public PlayerJoinQuit(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        PlayerManager playerManager = this.plugin.getPlayerManager();
        if (this.plugin.getStorageProvider() instanceof MySqlStorageProvider) {
            if (OptionL.getBoolean(Option.MYSQL_ALWAYS_LOAD_ON_JOIN) || playerManager.getPlayerData(player) == null) {
                int loadDelay = OptionL.getInt(Option.MYSQL_LOAD_DELAY);
                if (loadDelay == 0) {
                    this.loadPlayerDataAsync(player);
                } else {
                    new BukkitRunnable(){

                        public void run() {
                            PlayerJoinQuit.this.loadPlayerDataAsync(player);
                        }
                    }.runTaskLater((Plugin)this.plugin, (long)loadDelay);
                }
            }
        } else if (playerManager.getPlayerData(player) == null) {
            this.loadPlayerDataAsync(player);
        }
        Location playerLoc = player.getLocation();
        Location loc = new Location(playerLoc.getWorld(), playerLoc.getX(), 0.0, playerLoc.getZ());
        Block b = loc.getBlock();
        BlockState state = b.getState();
        SkullCreator.blockWithUuid(b, player.getUniqueId());
        state.update(true);
        if (OptionL.getBoolean(Option.CHECK_FOR_UPDATES) && player.hasPermission("aureliumskills.checkupdates") && System.currentTimeMillis() > 1642487648443L) {
            new UpdateChecker((Plugin)this.plugin, 81069).getVersion((Consumer<String>)((Consumer)version -> {
                if (!(this.plugin.getDescription().getVersion().contains("Pre-Release") || this.plugin.getDescription().getVersion().contains("Build") || this.plugin.getDescription().getVersion().equalsIgnoreCase((String)version))) {
                    player.sendMessage(AureliumSkills.getPrefix(Lang.getDefaultLanguage()) + ChatColor.WHITE + "New update available! You are on version " + ChatColor.AQUA + this.plugin.getDescription().getVersion() + ChatColor.WHITE + ", latest version is " + ChatColor.AQUA + version);
                    player.sendMessage(AureliumSkills.getPrefix(Lang.getDefaultLanguage()) + ChatColor.WHITE + "Download it on Spigot: " + ChatColor.YELLOW + "" + ChatColor.UNDERLINE + "https://spigotmc.org/resources/81069");
                }
            }));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        final Player player = event.getPlayer();
        new BukkitRunnable(){

            public void run() {
                PlayerJoinQuit.this.plugin.getStorageProvider().save(player);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
        this.plugin.getActionBar().resetActionBar(player);
    }

    private void loadPlayerDataAsync(final Player player) {
        new BukkitRunnable(){

            public void run() {
                PlayerJoinQuit.this.plugin.getStorageProvider().load(player);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

