/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.listeners;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.listeners.Critical;
import com.archyx.aureliumskills.mana.Absorption;
import com.archyx.aureliumskills.mana.ChargedShot;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityProvider;
import com.archyx.aureliumskills.skills.archery.ArcheryAbilities;
import com.archyx.aureliumskills.skills.defense.DefenseAbilities;
import com.archyx.aureliumskills.skills.excavation.ExcavationAbilities;
import com.archyx.aureliumskills.skills.farming.FarmingAbilities;
import com.archyx.aureliumskills.skills.fighting.FightingAbilities;
import com.archyx.aureliumskills.skills.foraging.ForagingAbilities;
import com.archyx.aureliumskills.skills.mining.MiningAbilities;
import com.archyx.aureliumskills.stats.Strength;
import com.archyx.aureliumskills.stats.Toughness;
import com.archyx.aureliumskills.util.mechanics.DamageType;
import com.archyx.aureliumskills.xseries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DamageListener
implements Listener {
    private final Strength strength = new Strength();
    private final Critical critical;
    private final AureliumSkills plugin;
    private final ExcavationAbilities excavationAbilities;
    private final FarmingAbilities farmingAbilities;
    private final MiningAbilities miningAbilities;
    private final ForagingAbilities foragingAbilities;
    private final ArcheryAbilities archeryAbilities;
    private final FightingAbilities fightingAbilities;
    private final DefenseAbilities defenseAbilities;

    public DamageListener(AureliumSkills plugin, DefenseAbilities defenseAbilities, FightingAbilities fightingAbilities) {
        this.plugin = plugin;
        this.critical = new Critical(plugin);
        this.excavationAbilities = new ExcavationAbilities(plugin);
        this.farmingAbilities = new FarmingAbilities(plugin);
        this.miningAbilities = new MiningAbilities(plugin);
        this.foragingAbilities = new ForagingAbilities(plugin);
        this.archeryAbilities = new ArcheryAbilities(plugin);
        this.defenseAbilities = defenseAbilities;
        this.fightingAbilities = fightingAbilities;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = this.getDamager(event.getDamager());
        if (player != null) {
            ManaAbilityProvider provider;
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            DamageType damageType = this.getDamageType(event, player);
            this.strength.strength(event, playerData, damageType);
            switch (damageType) {
                case SWORD: {
                    this.fightingAbilities.swordMaster(event, player, playerData);
                    break;
                }
                case BOW: {
                    this.archeryAbilities.bowMaster(event, player, playerData);
                    break;
                }
                case AXE: {
                    this.foragingAbilities.axeMaster(event, player, playerData);
                    break;
                }
                case PICKAXE: {
                    this.miningAbilities.pickMaster(event, player, playerData);
                    break;
                }
                case HOE: {
                    this.farmingAbilities.scytheMaster(event, player, playerData);
                    break;
                }
                case SHOVEL: {
                    this.excavationAbilities.spadeMaster(event, player, playerData);
                }
            }
            if (damageType == DamageType.SWORD) {
                this.fightingAbilities.firstStrike(event, playerData, player);
            }
            if (OptionL.criticalEnabled(damageType)) {
                this.critical.applyCrit(event, player, playerData);
            }
            if (damageType == DamageType.BOW && (provider = this.plugin.getManaAbilityManager().getProvider(MAbility.CHARGED_SHOT)) instanceof ChargedShot) {
                ChargedShot chargedShot = (ChargedShot)provider;
                chargedShot.applyChargedShot(event);
            }
        }
        if (event.getEntity() instanceof Player) {
            this.onDamaged(event, (Player)event.getEntity());
        }
    }

    private void onDamaged(EntityDamageByEntityEvent event, Player player) {
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        ManaAbilityProvider provider = this.plugin.getManaAbilityManager().getProvider(MAbility.ABSORPTION);
        if (provider instanceof Absorption) {
            Absorption absorption = (Absorption)provider;
            absorption.handleAbsorption(event, player, playerData);
        }
        if (event.isCancelled()) {
            return;
        }
        Toughness.onDamage(event, playerData);
        this.defenseAbilities.mobMaster(event, playerData);
        this.defenseAbilities.shielding(event, playerData, player);
    }

    private DamageType getDamageType(EntityDamageByEntityEvent event, Player player) {
        if (event.getDamager() instanceof Arrow || event.getDamager() instanceof SpectralArrow || event.getDamager() instanceof TippedArrow) {
            return DamageType.BOW;
        }
        Material material = player.getInventory().getItemInMainHand().getType();
        if (material.name().contains("SWORD")) {
            return DamageType.SWORD;
        }
        if (material.name().contains("_AXE")) {
            return DamageType.AXE;
        }
        if (material.name().contains("PICKAXE")) {
            return DamageType.PICKAXE;
        }
        if (material.name().contains("SHOVEL") || material.name().contains("SPADE")) {
            return DamageType.SHOVEL;
        }
        if (material.name().contains("HOE")) {
            return DamageType.HOE;
        }
        if (material.equals((Object)Material.AIR)) {
            return DamageType.HAND;
        }
        if (XMaterial.isNewVersion() && event.getDamager() instanceof Trident) {
            return DamageType.BOW;
        }
        return DamageType.OTHER;
    }

    private Player getDamager(Entity entity) {
        Projectile projectile;
        EntityType type;
        Player player = null;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof Projectile && ((type = (projectile = (Projectile)entity).getType()) == EntityType.ARROW || type == EntityType.SPECTRAL_ARROW || type.toString().equals("TRIDENT") || type.toString().equals("TIPPED_ARROW")) && projectile.getShooter() instanceof Player) {
            player = (Player)projectile.getShooter();
        }
        return player;
    }
}

