/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.listeners;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Critical {
    private final Random r = new Random();
    private final AureliumSkills plugin;

    public Critical(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public void applyCrit(EntityDamageByEntityEvent event, final Player player, PlayerData playerData) {
        if (this.plugin.getAbilityManager().isEnabled(Ability.CRIT_CHANCE) && this.isCrit(playerData)) {
            event.setDamage(event.getDamage() * this.getCritMultiplier(playerData));
            player.setMetadata("skillsCritical", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            new BukkitRunnable(){

                public void run() {
                    player.removeMetadata("skillsCritical", (Plugin)Critical.this.plugin);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private boolean isCrit(PlayerData playerData) {
        return this.r.nextDouble() < this.plugin.getAbilityManager().getValue(Ability.CRIT_CHANCE, playerData.getAbilityLevel(Ability.CRIT_CHANCE)) / 100.0;
    }

    private double getCritMultiplier(PlayerData playerData) {
        if (this.plugin.getAbilityManager().isEnabled(Ability.CRIT_DAMAGE)) {
            double multiplier = this.plugin.getAbilityManager().getValue(Ability.CRIT_DAMAGE, playerData.getAbilityLevel(Ability.CRIT_DAMAGE)) / 100.0;
            return OptionL.getDouble(Option.CRITICAL_BASE_MULTIPLIER) * (1.0 + multiplier);
        }
        return OptionL.getDouble(Option.CRITICAL_BASE_MULTIPLIER);
    }
}

