/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.leveler;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.evalex.Expression;
import com.archyx.aureliumskills.skills.Skill;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class XpRequirements {
    private final AureliumSkills plugin;
    private final List<Integer> defaultXpRequirements;
    private final Map<Skill, List<Integer>> skillXpRequirements;

    public XpRequirements(AureliumSkills plugin) {
        this.plugin = plugin;
        this.defaultXpRequirements = new ArrayList<Integer>();
        this.skillXpRequirements = new HashMap<Skill, List<Integer>>();
    }

    public int getXpRequired(Skill skill, int level) {
        List<Integer> skillList = this.skillXpRequirements.get(skill);
        if (skillList != null) {
            if (skillList.size() > level - 2) {
                return skillList.get(level - 2);
            }
            return 0;
        }
        if (this.defaultXpRequirements.size() > level - 2) {
            return this.defaultXpRequirements.get(level - 2);
        }
        return 0;
    }

    public int getListSize(Skill skill) {
        List<Integer> skillList = this.skillXpRequirements.get(skill);
        if (skillList != null) {
            return skillList.size();
        }
        return this.defaultXpRequirements.size();
    }

    public void loadXpRequirements() {
        File file = new File(this.plugin.getDataFolder(), "xp_requirements.yml");
        double oldMultiplier = 0.0;
        if (!file.exists()) {
            this.plugin.saveResource("xp_requirements.yml", false);
            oldMultiplier = this.plugin.getConfig().getDouble("skill-level-requirements-multiplier", 0.0);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.loadDefaultSection(file, (FileConfiguration)config, oldMultiplier);
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            this.skillXpRequirements.remove(skill);
            this.loadSkillSection(file, (FileConfiguration)config, skill);
        }
    }

    private void loadDefaultSection(File file, FileConfiguration config, double oldMultiplier) {
        ConfigurationSection section = config.getConfigurationSection("default");
        if (section != null) {
            if (oldMultiplier != 0.0) {
                section.set("multiplier", (Object)oldMultiplier);
                this.plugin.getConfig().set("skill-level-requirements-multiplier", null);
                try {
                    config.save(file);
                    this.plugin.saveConfig();
                    this.plugin.getLogger().warning("Successfully migrated skill-level-requirements-multiplier from config.yml to new default.multiplier in xp_requirements.yml");
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Failed to migrate skill-level-requirements-multiplier from config.yml to new default.multiplier in xp_requirements.yml");
                    e.printStackTrace();
                }
            }
            Expression expression = this.getXpExpression(section);
            this.defaultXpRequirements.clear();
            int highestMaxLevel = this.plugin.getOptionLoader().getHighestMaxLevel();
            for (int i = 0; i < highestMaxLevel; ++i) {
                expression.setVariable("level", BigDecimal.valueOf(i + 2));
                this.defaultXpRequirements.add((int)Math.round(expression.eval().doubleValue()));
            }
        } else {
            this.addDefaultXpRequirements();
        }
    }

    private void loadSkillSection(File file, FileConfiguration config, Skill skill) {
        ConfigurationSection section = config.getConfigurationSection("skills." + skill.toString().toLowerCase(Locale.ROOT));
        if (section == null) {
            return;
        }
        Expression expression = this.getXpExpression(section);
        int maxLevel = OptionL.getMaxLevel(skill);
        ArrayList<Integer> xpRequirements = new ArrayList<Integer>();
        for (int i = 0; i < maxLevel; ++i) {
            expression.setVariable("level", BigDecimal.valueOf(i + 2));
            xpRequirements.add((int)Math.round(expression.eval().doubleValue()));
        }
        this.skillXpRequirements.put(skill, xpRequirements);
    }

    private Expression getXpExpression(ConfigurationSection section) {
        String expressionString = section.getString("expression");
        Expression expression = new Expression(expressionString);
        for (String variable : section.getKeys(false)) {
            if (variable.equals("expression")) continue;
            double variableValue = section.getDouble(variable);
            expression.setVariable(variable, BigDecimal.valueOf(variableValue));
        }
        return expression;
    }

    private void addDefaultXpRequirements() {
        this.defaultXpRequirements.clear();
        int highestMaxLevel = this.plugin.getOptionLoader().getHighestMaxLevel();
        for (int i = 0; i < highestMaxLevel - 1; ++i) {
            this.defaultXpRequirements.add(100 * i * i + 100);
        }
    }
}

