/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.leveler;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.source.Source;
import com.archyx.aureliumskills.source.SourceManager;
import com.archyx.aureliumskills.source.SourceTag;
import com.archyx.aureliumskills.support.WorldGuardFlags;
import com.archyx.aureliumskills.xseries.XMaterial;
import java.util.Locale;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;

public abstract class SkillLeveler {
    public final AureliumSkills plugin;
    private final SourceManager sourceManager;
    private Ability ability;
    private final String skillName;

    public SkillLeveler(AureliumSkills plugin, Skill skill) {
        this.plugin = plugin;
        this.skillName = skill.toString().toLowerCase(Locale.ENGLISH);
        this.sourceManager = plugin.getSourceManager();
    }

    public SkillLeveler(AureliumSkills plugin, Ability ability) {
        this.plugin = plugin;
        this.ability = ability;
        this.skillName = ability.getSkill().toString().toLowerCase(Locale.ENGLISH);
        this.sourceManager = plugin.getSourceManager();
    }

    public double getXp(Source source) {
        return this.sourceManager.getXp(source);
    }

    public double getXp(Player player, Source source) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            double output = this.getXp(source);
            if (this.ability != null && this.plugin.getAbilityManager().isEnabled(this.ability)) {
                double modifier = 1.0;
                output *= (modifier += this.plugin.getAbilityManager().getValue(this.ability, playerData.getAbilityLevel(this.ability)) / 100.0);
            }
            return output;
        }
        return 0.0;
    }

    public double getXp(Player player, double input) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            double output = input;
            if (this.ability != null && this.plugin.getAbilityManager().isEnabled(this.ability)) {
                double modifier = 1.0;
                output *= (modifier += this.plugin.getAbilityManager().getValue(this.ability, playerData.getAbilityLevel(this.ability)) / 100.0);
            }
            return output;
        }
        return 0.0;
    }

    public double getXp(Player player, double input, Ability ability) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            double output = input;
            if (ability != null && this.plugin.getAbilityManager().isEnabled(ability)) {
                double modifier = 1.0;
                output *= (modifier += this.plugin.getAbilityManager().getValue(ability, playerData.getAbilityLevel(ability)) / 100.0);
            }
            return output;
        }
        return 0.0;
    }

    protected boolean hasTag(Source source, SourceTag tag) {
        for (Source sourceWithTag : this.sourceManager.getTag(tag)) {
            if (source != sourceWithTag) continue;
            return true;
        }
        return false;
    }

    public void checkCustomBlocks(Player player, Block block, Skill skill) {
        Map<XMaterial, Double> customBlocks = this.sourceManager.getCustomBlocks(skill);
        if (customBlocks != null) {
            for (Map.Entry<XMaterial, Double> entry : customBlocks.entrySet()) {
                if (XMaterial.isNewVersion()) {
                    if (entry.getKey().parseMaterial() != block.getType()) continue;
                    if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
                        return;
                    }
                    this.plugin.getLeveler().addXp(player, skill, this.getXp(player, entry.getValue()));
                    break;
                }
                if (entry.getKey().parseMaterial() != block.getType() || block.getData() != entry.getKey().getData()) continue;
                if (OptionL.getBoolean(Option.CHECK_BLOCK_REPLACE) && this.plugin.getRegionManager().isPlacedBlock(block)) {
                    return;
                }
                this.plugin.getLeveler().addXp(player, skill, this.getXp(player, entry.getValue()));
                break;
            }
        }
    }

    public boolean blockXpGain(Player player) {
        Location location = player.getLocation();
        if (this.plugin.getWorldManager().isInBlockedWorld(location)) {
            return true;
        }
        if (!player.hasPermission("aureliumskills." + this.skillName)) {
            return true;
        }
        if (OptionL.getBoolean(Option.DISABLE_IN_CREATIVE_MODE)) {
            return player.getGameMode().equals((Object)GameMode.CREATIVE);
        }
        if (this.plugin.isWorldGuardEnabled()) {
            if (this.plugin.getWorldGuardSupport().isInBlockedRegion(location)) {
                return true;
            }
            return this.plugin.getWorldGuardSupport().blockedByFlag(location, player, WorldGuardFlags.FlagKey.XP_GAIN);
        }
        return false;
    }

    public boolean blockXpGainLocation(Location location, Player player) {
        if (this.plugin.getWorldManager().isInBlockedWorld(location)) {
            return true;
        }
        if (this.plugin.isWorldGuardEnabled()) {
            if (this.plugin.getWorldGuardSupport().isInBlockedRegion(location)) {
                return true;
            }
            return this.plugin.getWorldGuardSupport().blockedByFlag(location, player, WorldGuardFlags.FlagKey.XP_GAIN);
        }
        return false;
    }

    public boolean blockXpGainPlayer(Player player) {
        if (!player.hasPermission("aureliumskills." + this.skillName)) {
            return true;
        }
        if (OptionL.getBoolean(Option.DISABLE_IN_CREATIVE_MODE)) {
            return player.getGameMode().equals((Object)GameMode.CREATIVE);
        }
        return false;
    }

    public boolean blockAbility(Player player) {
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return true;
        }
        if (!player.hasPermission("aureliumskills." + this.skillName)) {
            return true;
        }
        if (OptionL.getBoolean(Option.DISABLE_IN_CREATIVE_MODE)) {
            return player.getGameMode().equals((Object)GameMode.CREATIVE);
        }
        return false;
    }

    public boolean blockDisabled(Ability ability) {
        if (!OptionL.isEnabled(ability.getSkill())) {
            return true;
        }
        return !this.plugin.getAbilityManager().isEnabled(ability);
    }

    public double getValue(Ability ability, PlayerData playerData) {
        return this.plugin.getAbilityManager().getValue(ability, playerData.getAbilityLevel(ability));
    }

    protected boolean hasSilkTouch(Player player) {
        return player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.SILK_TOUCH) > 0;
    }
}

