/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.leveler;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.api.event.SkillLevelUpEvent;
import com.archyx.aureliumskills.api.event.XpGainEvent;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.LevelerMessage;
import com.archyx.aureliumskills.leveler.XpRequirements;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.rewards.CommandReward;
import com.archyx.aureliumskills.rewards.MoneyReward;
import com.archyx.aureliumskills.rewards.Reward;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatLeveler;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.math.RomanNumber;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class Leveler {
    private final AureliumSkills plugin;
    private final XpRequirements xpRequirements;
    private final StatLeveler statLeveler;
    private final Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");

    public Leveler(AureliumSkills plugin) {
        this.plugin = plugin;
        this.xpRequirements = new XpRequirements(plugin);
        this.statLeveler = new StatLeveler(plugin);
    }

    public void loadLevelRequirements() {
        this.xpRequirements.loadXpRequirements();
    }

    public double getMultiplier(Player player, Skill skill) {
        double multiplier = 1.0;
        if (skill != null && !OptionL.getBoolean(Option.valueOf(skill + "_CHECK_MULTIPLIER_PERMISSIONS"))) {
            return multiplier;
        }
        for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
            String skillName;
            String permission = info.getPermission().toLowerCase(Locale.ROOT);
            if (!permission.startsWith("aureliumskills.multiplier.")) continue;
            if (this.pattern.matcher(permission = TextUtil.replace(permission, "aureliumskills.multiplier.", "")).matches()) {
                multiplier += Double.parseDouble(permission) / 100.0;
                continue;
            }
            if (skill == null || !permission.startsWith(skillName = skill.toString().toLowerCase(Locale.ROOT)) || !this.pattern.matcher(permission = TextUtil.replace(permission, skillName + ".", "")).matches()) continue;
            multiplier += Double.parseDouble(permission) / 100.0;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            multiplier += playerData.getTotalMultiplier(skill) / 100.0;
        }
        return multiplier;
    }

    public double getMultiplier(Player player) {
        return this.getMultiplier(player, null);
    }

    public void addXp(Player player, Skill skill, double amount) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null && amount != 0.0) {
            double xpAmount = amount * this.getMultiplier(player, skill);
            XpGainEvent event = new XpGainEvent(player, skill, xpAmount);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                playerData.addSkillXp(skill, event.getAmount());
                this.checkLevelUp(player, skill);
                this.plugin.getActionBar().sendXpActionBar(player, skill, event.getAmount());
                this.sendBossBar(player, skill, playerData);
            }
        }
    }

    private void sendBossBar(Player player, Skill skill, PlayerData playerData) {
        if (OptionL.getBoolean(Option.BOSS_BAR_ENABLED)) {
            this.plugin.getBossBar().incrementAction(player, skill);
            int currentAction = this.plugin.getBossBar().getCurrentAction(player, skill);
            if (currentAction != -1 && currentAction % OptionL.getInt(Option.BOSS_BAR_UPDATE_EVERY) == 0) {
                boolean notMaxed;
                int level = playerData.getSkillLevel(skill);
                boolean bl = notMaxed = this.xpRequirements.getListSize(skill) > playerData.getSkillLevel(skill) - 1 && level < OptionL.getMaxLevel(skill);
                if (notMaxed) {
                    this.plugin.getBossBar().sendBossBar(player, skill, playerData.getSkillXp(skill), this.xpRequirements.getXpRequired(skill, level + 1), level, false);
                } else {
                    this.plugin.getBossBar().sendBossBar(player, skill, 1.0, 1.0, level, true);
                }
            }
        }
    }

    public void setXp(Player player, Skill skill, double amount) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            double originalAmount = playerData.getSkillXp(skill);
            playerData.setSkillXp(skill, amount);
            this.checkLevelUp(player, skill);
            this.plugin.getActionBar().sendXpActionBar(player, skill, amount - originalAmount);
            this.sendBossBar(player, skill, playerData);
        }
    }

    public void updateStats(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        for (Stat stat : this.plugin.getStatRegistry().getStats()) {
            playerData.setStatLevel(stat, 0.0);
        }
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            this.plugin.getRewardManager().getRewardTable(skill).applyStats(playerData, playerData.getSkillLevel(skill));
        }
        for (String key : playerData.getStatModifiers().keySet()) {
            StatModifier modifier = playerData.getStatModifiers().get(key);
            playerData.addStatLevel(modifier.getStat(), modifier.getValue());
        }
        this.statLeveler.reloadStat(player, Stats.HEALTH);
        this.statLeveler.reloadStat(player, Stats.WISDOM);
    }

    public void updatePermissions(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            this.plugin.getRewardManager().getRewardTable(skill).applyPermissions(player, playerData.getSkillLevel(skill));
        }
    }

    public void applyLevelUpCommands(Player player, Skill skill, int oldLevel, int newLevel) {
        if (newLevel > oldLevel) {
            for (int i = oldLevel + 1; i <= newLevel; ++i) {
                for (CommandReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(CommandReward.class, i)) {
                    reward.giveReward(player, skill, i);
                }
            }
        }
    }

    public void applyRevertCommands(Player player, Skill skill, int oldLevel, int newLevel) {
        if (newLevel < oldLevel) {
            for (int i = oldLevel; i > newLevel; --i) {
                for (CommandReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(CommandReward.class, i)) {
                    reward.executeRevert(player, skill, i);
                }
            }
        }
    }

    public void checkLevelUp(Player player, Skill skill) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData == null) {
            return;
        }
        int currentLevel = playerData.getSkillLevel(skill);
        double currentXp = playerData.getSkillXp(skill);
        if (currentLevel < OptionL.getMaxLevel(skill) && this.xpRequirements.getListSize(skill) > currentLevel - 1 && currentXp >= (double)this.xpRequirements.getXpRequired(skill, currentLevel + 1)) {
            this.levelUpSkill(playerData, skill);
        }
    }

    private void levelUpSkill(PlayerData playerData, Skill skill) {
        Player player = playerData.getPlayer();
        Locale locale = playerData.getLocale();
        double currentXp = playerData.getSkillXp(skill);
        int level = playerData.getSkillLevel(skill) + 1;
        playerData.setSkillXp(skill, currentXp - (double)this.xpRequirements.getXpRequired(skill, level));
        playerData.setSkillLevel(skill, level);
        ImmutableList<Reward> rewards = this.plugin.getRewardManager().getRewardTable(skill).getRewards(level);
        for (Reward reward : rewards) {
            reward.giveReward(player, skill, level);
        }
        if (this.plugin.isVaultEnabled() && OptionL.getBoolean(Option.SKILL_MONEY_REWARDS_ENABLED)) {
            Economy economy = this.plugin.getEconomy();
            double base = OptionL.getDouble(Option.SKILL_MONEY_REWARDS_BASE);
            double multiplier = OptionL.getDouble(Option.SKILL_MONEY_REWARDS_MULTIPLIER);
            economy.depositPlayer((OfflinePlayer)player, base + multiplier * (double)level * (double)level);
        }
        this.plugin.getModifierManager().reloadPlayer(player);
        SkillLevelUpEvent event = new SkillLevelUpEvent(player, skill, level);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (OptionL.getBoolean(Option.LEVELER_TITLE_ENABLED)) {
            this.sendTitle(player, locale, skill, level);
        }
        if (OptionL.getBoolean(Option.LEVELER_SOUND_ENABLED)) {
            this.playSound(player);
        }
        player.sendMessage(this.getLevelUpMessage(player, playerData, skill, level, locale, (List<Reward>)rewards));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.checkLevelUp(player, skill), (long)OptionL.getInt(Option.LEVELER_DOUBLE_CHECK_DELAY));
    }

    private void sendTitle(Player player, Locale locale, Skill skill, int level) {
        player.sendTitle(TextUtil.replace(Lang.getMessage(LevelerMessage.TITLE, locale), "{skill}", skill.getDisplayName(locale)), TextUtil.replace(Lang.getMessage(LevelerMessage.SUBTITLE, locale), "{old}", RomanNumber.toRoman(level - 1), "{new}", RomanNumber.toRoman(level)), OptionL.getInt(Option.LEVELER_TITLE_FADE_IN), OptionL.getInt(Option.LEVELER_TITLE_STAY), OptionL.getInt(Option.LEVELER_TITLE_FADE_OUT));
    }

    private void playSound(Player player) {
        try {
            player.playSound(player.getLocation(), Sound.valueOf((String)OptionL.getString(Option.LEVELER_SOUND_TYPE)), SoundCategory.valueOf((String)OptionL.getString(Option.LEVELER_SOUND_CATEGORY)), (float)OptionL.getDouble(Option.LEVELER_SOUND_VOLUME), (float)OptionL.getDouble(Option.LEVELER_SOUND_PITCH));
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("[AureliumSkills] Error playing level up sound (Check config) Played the default sound instead");
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, SoundCategory.MASTER, 1.0f, 0.5f);
        }
    }

    private String getLevelUpMessage(Player player, PlayerData playerData, Skill skill, int newLevel, Locale locale, List<Reward> rewards) {
        String message = TextUtil.replace(Lang.getMessage(LevelerMessage.LEVEL_UP, locale), "{skill}", skill.getDisplayName(locale), "{old}", RomanNumber.toRoman(newLevel - 1), "{new}", RomanNumber.toRoman(newLevel));
        if (this.plugin.isPlaceholderAPIEnabled()) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        StringBuilder rewardMessage = new StringBuilder();
        for (Reward reward : rewards) {
            rewardMessage.append(reward.getChatMessage(player, locale, skill, newLevel));
        }
        StringBuilder abilityUnlockMessage = new StringBuilder();
        StringBuilder abilityLevelUpMessage = new StringBuilder();
        for (Ability ability : this.plugin.getAbilityManager().getAbilities(skill, newLevel)) {
            if (!this.plugin.getAbilityManager().isEnabled(ability)) continue;
            if (this.plugin.getAbilityManager().getUnlock(ability) == newLevel) {
                abilityUnlockMessage.append(TextUtil.replace(Lang.getMessage(LevelerMessage.ABILITY_UNLOCK, locale), "{ability}", ability.getDisplayName(locale)));
                continue;
            }
            abilityLevelUpMessage.append(TextUtil.replace(Lang.getMessage(LevelerMessage.ABILITY_LEVEL_UP, locale), "{ability}", ability.getDisplayName(locale), "{level}", RomanNumber.toRoman(playerData.getAbilityLevel(ability))));
        }
        message = TextUtil.replace(message, "{stat_level}", rewardMessage.toString(), "{ability_unlock}", abilityUnlockMessage.toString(), "{ability_level_up}", abilityLevelUpMessage.toString());
        StringBuilder manaAbilityUnlockMessage = new StringBuilder();
        StringBuilder manaAbilityLevelUpMessage = new StringBuilder();
        MAbility mAbility = this.plugin.getManaAbilityManager().getManaAbility(skill, newLevel);
        if (mAbility != null && this.plugin.getAbilityManager().isEnabled(mAbility)) {
            if (this.plugin.getManaAbilityManager().getUnlock(mAbility) == newLevel) {
                manaAbilityUnlockMessage.append(TextUtil.replace(Lang.getMessage(LevelerMessage.MANA_ABILITY_UNLOCK, locale), "{mana_ability}", mAbility.getDisplayName(locale)));
            } else {
                manaAbilityLevelUpMessage.append(TextUtil.replace(Lang.getMessage(LevelerMessage.MANA_ABILITY_LEVEL_UP, locale), "{mana_ability}", mAbility.getDisplayName(locale), "{level}", RomanNumber.toRoman(playerData.getManaAbilityLevel(mAbility))));
            }
        }
        message = TextUtil.replace(message, "{mana_ability_unlock}", manaAbilityUnlockMessage.toString(), "{mana_ability_level_up}", manaAbilityLevelUpMessage.toString());
        StringBuilder moneyRewardMessage = new StringBuilder();
        double totalMoney = 0.0;
        if (this.plugin.isVaultEnabled() && OptionL.getBoolean(Option.SKILL_MONEY_REWARDS_ENABLED)) {
            double base = OptionL.getDouble(Option.SKILL_MONEY_REWARDS_BASE);
            double multiplier = OptionL.getDouble(Option.SKILL_MONEY_REWARDS_MULTIPLIER);
            totalMoney += base + multiplier * (double)newLevel * (double)newLevel;
        }
        for (MoneyReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(MoneyReward.class, newLevel)) {
            totalMoney += reward.getAmount();
        }
        if (totalMoney > 0.0) {
            DecimalFormat nf = new DecimalFormat("#.##");
            moneyRewardMessage.append(TextUtil.replace(Lang.getMessage(LevelerMessage.MONEY_REWARD, locale), "{amount}", nf.format(totalMoney)));
        }
        message = TextUtil.replace(message, "{money_reward}", moneyRewardMessage.toString());
        return message.replaceAll("(\\u005C\\u006E)|(\\n)", "\n");
    }

    public XpRequirements getXpRequirements() {
        return this.xpRequirements;
    }
}

