/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.leaderboard;

import com.archyx.aureliumskills.leaderboard.SkillValue;
import com.archyx.aureliumskills.skills.Skill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LeaderboardManager {
    private final Map<Skill, List<SkillValue>> skillLeaderboards = new HashMap<Skill, List<SkillValue>>();
    private List<SkillValue> powerLeaderboard = new ArrayList<SkillValue>();
    private List<SkillValue> averageLeaderboard = new ArrayList<SkillValue>();
    private volatile boolean sorting = false;

    public List<SkillValue> getLeaderboard(Skill skill) {
        return this.skillLeaderboards.get(skill);
    }

    public void setLeaderboard(Skill skill, List<SkillValue> leaderboard) {
        this.skillLeaderboards.put(skill, leaderboard);
    }

    public List<SkillValue> getLeaderboard(Skill skill, int page, int numPerPage) {
        List<SkillValue> leaderboard = this.skillLeaderboards.get(skill);
        int from = (Math.max(page, 1) - 1) * numPerPage;
        int to = from + numPerPage;
        return leaderboard.subList(Math.min(from, leaderboard.size()), Math.min(to, leaderboard.size()));
    }

    public List<SkillValue> getPowerLeaderboard() {
        return this.powerLeaderboard;
    }

    public List<SkillValue> getPowerLeaderboard(int page, int numPerPage) {
        int from = (Math.max(page, 1) - 1) * numPerPage;
        int to = from + numPerPage;
        return this.powerLeaderboard.subList(Math.min(from, this.powerLeaderboard.size()), Math.min(to, this.powerLeaderboard.size()));
    }

    public void setPowerLeaderboard(List<SkillValue> leaderboard) {
        this.powerLeaderboard = leaderboard;
    }

    public List<SkillValue> getAverageLeaderboard() {
        return this.averageLeaderboard;
    }

    public List<SkillValue> getAverageLeaderboard(int page, int numPerPage) {
        int from = (Math.max(page, 1) - 1) * numPerPage;
        int to = from + numPerPage;
        return this.averageLeaderboard.subList(Math.min(from, this.averageLeaderboard.size()), Math.min(to, this.averageLeaderboard.size()));
    }

    public void setAverageLeaderboard(List<SkillValue> leaderboard) {
        this.averageLeaderboard = leaderboard;
    }

    public int getSkillRank(Skill skill, UUID id) {
        List<SkillValue> leaderboard = this.skillLeaderboards.get(skill);
        for (SkillValue skillValue : leaderboard) {
            if (!skillValue.getId().equals(id)) continue;
            return leaderboard.indexOf(skillValue) + 1;
        }
        return 0;
    }

    public int getPowerRank(UUID id) {
        for (SkillValue skillValue : this.powerLeaderboard) {
            if (!skillValue.getId().equals(id)) continue;
            return this.powerLeaderboard.indexOf(skillValue) + 1;
        }
        return 0;
    }

    public int getAverageRank(UUID id) {
        for (SkillValue skillValue : this.averageLeaderboard) {
            if (!skillValue.getId().equals(id)) continue;
            return this.averageLeaderboard.indexOf(skillValue) + 1;
        }
        return 0;
    }

    public boolean isNotSorting() {
        return !this.sorting;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
    }
}

