/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.lang;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.acf.MessageKeys;
import com.archyx.aureliumskills.acf.MinecraftMessageKeys;
import com.archyx.aureliumskills.acf.PaperCommandManager;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.lang.ACFCoreMessage;
import com.archyx.aureliumskills.lang.ACFMinecraftMessage;
import com.archyx.aureliumskills.lang.CustomMessageKey;
import com.archyx.aureliumskills.lang.MessageKey;
import com.archyx.aureliumskills.lang.MessageUpdates;
import com.archyx.aureliumskills.lang.UnitMessage;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class Lang
implements Listener {
    private final String[] embeddedLanguages = new String[]{"en", "id", "es", "fr", "zh-TW", "tr", "pl", "pt-BR", "zh-CN", "de", "lt", "ru", "it", "ko"};
    private static final Map<Locale, Map<MessageKey, String>> messages = new HashMap<Locale, Map<MessageKey, String>>();
    private static Map<Locale, String> definedLanguages;
    private static Locale defaultLanguage;
    private final AureliumSkills plugin;
    private final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public Lang(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.moveFilesToFolder();
        this.loadLanguageFiles();
    }

    public void loadLanguageFiles() {
        for (String language : this.embeddedLanguages) {
            if (new File(this.plugin.getDataFolder() + "/messages", "messages_" + language + ".yml").exists()) continue;
            this.plugin.saveResource("messages/messages_" + language + ".yml", false);
        }
    }

    public void loadEmbeddedMessages(PaperCommandManager commandManager) {
        InputStream inputStream = this.plugin.getResource("messages/messages_en.yml");
        if (inputStream != null) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            Locale locale = new Locale("en");
            this.loadMessages((FileConfiguration)config, locale, commandManager);
        }
    }

    public void loadLanguages(PaperCommandManager commandManager) {
        Bukkit.getLogger().info("[AureliumSkills] Loading languages...");
        long startTime = System.currentTimeMillis();
        FileConfiguration pluginConfig = this.plugin.getConfig();
        ArrayList<String> languages = new ArrayList<String>(pluginConfig.getStringList("languages"));
        String defaultLanguageString = pluginConfig.getString("default-language");
        if (defaultLanguageString == null) {
            defaultLanguageString = "en";
        }
        if (!languages.contains(defaultLanguageString)) {
            languages.add(defaultLanguageString);
        }
        Lang.setDefaultLanguage(new Locale(defaultLanguageString));
        definedLanguages = new HashMap<Locale, String>();
        int languagesLoaded = 0;
        for (String language : languages) {
            try {
                Locale locale = new Locale(language);
                File file = new File(this.plugin.getDataFolder() + "/messages", "messages_" + language + ".yml");
                FileConfiguration config = this.updateFile(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file), language);
                if (config.contains("file_version")) {
                    this.loadMessages(config, locale, commandManager);
                    ++languagesLoaded;
                    definedLanguages.put(locale, language);
                    continue;
                }
                Bukkit.getLogger().warning("[AureliumSkills] Could not load file messages_" + language + ".yml! Does this file exist and does it contain a file_version?");
                if (!language.equals(defaultLanguageString)) continue;
                Bukkit.getLogger().warning("[AureliumSkills] The default-language could not be loaded, setting the default language to en!");
                Lang.setDefaultLanguage(Locale.ENGLISH);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[AureliumSkills] Error loading messages file messages_" + language + ".yml");
                e.printStackTrace();
            }
        }
        long endTime = System.currentTimeMillis();
        Bukkit.getLogger().info("[AureliumSkills] Loaded " + languagesLoaded + " languages in " + (endTime - startTime) + "ms");
    }

    private void loadMessages(FileConfiguration config, Locale locale, PaperCommandManager commandManager) {
        String path;
        HashMap<UnitMessage, String> units = new HashMap<UnitMessage, String>();
        for (MessageKey key : UnitMessage.values()) {
            String string = config.getString(key.getPath());
            if (string == null) continue;
            units.put((UnitMessage)key, this.applyColor(string));
        }
        Map<MessageKey, String> messages = Lang.messages.get(locale);
        if (messages == null) {
            messages = new HashMap<MessageKey, String>();
        }
        for (String path2 : config.getKeys(true)) {
            String string;
            MessageKey key;
            if (config.isConfigurationSection(path2)) continue;
            key = null;
            for (MessageKey messageKey : MessageKey.values()) {
                if (!messageKey.getPath().equals(path2)) continue;
                key = messageKey;
            }
            if (key == null) {
                key = new CustomMessageKey(path2);
            }
            if ((string = config.getString(path2)) == null) continue;
            messages.put(key, this.applyColor(TextUtil.replace(string, "{mana_unit}", (String)units.get(UnitMessage.MANA), "{hp_unit}", (String)units.get(UnitMessage.HP), "{xp_unit}", (String)units.get(UnitMessage.XP))));
        }
        for (MessageKey key : MessageKey.values()) {
            String message2 = config.getString(key.getPath());
            if (message2 != null || !locale.equals(Locale.ENGLISH)) continue;
            this.plugin.getLogger().warning("[" + locale.toLanguageTag() + "] Message with path " + key.getPath() + " not found!");
        }
        for (Iterator<Object> iterator : ACFCoreMessage.values()) {
            path = ((ACFCoreMessage)((Object)iterator)).getPath();
            commandManager.getLocales().addMessage(locale, MessageKeys.valueOf(((Enum)((Object)iterator)).name()), TextUtil.replace(config.getString(path), "&", "\u00a7"));
        }
        for (Iterator<Object> iterator : ACFMinecraftMessage.values()) {
            path = ((ACFMinecraftMessage)((Object)iterator)).getPath();
            commandManager.getLocales().addMessage(locale, MinecraftMessageKeys.valueOf(((Enum)((Object)iterator)).name()), TextUtil.replace(config.getString(path), "&", "\u00a7"));
        }
        Lang.messages.put(locale, messages);
    }

    private void moveFilesToFolder() {
        File file = new File(this.plugin.getDataFolder(), "messages_en.yml");
        if (file.exists()) {
            try {
                File[] pluginFiles;
                File directory = new File(this.plugin.getDataFolder() + "/messages");
                if (directory.mkdir() && (pluginFiles = this.plugin.getDataFolder().listFiles()) != null) {
                    int filesMoved = 0;
                    for (File pluginFile : pluginFiles) {
                        if (!pluginFile.getName().contains("messages") || !pluginFile.isFile()) continue;
                        if (pluginFile.renameTo(new File(this.plugin.getDataFolder() + "/messages/" + pluginFile.getName()))) {
                            ++filesMoved;
                            continue;
                        }
                        Bukkit.getLogger().warning("[AureliumSkills] Failed to move file " + pluginFile.getName() + " to messages folder!");
                    }
                    Bukkit.getLogger().warning("[AureliumSkills] Moved " + filesMoved + " files to messages folder. If you are seeing this message, an update moved message files to a separate messages folder. From now on use the messages folder for editing and adding messages. If there are still message files in the root directory, you can delete them.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getLogger().severe("[AureliumSkills] Error moving messages files to messages folder!");
            }
        }
    }

    private FileConfiguration updateFile(File file, FileConfiguration config, String language) {
        YamlConfiguration imbConfig;
        int imbVersion;
        int currentVersion;
        InputStream stream;
        if (config.contains("file_version") && (stream = this.plugin.getResource("messages/messages_" + language + ".yml")) != null && (currentVersion = config.getInt("file_version")) != (imbVersion = (imbConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8))).getInt("file_version"))) {
            try {
                ConfigurationSection configSection = imbConfig.getConfigurationSection("");
                int keysAdded = 0;
                if (configSection != null) {
                    for (String key : configSection.getKeys(true)) {
                        if (configSection.isConfigurationSection(key) || config.contains(key)) continue;
                        config.set(key, imbConfig.get(key));
                        ++keysAdded;
                    }
                    for (MessageUpdates update : MessageUpdates.values()) {
                        if (currentVersion >= update.getVersion() || imbVersion < update.getVersion()) continue;
                        ConfigurationSection section = imbConfig.getConfigurationSection(update.getPath());
                        if (section != null) {
                            for (String key : section.getKeys(false)) {
                                config.set(section.getCurrentPath() + "." + key, (Object)section.getString(key));
                            }
                            Bukkit.getLogger().warning("[AureliumSkills] messages_" + language + ".yml was changed: " + update.getMessage());
                            continue;
                        }
                        Object value = imbConfig.get(update.getPath());
                        if (value == null) continue;
                        config.set(update.getPath(), value);
                        Bukkit.getLogger().warning("[AureliumSkills] messages_" + language + ".yml was changed: " + update.getMessage());
                    }
                }
                config.set("file_version", (Object)imbVersion);
                config.save(file);
                Bukkit.getLogger().info("[AureliumSkills] messages_" + language + ".yml was updated to a new file version, " + keysAdded + " new keys were added.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static String getMessage(MessageKey key, Locale locale) {
        String message;
        if (!messages.containsKey(locale)) {
            locale = Lang.getDefaultLanguage();
        }
        if ((message = messages.get(locale).get(key)) != null) {
            return message;
        }
        String defaultMessage = messages.get(Lang.getDefaultLanguage()).get(key);
        if (defaultMessage != null) {
            return defaultMessage;
        }
        return messages.get(Locale.ENGLISH).get(key);
    }

    public static boolean hasLocale(Locale locale) {
        return messages.containsKey(locale);
    }

    public static Map<Locale, String> getDefinedLanguages() {
        return definedLanguages;
    }

    public static Set<String> getDefinedLanguagesSet() {
        HashSet<String> languages = new HashSet<String>();
        for (Map.Entry<Locale, String> entry : definedLanguages.entrySet()) {
            languages.add(entry.getValue());
        }
        return languages;
    }

    private static void setDefaultLanguage(Locale language) {
        defaultLanguage = language;
    }

    public static Locale getDefaultLanguage() {
        return defaultLanguage;
    }

    public Locale getLocale(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getLocale();
        }
        return Lang.getDefaultLanguage();
    }

    public Locale getLocale(CommandSender sender) {
        PlayerData playerData;
        if (sender instanceof Player && (playerData = this.plugin.getPlayerManager().getPlayerData((Player)sender)) != null) {
            return playerData.getLocale();
        }
        return Lang.getDefaultLanguage();
    }

    @EventHandler
    public void onJoin(PlayerDataLoadEvent event) {
        block6: {
            Player player = event.getPlayerData().getPlayer();
            PlayerData playerData = event.getPlayerData();
            if (playerData.getLocale() == null) {
                if (OptionL.getBoolean(Option.TRY_DETECT_CLIENT_LANGUAGE)) {
                    try {
                        Locale locale = new Locale(player.getLocale().split("_")[0].toLowerCase(Locale.ENGLISH));
                        if (messages.containsKey(locale)) {
                            playerData.setLocale(locale);
                            break block6;
                        }
                        playerData.setLocale(Lang.getDefaultLanguage());
                    }
                    catch (Exception e) {
                        playerData.setLocale(Lang.getDefaultLanguage());
                    }
                } else {
                    playerData.setLocale(Lang.getDefaultLanguage());
                }
            }
        }
    }

    private String applyColor(String message) {
        Matcher matcher = this.hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            char COLOR_CHAR = '\u00a7';
            matcher.appendReplacement(buffer, COLOR_CHAR + "x" + COLOR_CHAR + group.charAt(0) + COLOR_CHAR + group.charAt(1) + COLOR_CHAR + group.charAt(2) + COLOR_CHAR + group.charAt(3) + COLOR_CHAR + group.charAt(4) + COLOR_CHAR + group.charAt(5));
        }
        message = matcher.appendTail(buffer).toString();
        return TextUtil.replace(message, "&", "\u00a7");
    }
}

