/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.item;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.inv.ClickableItem;
import com.archyx.aureliumskills.inv.SmartInventory;
import com.archyx.aureliumskills.inv.content.InventoryContents;
import com.archyx.aureliumskills.inv.content.InventoryProvider;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.MenuMessage;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.misc.KeyIntPair;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UnclaimedItemsMenu
implements InventoryProvider {
    private final AureliumSkills plugin;
    private final PlayerData playerData;

    public UnclaimedItemsMenu(AureliumSkills plugin, PlayerData playerData) {
        this.plugin = plugin;
        this.playerData = playerData;
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        for (int slot = 0; slot < 54; ++slot) {
            int row = slot / 9;
            int column = slot % 9;
            if (this.playerData.getUnclaimedItems().size() <= slot) {
                contents.set(row, column, ClickableItem.empty(new ItemStack(Material.AIR)));
                continue;
            }
            KeyIntPair keyIntPair = this.playerData.getUnclaimedItems().get(slot);
            String itemKey = keyIntPair.getKey();
            int amount = keyIntPair.getValue();
            ItemStack item = this.plugin.getItemRegistry().getItem(itemKey);
            if (item == null) {
                this.plugin.getLogger().warning("Could not find a registered item with key " + itemKey + " when claiming unclaimed item rewards");
                continue;
            }
            item.setAmount(amount);
            contents.set(row, column, ClickableItem.of(this.getDisplayItem(item), event -> {
                ItemStack leftoverItem = ItemUtils.addItemToInventory(player, item);
                if (leftoverItem == null) {
                    this.playerData.getUnclaimedItems().remove(keyIntPair);
                    if (this.playerData.getUnclaimedItems().size() > 0) {
                        this.init(player, contents);
                    } else {
                        player.closeInventory();
                    }
                } else if (leftoverItem.getAmount() != item.getAmount()) {
                    keyIntPair.setValue(leftoverItem.getAmount());
                    this.init(player, contents);
                } else {
                    player.sendMessage(Lang.getMessage(MenuMessage.INVENTORY_FULL, this.playerData.getLocale()));
                    player.closeInventory();
                }
            }));
        }
    }

    public static SmartInventory getInventory(AureliumSkills plugin, PlayerData playerData) {
        return SmartInventory.builder().manager(plugin.getInventoryManager()).provider(new UnclaimedItemsMenu(plugin, playerData)).size(6, 9).title(Lang.getMessage(MenuMessage.UNCLAIMED_ITEMS_TITLE, playerData.getLocale())).build();
    }

    private ItemStack getDisplayItem(ItemStack baseItem) {
        ItemStack displayItem = baseItem.clone();
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            } else {
                lore.add(" ");
            }
            lore.add(Lang.getMessage(MenuMessage.CLICK_TO_CLAIM, this.playerData.getLocale()));
            meta.setLore(lore);
        }
        displayItem.setItemMeta(meta);
        return displayItem;
    }
}

