/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.item;

import com.archyx.aureliumskills.AureliumSkills;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemRegistry {
    private final AureliumSkills plugin;
    private final ConcurrentMap<String, ItemStack> items;

    public ItemRegistry(AureliumSkills plugin) {
        this.plugin = plugin;
        this.items = new ConcurrentHashMap<String, ItemStack>();
    }

    public void register(String key, ItemStack item) {
        this.items.put(key, item.clone());
    }

    public void unregister(String key) {
        this.items.remove(key);
    }

    @Nullable
    public ItemStack getItem(String key) {
        ItemStack item = (ItemStack)this.items.get(key);
        if (item != null) {
            return item.clone();
        }
        return null;
    }

    public Set<String> getKeys() {
        return this.items.keySet();
    }

    public void loadFromFile() {
        File file = new File(this.plugin.getDataFolder(), "items.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection == null) {
            return;
        }
        int itemsRegistered = 0;
        for (String key : itemsSection.getKeys(false)) {
            ItemStack item = itemsSection.getItemStack(key);
            if (item == null) {
                this.plugin.getLogger().warning("Failed to load item at path items." + key + " in items.yml, did you edit this file? This file should not be edited directly and items should only be added in game through the command /skills item register");
                continue;
            }
            this.items.put(key, item);
            ++itemsRegistered;
        }
        if (itemsRegistered > 1) {
            this.plugin.getLogger().info("Registered " + itemsRegistered + " items");
        } else if (itemsRegistered == 1) {
            this.plugin.getLogger().info("Registered " + itemsRegistered + " item");
        }
    }

    public void saveToFile() {
        File file = new File(this.plugin.getDataFolder(), "items.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("items", null);
        for (Map.Entry entry : this.items.entrySet()) {
            config.set("items." + (String)entry.getKey(), entry.getValue());
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save items.yml, see error below:");
            e.printStackTrace();
        }
    }
}

