/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.storage;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.AbstractAbility;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.AbilityData;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.data.storage.StorageProvider;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.leaderboard.LeaderboardManager;
import com.archyx.aureliumskills.leaderboard.SkillValue;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.util.misc.KeyIntPair;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class YamlStorageProvider
extends StorageProvider {
    public YamlStorageProvider(AureliumSkills plugin) {
        super(plugin);
    }

    @Override
    public void load(Player player) {
        File file = new File(this.plugin.getDataFolder() + "/playerdata/" + player.getUniqueId() + ".yml");
        if (file.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            PlayerData playerData = new PlayerData(player, this.plugin);
            try {
                List unclaimedItemsList;
                ConfigurationSection abilitySection;
                UUID id = UUID.fromString(config.getString("uuid", player.getUniqueId().toString()));
                if (!player.getUniqueId().equals(id)) {
                    throw new IllegalArgumentException("File name and uuid field do not match!");
                }
                for (Skills skill : Skills.values()) {
                    String path = "skills." + skill.name().toLowerCase(Locale.ROOT) + ".";
                    int level = config.getInt(path + "level", 1);
                    double xp = config.getDouble(path + "xp", 0.0);
                    playerData.setSkillLevel(skill, level);
                    playerData.setSkillXp(skill, xp);
                    this.plugin.getRewardManager().getRewardTable(skill).applyStats(playerData, level);
                }
                ConfigurationSection modifiersSection = config.getConfigurationSection("stat_modifiers");
                if (modifiersSection != null) {
                    for (String entry : modifiersSection.getKeys(false)) {
                        ConfigurationSection modifierEntry = modifiersSection.getConfigurationSection(entry);
                        if (modifierEntry == null) continue;
                        String name = modifierEntry.getString("name");
                        String statName = modifierEntry.getString("stat");
                        double value = modifierEntry.getDouble("value");
                        if (name == null || statName == null) continue;
                        Stat stat = this.plugin.getStatRegistry().getStat(statName);
                        StatModifier modifier = new StatModifier(name, stat, value);
                        playerData.addStatModifier(modifier);
                    }
                }
                playerData.setMana(config.getDouble("mana"));
                String locale = config.getString("locale");
                if (locale != null) {
                    playerData.setLocale(new Locale(locale));
                }
                if ((abilitySection = config.getConfigurationSection("ability_data")) != null) {
                    for (String abilityName : abilitySection.getKeys(false)) {
                        AbstractAbility ability;
                        ConfigurationSection abilityEntry = abilitySection.getConfigurationSection(abilityName);
                        if (abilityEntry == null || (ability = AbstractAbility.valueOf(abilityName.toUpperCase(Locale.ROOT))) == null) continue;
                        AbilityData abilityData = playerData.getAbilityData(ability);
                        for (String key : abilityEntry.getKeys(false)) {
                            Object value = abilityEntry.get(key);
                            abilityData.setData(key, value);
                        }
                    }
                }
                if ((unclaimedItemsList = config.getStringList("unclaimed_items")).size() > 0) {
                    ArrayList<KeyIntPair> unclaimedItems = new ArrayList<KeyIntPair>();
                    for (String entry : unclaimedItemsList) {
                        String[] splitEntry = entry.split(" ");
                        String itemKey = splitEntry[0];
                        int amount = 1;
                        if (splitEntry.length >= 2) {
                            amount = NumberUtils.toInt((String)splitEntry[1], (int)1);
                        }
                        unclaimedItems.add(new KeyIntPair(itemKey, amount));
                    }
                    playerData.setUnclaimedItems(unclaimedItems);
                    playerData.clearInvalidItems();
                }
                this.playerManager.addPlayerData(playerData);
                this.plugin.getLeveler().updatePermissions(player);
                final PlayerDataLoadEvent event = new PlayerDataLoadEvent(playerData);
                new BukkitRunnable(){

                    public void run() {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                }.runTask((Plugin)this.plugin);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("There was an error loading player data for player " + player.getName() + " with UUID " + player.getUniqueId() + ", see below for details.");
                e.printStackTrace();
                PlayerData data = this.createNewPlayer(player);
                data.setShouldSave(false);
                this.sendErrorMessageToPlayer(player, e);
            }
        } else {
            this.createNewPlayer(player);
        }
    }

    @Override
    public void save(Player player, boolean removeFromMemory) {
        PlayerData playerData = this.playerManager.getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.shouldNotSave()) {
            return;
        }
        if (playerData.isSaving()) {
            return;
        }
        playerData.setSaving(true);
        File file = new File(this.plugin.getDataFolder() + "/playerdata/" + player.getUniqueId() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        try {
            String path;
            config.set("uuid", (Object)player.getUniqueId().toString());
            for (Skills skill : Skills.values()) {
                path = "skills." + skill.toString().toLowerCase(Locale.ROOT) + ".";
                config.set(path + "level", (Object)playerData.getSkillLevel(skill));
                config.set(path + "xp", (Object)playerData.getSkillXp(skill));
            }
            config.set("stat_modifiers", null);
            int count = 0;
            for (StatModifier modifier : playerData.getStatModifiers().values()) {
                String path2 = "stat_modifiers." + count + ".";
                config.set(path2 + "name", (Object)modifier.getName());
                config.set(path2 + "stat", (Object)modifier.getStat().toString().toLowerCase(Locale.ROOT));
                config.set(path2 + "value", (Object)modifier.getValue());
                ++count;
            }
            config.set("mana", (Object)playerData.getMana());
            Locale locale = playerData.getLocale();
            if (locale != null) {
                config.set("locale", (Object)locale.toString());
            }
            for (AbilityData abilityData : playerData.getAbilityDataMap().values()) {
                path = "ability_data." + abilityData.getAbility().toString().toLowerCase(Locale.ROOT) + ".";
                for (Map.Entry<String, Object> entry : abilityData.getDataMap().entrySet()) {
                    config.set(path + entry.getKey(), entry.getValue());
                }
            }
            List<KeyIntPair> unclaimedItems = playerData.getUnclaimedItems();
            config.set("unclaimed_items", null);
            if (unclaimedItems != null && unclaimedItems.size() > 0) {
                ArrayList<String> stringList = new ArrayList<String>();
                for (KeyIntPair unclaimedItem : unclaimedItems) {
                    stringList.add(unclaimedItem.getKey() + " " + unclaimedItem.getValue());
                }
                config.set("unclaimed_items", stringList);
            }
            config.save(file);
            if (removeFromMemory) {
                this.playerManager.removePlayerData(player.getUniqueId());
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("There was an error saving player data for player " + player.getName() + " with UUID " + player.getUniqueId() + ", see below for details.");
            e.printStackTrace();
        }
        playerData.setSaving(false);
    }

    @Override
    public void loadBackup(FileConfiguration config, CommandSender sender) {
        ConfigurationSection playerDataSection = config.getConfigurationSection("player_data");
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (playerDataSection != null) {
            try {
                for (String stringId : playerDataSection.getKeys(false)) {
                    UUID id = UUID.fromString(stringId);
                    Map<Skill, Integer> levels = this.getLevelsFromBackup(playerDataSection, stringId);
                    Map<Skill, Double> xpLevels = this.getXpLevelsFromBackup(playerDataSection, stringId);
                    PlayerData playerData = this.playerManager.getPlayerData(id);
                    if (playerData != null) {
                        this.applyData(playerData, levels, xpLevels);
                        continue;
                    }
                    File file = new File(this.plugin.getDataFolder() + "/playerdata/" + id + ".yml");
                    YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)file);
                    playerConfig.set("uuid", (Object)id.toString());
                    for (Skills skill : Skills.values()) {
                        String path = "skills." + skill.toString().toLowerCase(Locale.ROOT) + ".";
                        playerConfig.set(path + "level", (Object)levels.get(skill));
                        playerConfig.set(path + "xp", (Object)xpLevels.get(skill));
                    }
                    playerConfig.save(file);
                }
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_LOADED, locale));
            }
            catch (Exception e) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.BACKUP_LOAD_ERROR, locale), "{error}", e.getMessage()));
            }
        }
    }

    @Override
    public void updateLeaderboards() {
        File[] files;
        LeaderboardManager manager = this.plugin.getLeaderboardManager();
        manager.setSorting(true);
        HashMap<Skill, List<SkillValue>> leaderboards = new HashMap<Skill, List<SkillValue>>();
        for (Skills skill : Skills.values()) {
            leaderboards.put(skill, new ArrayList());
        }
        ArrayList<SkillValue> powerLeaderboard = new ArrayList<SkillValue>();
        ArrayList<SkillValue> averageLeaderboard = new ArrayList<SkillValue>();
        Set<UUID> loadedFromMemory = this.addLoadedPlayersToLeaderboards(leaderboards, powerLeaderboard, averageLeaderboard);
        File playerDataFolder = new File(this.plugin.getDataFolder() + "/playerdata");
        if (playerDataFolder.exists() && playerDataFolder.isDirectory() && (files = playerDataFolder.listFiles()) != null) {
            for (File file : files) {
                UUID id;
                if (!file.getName().endsWith(".yml") || loadedFromMemory.contains(id = UUID.fromString(file.getName().substring(0, file.getName().lastIndexOf(46))))) continue;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                try {
                    int powerLevel = 0;
                    double powerXp = 0.0;
                    int numEnabled = 0;
                    for (Skills skill : Skills.values()) {
                        String path = "skills." + skill.toString().toLowerCase(Locale.ROOT) + ".";
                        int level = config.getInt(path + "level", 1);
                        double xp = config.getDouble(path + "xp");
                        SkillValue skillLevel = new SkillValue(id, level, xp);
                        ((List)leaderboards.get(skill)).add(skillLevel);
                        if (!OptionL.isEnabled(skill)) continue;
                        powerLevel += level;
                        powerXp += xp;
                        ++numEnabled;
                    }
                    SkillValue powerValue = new SkillValue(id, powerLevel, powerXp);
                    powerLeaderboard.add(powerValue);
                    double averageLevel = (double)powerLevel / (double)numEnabled;
                    SkillValue averageValue = new SkillValue(id, 0, averageLevel);
                    averageLeaderboard.add(averageValue);
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("[AureliumSkills] Error reading playerdata file " + file.getName() + ", see error below for details:");
                    e.printStackTrace();
                }
            }
        }
        this.sortLeaderboards(leaderboards, powerLeaderboard, averageLeaderboard);
    }

    @Override
    public void delete(UUID uuid) throws IOException {
        File file = new File(this.plugin.getDataFolder() + "/playerdata/" + uuid.toString() + ".yml");
        if (file.exists()) {
            boolean success = file.delete();
            if (!success) {
                throw new IOException("Unable to delete file");
            }
        } else {
            throw new IOException("File not found in playerdata folder");
        }
    }
}

