/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.storage;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.data.PlayerManager;
import com.archyx.aureliumskills.leaderboard.AverageSorter;
import com.archyx.aureliumskills.leaderboard.LeaderboardManager;
import com.archyx.aureliumskills.leaderboard.LeaderboardSorter;
import com.archyx.aureliumskills.leaderboard.SkillValue;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatLeveler;
import com.archyx.aureliumskills.stats.Stats;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class StorageProvider {
    public final AureliumSkills plugin;
    public final PlayerManager playerManager;

    public StorageProvider(AureliumSkills plugin) {
        this.playerManager = plugin.getPlayerManager();
        this.plugin = plugin;
    }

    public PlayerData createNewPlayer(Player player) {
        PlayerData playerData = new PlayerData(player, this.plugin);
        this.playerManager.addPlayerData(playerData);
        this.plugin.getLeveler().updatePermissions(player);
        final PlayerDataLoadEvent event = new PlayerDataLoadEvent(playerData);
        new BukkitRunnable(){

            public void run() {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        }.runTask((Plugin)this.plugin);
        return playerData;
    }

    protected void sendErrorMessageToPlayer(Player player, Exception e) {
        player.sendMessage(ChatColor.RED + "There was an error loading your skill data: " + e.getMessage() + ". Please report the error to your server administrator. To prevent your data from resetting permanently, your skill data will not be saved. Try relogging to attempt loading again.");
    }

    protected void applyData(PlayerData playerData, Map<Skill, Integer> levels, Map<Skill, Double> xpLevels) {
        for (Stat stat : this.plugin.getStatRegistry().getStats()) {
            playerData.setStatLevel(stat, 0.0);
        }
        for (Skills skill : Skills.values()) {
            int level = levels.get(skill);
            playerData.setSkillLevel(skill, level);
            playerData.setSkillXp(skill, xpLevels.get(skill));
            this.plugin.getRewardManager().getRewardTable(skill).applyStats(playerData, level);
        }
        new StatLeveler(this.plugin).reloadStat(playerData.getPlayer(), Stats.HEALTH);
        new StatLeveler(this.plugin).reloadStat(playerData.getPlayer(), Stats.LUCK);
        new StatLeveler(this.plugin).reloadStat(playerData.getPlayer(), Stats.WISDOM);
        this.save(playerData.getPlayer(), false);
    }

    protected Map<Skill, Integer> getLevelsFromBackup(ConfigurationSection playerDataSection, String stringId) {
        HashMap<Skill, Integer> levels = new HashMap<Skill, Integer>();
        for (Skills skill : Skills.values()) {
            int level = playerDataSection.getInt(stringId + "." + skill.toString().toLowerCase(Locale.ROOT) + ".level", 1);
            levels.put(skill, level);
        }
        return levels;
    }

    protected Map<Skill, Double> getXpLevelsFromBackup(ConfigurationSection playerDataSection, String stringId) {
        HashMap<Skill, Double> xpLevels = new HashMap<Skill, Double>();
        for (Skills skill : Skills.values()) {
            double xp = playerDataSection.getDouble(stringId + "." + skill.toString().toLowerCase(Locale.ROOT) + ".xp");
            xpLevels.put(skill, xp);
        }
        return xpLevels;
    }

    protected Set<UUID> addLoadedPlayersToLeaderboards(Map<Skill, List<SkillValue>> leaderboards, List<SkillValue> powerLeaderboard, List<SkillValue> averageLeaderboard) {
        HashSet<UUID> loadedFromMemory = new HashSet<UUID>();
        for (PlayerData playerData : this.playerManager.getPlayerDataMap().values()) {
            UUID id = playerData.getPlayer().getUniqueId();
            int powerLevel = 0;
            double powerXp = 0.0;
            int numEnabled = 0;
            for (Skills skill : Skills.values()) {
                int level = playerData.getSkillLevel(skill);
                double xp = playerData.getSkillXp(skill);
                SkillValue skillLevel = new SkillValue(id, level, xp);
                leaderboards.get(skill).add(skillLevel);
                if (!OptionL.isEnabled(skill)) continue;
                powerLevel += level;
                powerXp += xp;
                ++numEnabled;
            }
            SkillValue powerValue = new SkillValue(id, powerLevel, powerXp);
            powerLeaderboard.add(powerValue);
            double averageLevel = (double)powerLevel / (double)numEnabled;
            SkillValue averageValue = new SkillValue(id, 0, averageLevel);
            averageLeaderboard.add(averageValue);
            loadedFromMemory.add(playerData.getPlayer().getUniqueId());
        }
        return loadedFromMemory;
    }

    protected void sortLeaderboards(Map<Skill, List<SkillValue>> leaderboards, List<SkillValue> powerLeaderboard, List<SkillValue> averageLeaderboard) {
        LeaderboardManager manager = this.plugin.getLeaderboardManager();
        LeaderboardSorter sorter = new LeaderboardSorter();
        for (Skills skill : Skills.values()) {
            leaderboards.get(skill).sort(sorter);
        }
        powerLeaderboard.sort(sorter);
        AverageSorter averageSorter = new AverageSorter();
        averageLeaderboard.sort(averageSorter);
        for (Skills skill : Skills.values()) {
            manager.setLeaderboard(skill, leaderboards.get(skill));
        }
        manager.setPowerLeaderboard(powerLeaderboard);
        manager.setAverageLeaderboard(averageLeaderboard);
        manager.setSorting(false);
    }

    public abstract void load(Player var1);

    public void save(Player player) {
        this.save(player, true);
    }

    public abstract void save(Player var1, boolean var2);

    public abstract void loadBackup(FileConfiguration var1, CommandSender var2);

    public abstract void updateLeaderboards();

    public abstract void delete(UUID var1) throws IOException;
}

