/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.storage;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.AbstractAbility;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.AbilityData;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerDataLoadEvent;
import com.archyx.aureliumskills.data.storage.StorageProvider;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.leaderboard.LeaderboardManager;
import com.archyx.aureliumskills.leaderboard.SkillValue;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.util.misc.KeyIntPair;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MySqlStorageProvider
extends StorageProvider {
    private Connection connection;
    private final String host = OptionL.getString(Option.MYSQL_HOST);
    private final String database = OptionL.getString(Option.MYSQL_DATABASE);
    private final String username = OptionL.getString(Option.MYSQL_USERNAME);
    private final String password = OptionL.getString(Option.MYSQL_PASSWORD);
    private final int port = OptionL.getInt(Option.MYSQL_PORT);
    private final boolean ssl = OptionL.getBoolean(Option.MYSQL_SSL);

    public MySqlStorageProvider(AureliumSkills plugin) {
        super(plugin);
    }

    public void init() {
        try {
            this.openConnection();
            this.createTable();
        }
        catch (ClassNotFoundException | SQLException e) {
            this.plugin.getLogger().severe("Failed to connect to MySQL database, see error below:");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection() throws SQLException, ClassNotFoundException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        MySqlStorageProvider mySqlStorageProvider = this;
        synchronized (mySqlStorageProvider) {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                Class.forName("com.mysql.jdbc.Driver");
            }
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=" + this.ssl + "&autoReconnect=true", this.username, this.password);
            this.plugin.getLogger().info("Connected to MySQL database");
        }
    }

    @Override
    public void load(Player player) {
        try {
            String query = "SELECT * FROM SkillData WHERE ID=?;";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, player.getUniqueId().toString());
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        String unclaimedItemsString;
                        String abilityData;
                        PlayerData playerData = new PlayerData(player, this.plugin);
                        for (Skills skill : Skills.values()) {
                            int level = result.getInt(skill.name().toUpperCase(Locale.ROOT) + "_LEVEL");
                            double xp = result.getDouble(skill.name().toUpperCase(Locale.ROOT) + "_XP");
                            playerData.setSkillLevel(skill, level);
                            playerData.setSkillXp(skill, xp);
                            this.plugin.getRewardManager().getRewardTable(skill).applyStats(playerData, level);
                        }
                        String statModifiers = result.getString("STAT_MODIFIERS");
                        if (statModifiers != null) {
                            JsonArray jsonModifiers = (JsonArray)new Gson().fromJson(statModifiers, JsonArray.class);
                            for (JsonElement modifierElement : jsonModifiers.getAsJsonArray()) {
                                JsonObject modifierObject = modifierElement.getAsJsonObject();
                                String name = modifierObject.get("name").getAsString();
                                String statName = modifierObject.get("stat").getAsString();
                                double value = modifierObject.get("value").getAsDouble();
                                if (name == null || statName == null) continue;
                                Stat stat = this.plugin.getStatRegistry().getStat(statName);
                                StatModifier modifier = new StatModifier(name, stat, value);
                                playerData.addStatModifier(modifier);
                            }
                        }
                        playerData.setMana(result.getDouble("mana"));
                        String locale = result.getString("locale");
                        if (locale != null) {
                            playerData.setLocale(new Locale(locale));
                        }
                        if ((abilityData = result.getString("ABILITY_DATA")) != null) {
                            JsonObject jsonAbilityData = (JsonObject)new Gson().fromJson(abilityData, JsonObject.class);
                            for (Map.Entry abilityEntry : jsonAbilityData.entrySet()) {
                                String abilityName = (String)abilityEntry.getKey();
                                AbstractAbility ability = AbstractAbility.valueOf(abilityName.toUpperCase(Locale.ROOT));
                                if (ability == null) continue;
                                AbilityData data = playerData.getAbilityData(ability);
                                JsonObject dataObject = ((JsonElement)abilityEntry.getValue()).getAsJsonObject();
                                for (Map.Entry dataEntry : dataObject.entrySet()) {
                                    Object value;
                                    String key = (String)dataEntry.getKey();
                                    JsonElement element = (JsonElement)dataEntry.getValue();
                                    if (!element.isJsonPrimitive() || (value = this.parsePrimitive(((JsonElement)dataEntry.getValue()).getAsJsonPrimitive())) == null) continue;
                                    data.setData(key, value);
                                }
                            }
                        }
                        if ((unclaimedItemsString = result.getString("UNCLAIMED_ITEMS")) != null) {
                            String[] splitString;
                            ArrayList<KeyIntPair> unclaimedItems = new ArrayList<KeyIntPair>();
                            for (String entry : splitString = unclaimedItemsString.split(",")) {
                                String[] splitEntry = entry.split(" ");
                                String itemKey = splitEntry[0];
                                int amount = 1;
                                if (splitEntry.length >= 2) {
                                    amount = NumberUtils.toInt((String)splitEntry[1], (int)1);
                                }
                                unclaimedItems.add(new KeyIntPair(itemKey, amount));
                            }
                            playerData.setUnclaimedItems(unclaimedItems);
                            playerData.clearInvalidItems();
                        }
                        this.playerManager.addPlayerData(playerData);
                        this.plugin.getLeveler().updatePermissions(player);
                        final PlayerDataLoadEvent event = new PlayerDataLoadEvent(playerData);
                        new BukkitRunnable(){

                            public void run() {
                                Bukkit.getPluginManager().callEvent((Event)event);
                            }
                        }.runTask((Plugin)this.plugin);
                    } else {
                        this.createNewPlayer(player);
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("There was an error loading player data for player " + player.getName() + " with UUID " + player.getUniqueId() + ", see below for details.");
            e.printStackTrace();
            PlayerData playerData = this.createNewPlayer(player);
            playerData.setShouldSave(false);
            this.sendErrorMessageToPlayer(player, e);
        }
    }

    private void createTable() throws SQLException {
        DatabaseMetaData dbm = this.connection.getMetaData();
        ResultSet tables = dbm.getTables(null, null, "SkillData", null);
        if (!tables.next()) {
            try (Statement statement = this.connection.createStatement(1003, 1008);){
                statement.execute("CREATE TABLE SkillData (ID varchar(40), AGILITY_LEVEL int, AGILITY_XP double, ALCHEMY_LEVEL int, ALCHEMY_XP double, ARCHERY_LEVEL int, ARCHERY_XP double, DEFENSE_LEVEL int, DEFENSE_XP double, ENCHANTING_LEVEL int, ENCHANTING_XP double, ENDURANCE_LEVEL int, ENDURANCE_XP double, EXCAVATION_LEVEL int, EXCAVATION_XP double, FARMING_LEVEL int, FARMING_XP double, FIGHTING_LEVEL int, FIGHTING_XP double, FISHING_LEVEL int, FISHING_XP double, FORAGING_LEVEL int, FORAGING_XP double, FORGING_LEVEL int, FORGING_XP double, HEALING_LEVEL int, HEALING_XP double, MINING_LEVEL int, MINING_XP double, SORCERY_LEVEL int, SORCERY_XP double, LOCALE varchar(10), STAT_MODIFIERS varchar(4096), MANA double, ABILITY_DATA varchar(4096), UNCLAIMED_ITEMS varchar(4096), CONSTRAINT PKEY PRIMARY KEY (ID))");
            }
        }
    }

    @Override
    public void save(Player player, boolean removeFromMemory) {
        PlayerData playerData = this.playerManager.getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.shouldNotSave()) {
            return;
        }
        try {
            StringBuilder sqlBuilder = new StringBuilder("INSERT INTO SkillData (ID, ");
            for (Skill skill : Skills.getOrderedValues()) {
                sqlBuilder.append(skill.toString()).append("_LEVEL, ");
                sqlBuilder.append(skill).append("_XP, ");
            }
            sqlBuilder.append("LOCALE, STAT_MODIFIERS, MANA, ABILITY_DATA, UNCLAIMED_ITEMS) VALUES(?, ");
            for (int i = 0; i < Skills.getOrderedValues().size(); ++i) {
                sqlBuilder.append("?, ?, ");
            }
            sqlBuilder.append("?, ?, ?, ?, ?) ");
            sqlBuilder.append("ON DUPLICATE KEY UPDATE ");
            for (Skill skill : Skills.getOrderedValues()) {
                sqlBuilder.append(skill.toString()).append("_LEVEL=?, ");
                sqlBuilder.append(skill).append("_XP=?, ");
            }
            sqlBuilder.append("LOCALE=?, ");
            sqlBuilder.append("STAT_MODIFIERS=?, ");
            sqlBuilder.append("MANA=?, ");
            sqlBuilder.append("ABILITY_DATA=?, ");
            sqlBuilder.append("UNCLAIMED_ITEMS=?");
            Throwable throwable = null;
            try (PreparedStatement statement = this.connection.prepareStatement(sqlBuilder.toString());){
                statement.setString(1, player.getUniqueId().toString());
                int index = 2;
                for (int i = 0; i < 2; ++i) {
                    for (Skill skill : Skills.getOrderedValues()) {
                        statement.setInt(index++, playerData.getSkillLevel(skill));
                        statement.setDouble(index++, playerData.getSkillXp(skill));
                    }
                    statement.setString(index++, playerData.getLocale().toString());
                    StringBuilder modifiersJson = new StringBuilder();
                    if (playerData.getStatModifiers().size() > 0) {
                        modifiersJson.append("[");
                        for (Object statModifier : playerData.getStatModifiers().values()) {
                            modifiersJson.append("{\"name\":\"").append(((StatModifier)statModifier).getName()).append("\",\"stat\":\"").append(((StatModifier)statModifier).getStat().toString().toLowerCase(Locale.ROOT)).append("\",\"value\":").append(((StatModifier)statModifier).getValue()).append("},");
                        }
                        modifiersJson.deleteCharAt(modifiersJson.length() - 1);
                        modifiersJson.append("]");
                    }
                    if (!modifiersJson.toString().equals("")) {
                        statement.setString(index++, modifiersJson.toString());
                    } else {
                        statement.setNull(index++, 12);
                    }
                    statement.setDouble(index++, playerData.getMana());
                    StringBuilder stringBuilder = new StringBuilder();
                    if (playerData.getAbilityDataMap().size() > 0) {
                        Object statModifier;
                        stringBuilder.append("{");
                        statModifier = playerData.getAbilityDataMap().values().iterator();
                        while (statModifier.hasNext()) {
                            AbilityData abilityData = (AbilityData)statModifier.next();
                            String abilityName = abilityData.getAbility().toString().toLowerCase(Locale.ROOT);
                            if (abilityData.getDataMap().size() <= 0) continue;
                            stringBuilder.append("\"").append(abilityName).append("\"").append(":{");
                            for (Map.Entry<String, Object> dataEntry : abilityData.getDataMap().entrySet()) {
                                String value = String.valueOf(dataEntry.getValue());
                                if (dataEntry.getValue() instanceof String) {
                                    value = "\"" + dataEntry.getValue() + "\"";
                                }
                                stringBuilder.append("\"").append(dataEntry.getKey()).append("\":").append(value).append(",");
                            }
                            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                            stringBuilder.append("},");
                        }
                        if (stringBuilder.length() > 1) {
                            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                        }
                        stringBuilder.append("}");
                    }
                    if (!stringBuilder.toString().equals("")) {
                        statement.setString(index++, stringBuilder.toString());
                    } else {
                        statement.setNull(index++, 12);
                    }
                    StringBuilder unclaimedItemsStringBuilder = new StringBuilder();
                    List<KeyIntPair> unclaimedItems = playerData.getUnclaimedItems();
                    if (unclaimedItems != null) {
                        for (KeyIntPair unclaimedItem : unclaimedItems) {
                            unclaimedItemsStringBuilder.append(unclaimedItem.getKey()).append(" ").append(unclaimedItem.getValue()).append(",");
                        }
                    }
                    if (unclaimedItemsStringBuilder.length() > 0) {
                        unclaimedItemsStringBuilder.deleteCharAt(unclaimedItemsStringBuilder.length() - 1);
                    }
                    if (!unclaimedItemsStringBuilder.toString().equals("")) {
                        statement.setString(index++, unclaimedItemsStringBuilder.toString());
                        continue;
                    }
                    statement.setNull(index++, 12);
                }
                statement.executeUpdate();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            if (removeFromMemory) {
                this.playerManager.removePlayerData(player.getUniqueId());
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("There was an error saving player data for player " + player.getName() + " with UUID " + player.getUniqueId() + ", see below for details.");
            e.printStackTrace();
        }
    }

    @Override
    public void loadBackup(FileConfiguration config, CommandSender sender) {
        ConfigurationSection playerDataSection = config.getConfigurationSection("player_data");
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (playerDataSection != null) {
            try {
                for (String stringId : playerDataSection.getKeys(false)) {
                    UUID id = UUID.fromString(stringId);
                    Map<Skill, Integer> levels = this.getLevelsFromBackup(playerDataSection, stringId);
                    Map<Skill, Double> xpLevels = this.getXpLevelsFromBackup(playerDataSection, stringId);
                    PlayerData playerData = this.playerManager.getPlayerData(id);
                    if (playerData != null) {
                        this.applyData(playerData, levels, xpLevels);
                        continue;
                    }
                    StringBuilder sqlBuilder = new StringBuilder("INSERT INTO SkillData (ID, ");
                    for (Skill skill : Skills.getOrderedValues()) {
                        sqlBuilder.append(skill.toString()).append("_LEVEL, ");
                        sqlBuilder.append(skill).append("_XP, ");
                    }
                    sqlBuilder.delete(sqlBuilder.length() - 2, sqlBuilder.length());
                    sqlBuilder.append(") VALUES(?, ");
                    for (int i = 0; i < Skills.getOrderedValues().size(); ++i) {
                        sqlBuilder.append("?, ?, ");
                    }
                    sqlBuilder.delete(sqlBuilder.length() - 2, sqlBuilder.length());
                    sqlBuilder.append(") ");
                    sqlBuilder.append("ON DUPLICATE KEY UPDATE ");
                    for (Skill skill : Skills.getOrderedValues()) {
                        sqlBuilder.append(skill.toString()).append("_LEVEL=?, ");
                        sqlBuilder.append(skill).append("_XP=?, ");
                    }
                    sqlBuilder.delete(sqlBuilder.length() - 2, sqlBuilder.length());
                    PreparedStatement statement = this.connection.prepareStatement(sqlBuilder.toString());
                    Throwable throwable = null;
                    try {
                        statement.setString(1, id.toString());
                        int index = 2;
                        for (int i = 0; i < 2; ++i) {
                            for (Skill skill : Skills.getOrderedValues()) {
                                statement.setInt(index++, levels.get(skill));
                                statement.setDouble(index++, xpLevels.get(skill));
                            }
                        }
                        statement.executeUpdate();
                        sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_LOADED, locale));
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
            }
            catch (Exception e) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.BACKUP_LOAD_ERROR, locale), "{error}", e.getMessage()));
            }
        }
    }

    private Object parsePrimitive(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isNumber()) {
            if (primitive.getAsDouble() % 1.0 != 0.0) {
                return primitive.getAsDouble();
            }
            return primitive.getAsInt();
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean localeColumnExists() {
        try {
            DatabaseMetaData dbm = this.connection.getMetaData();
            try (ResultSet columns = dbm.getColumns(null, null, "SkillData", "LOCALE");){
                if (!columns.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateLeaderboards() {
        LeaderboardManager manager = this.plugin.getLeaderboardManager();
        manager.setSorting(true);
        HashMap<Skill, List<SkillValue>> leaderboards = new HashMap<Skill, List<SkillValue>>();
        for (Skills skill : Skills.values()) {
            leaderboards.put(skill, new ArrayList());
        }
        ArrayList<SkillValue> powerLeaderboard = new ArrayList<SkillValue>();
        ArrayList<SkillValue> averageLeaderboard = new ArrayList<SkillValue>();
        Set<UUID> loadedFromMemory = this.addLoadedPlayersToLeaderboards(leaderboards, powerLeaderboard, averageLeaderboard);
        try (Statement statement = this.connection.createStatement();){
            String query = "SELECT * FROM SkillData;";
            try (ResultSet result = statement.executeQuery(query);){
                while (result.next()) {
                    try {
                        UUID id = UUID.fromString(result.getString("ID"));
                        if (loadedFromMemory.contains(id)) continue;
                        int powerLevel = 0;
                        double powerXp = 0.0;
                        int numEnabled = 0;
                        for (Skills skill : Skills.values()) {
                            int level = result.getInt(skill.toString().toUpperCase(Locale.ROOT) + "_LEVEL");
                            if (level == 0) {
                                level = 1;
                            }
                            double xp = result.getDouble(skill.toString().toUpperCase(Locale.ROOT) + "_XP");
                            SkillValue skillLevel = new SkillValue(id, level, xp);
                            ((List)leaderboards.get(skill)).add(skillLevel);
                            if (!OptionL.isEnabled(skill)) continue;
                            powerLevel += level;
                            powerXp += xp;
                            ++numEnabled;
                        }
                        SkillValue powerValue = new SkillValue(id, powerLevel, powerXp);
                        powerLeaderboard.add(powerValue);
                        double averageLevel = (double)powerLevel / (double)numEnabled;
                        SkillValue averageValue = new SkillValue(id, 0, averageLevel);
                        averageLeaderboard.add(averageValue);
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().warning("[AureliumSkills] Error reading player with uuid " + result.getString("ID") + " from the database!");
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Error while updating leaderboards:");
            e.printStackTrace();
        }
        this.sortLeaderboards(leaderboards, powerLeaderboard, averageLeaderboard);
    }

    @Override
    public void delete(UUID uuid) throws IOException {
        String query = "DELETE FROM SkillData WHERE ID=?;";
        try (PreparedStatement statement = this.connection.prepareStatement(query);){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException("Failed to delete player data from database");
        }
    }
}

