/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.converter;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.converter.DataConverter;
import com.archyx.aureliumskills.data.storage.MySqlStorageProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.Bukkit;

public class LegacyMysqlToMysqlConverter
extends DataConverter {
    private final MySqlStorageProvider storageProvider;

    public LegacyMysqlToMysqlConverter(AureliumSkills plugin, MySqlStorageProvider storageProvider) {
        super(plugin);
        this.storageProvider = storageProvider;
    }

    @Override
    public void convert() {
        block27: {
            Connection connection = this.storageProvider.getConnection();
            try {
                ResultSet unclaimedItemsColumn;
                DatabaseMetaData dbm = connection.getMetaData();
                ResultSet tables = dbm.getTables(null, null, "SkillData", null);
                if (!tables.next()) break block27;
                ResultSet localeColumn = dbm.getColumns(null, null, "SkillData", "LOCALE");
                if (!localeColumn.next()) {
                    try (Statement statement = connection.createStatement(1003, 1008);){
                        statement.execute("ALTER TABLE SkillData ADD COLUMN LOCALE varchar(10), ADD COLUMN STAT_MODIFIERS varchar(4096), ADD COLUMN MANA double, ADD COLUMN ABILITY_DATA varchar(4096), DROP COLUMN NAME;");
                        Bukkit.getLogger().info("[AureliumSkills] Successfully converted old MySQL format to new format");
                    }
                }
                if ((unclaimedItemsColumn = dbm.getColumns(null, null, "SkillData", "UNCLAIMED_ITEMS")).next()) break block27;
                try (Statement statement = connection.createStatement(1003, 1008);){
                    statement.execute("ALTER TABLE SkillData ADD COLUMN UNCLAIMED_ITEMS varchar(4096);");
                    this.plugin.getLogger().info("Successfully added UNCLAIMED_ITEMS column to database");
                }
            }
            catch (SQLException e) {
                Bukkit.getLogger().warning("[AureliumSkills] Error converting legacy MySQL table to new format, see error below for details:");
                e.printStackTrace();
            }
        }
    }
}

