/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.converter;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.converter.DataConverter;
import com.archyx.aureliumskills.util.file.FileUtil;
import java.io.File;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyFileToYamlConverter
extends DataConverter {
    public LegacyFileToYamlConverter(AureliumSkills plugin) {
        super(plugin);
    }

    @Override
    public void convert() {
        File file = new File(this.plugin.getDataFolder(), "data.yml");
        if (file.exists()) {
            String renamedName;
            Bukkit.getLogger().info("[AureliumSkills] Converting legacy file data to new yaml file format...");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            ConfigurationSection skillData = config.getConfigurationSection("skillData");
            int playersConverted = 0;
            if (skillData != null) {
                for (String stringUUID : skillData.getKeys(false)) {
                    try {
                        UUID uuid = UUID.fromString(stringUUID);
                        File playerDataFile = new File(this.plugin.getDataFolder() + "/playerdata/" + uuid + ".yml");
                        if (playerDataFile.exists()) continue;
                        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerDataFile);
                        playerConfig.set("uuid", (Object)uuid.toString());
                        ConfigurationSection playerSection = skillData.getConfigurationSection(stringUUID);
                        if (playerSection == null) continue;
                        ConfigurationSection skills = playerSection.getConfigurationSection("skills");
                        if (skills != null) {
                            for (String skillName : skills.getKeys(false)) {
                                String[] splitLegacySkillData;
                                String legacySkillData = skills.getString(skillName);
                                if (legacySkillData == null || (splitLegacySkillData = legacySkillData.split(":")).length != 2) continue;
                                int level = Integer.parseInt(splitLegacySkillData[0]);
                                double xp = Double.parseDouble(splitLegacySkillData[1]);
                                String path = "skills." + skillName.toLowerCase(Locale.ROOT) + ".";
                                playerConfig.set(path + "level", (Object)level);
                                playerConfig.set(path + "xp", (Object)xp);
                            }
                        }
                        playerConfig.save(playerDataFile);
                        ++playersConverted;
                    }
                    catch (Exception e) {
                        Bukkit.getLogger().warning("[AureliumSkills] There was an error converting skill data for player with uuid " + stringUUID + ", see below for details:");
                        e.printStackTrace();
                    }
                }
            }
            if ((renamedName = FileUtil.renameNoDuplicates(file, "data-OLD.yml", this.plugin.getDataFolder())) != null) {
                Bukkit.getLogger().info("[AureliumSkills] Successfully renamed data.yml to " + renamedName);
            } else {
                Bukkit.getLogger().warning("[AureliumSkills] Failed to rename old data.yml file");
            }
            Bukkit.getLogger().info("[AureliumSkills] Successfully converted " + playersConverted + " player skill data to the new yaml file format!");
        }
    }
}

