/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.backup;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.backup.BackupProvider;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class YamlBackup
extends BackupProvider {
    public YamlBackup(AureliumSkills plugin) {
        super(plugin);
    }

    @Override
    public void saveBackup(CommandSender sender, boolean savePlayerData) {
        try {
            File[] files;
            if (savePlayerData) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.plugin.getStorageProvider().save(player, false);
                }
            }
            this.createBackupFolder();
            LocalTime time = LocalTime.now();
            File backupFile = new File(this.plugin.getDataFolder() + "/backups/backup-" + LocalDate.now() + "_" + time.getHour() + "-" + time.getMinute() + "-" + time.getSecond() + ".yml");
            YamlConfiguration backup = YamlConfiguration.loadConfiguration((File)backupFile);
            backup.set("backup_version", (Object)1);
            File playerDataFolder = new File(this.plugin.getDataFolder() + "/playerdata");
            if (playerDataFolder.exists() && playerDataFolder.isDirectory() && (files = playerDataFolder.listFiles()) != null) {
                for (File file : files) {
                    YamlConfiguration config;
                    String stringId;
                    if (!file.getName().endsWith(".yml") || (stringId = (config = YamlConfiguration.loadConfiguration((File)file)).getString("uuid")) == null) continue;
                    for (Skills skill : Skills.values()) {
                        int level = config.getInt("skills." + skill.toString().toLowerCase(Locale.ROOT) + ".level");
                        double xp = config.getInt("skills." + skill.toString().toLowerCase(Locale.ROOT) + ".xp");
                        String path = "player_data." + stringId + "." + skill.toString().toLowerCase(Locale.ROOT) + ".";
                        backup.set(path + "level", (Object)level);
                        backup.set(path + "xp", (Object)xp);
                    }
                }
            }
            backup.save(backupFile);
            Locale locale = this.plugin.getLang().getLocale(sender);
            String message = AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.BACKUP_SAVE_SAVED, locale), "{type}", "Yaml", "{file}", backupFile.getName());
            if (sender instanceof ConsoleCommandSender) {
                message = ChatColor.stripColor((String)message);
            }
            sender.sendMessage(message);
        }
        catch (Exception e) {
            Locale locale = this.plugin.getLang().getLocale(sender);
            String message = AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.BACKUP_SAVE_ERROR, locale), "{type}", "Yaml");
            if (sender instanceof ConsoleCommandSender) {
                Bukkit.getLogger().warning(ChatColor.stripColor((String)message));
            } else {
                sender.sendMessage(message);
            }
            e.printStackTrace();
        }
    }
}

