/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.backup;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.backup.BackupProvider;
import com.archyx.aureliumskills.data.storage.MySqlStorageProvider;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.util.text.TextUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MysqlBackup
extends BackupProvider {
    private final MySqlStorageProvider storageProvider;

    public MysqlBackup(AureliumSkills plugin, MySqlStorageProvider storageProvider) {
        super(plugin);
        this.storageProvider = storageProvider;
    }

    @Override
    public void saveBackup(CommandSender sender, boolean savePlayerData) {
        try {
            if (savePlayerData) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.storageProvider.save(player, false);
                }
            }
            Connection connection = this.storageProvider.getConnection();
            try (Statement statement = connection.createStatement();){
                String query = "SELECT * FROM SkillData;";
                try (ResultSet result = statement.executeQuery(query);){
                    this.createBackupFolder();
                    LocalTime time = LocalTime.now();
                    File file = new File(this.plugin.getDataFolder() + "/backups/backup-" + LocalDate.now() + "_" + time.getHour() + "-" + time.getMinute() + "-" + time.getSecond() + ".yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    config.set("backup_version", (Object)1);
                    while (result.next()) {
                        UUID id = UUID.fromString(result.getString("ID"));
                        for (Skills skill : Skills.values()) {
                            int level = result.getInt(skill.toString().toUpperCase(Locale.ROOT) + "_LEVEL");
                            double xp = result.getDouble(skill.toString().toUpperCase(Locale.ROOT) + "_XP");
                            String path = "player_data." + id + "." + skill.toString().toLowerCase(Locale.ROOT) + ".";
                            config.set(path + "level", (Object)level);
                            config.set(path + "xp", (Object)xp);
                        }
                    }
                    config.save(file);
                    Locale locale = this.plugin.getLang().getLocale(sender);
                    String message = TextUtil.replace(Lang.getMessage(CommandMessage.BACKUP_SAVE_SAVED, locale), "{type}", "MySQL", "{file}", file.getName());
                    if (sender instanceof ConsoleCommandSender) {
                        this.plugin.getLogger().info(ChatColor.stripColor((String)message));
                    } else {
                        sender.sendMessage(AureliumSkills.getPrefix(locale) + message);
                    }
                }
            }
        }
        catch (Exception e) {
            Locale locale = this.plugin.getLang().getLocale(sender);
            String message = TextUtil.replace(Lang.getMessage(CommandMessage.BACKUP_SAVE_ERROR, locale), "{type}", "MySQL");
            if (sender instanceof ConsoleCommandSender) {
                this.plugin.getLogger().warning(ChatColor.stripColor((String)message));
            } else {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + message);
            }
            e.printStackTrace();
        }
    }
}

