/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data.backup;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.data.backup.BackupProvider;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyFileBackup
extends BackupProvider {
    public LegacyFileBackup(AureliumSkills plugin) {
        super(plugin);
    }

    @Override
    public void saveBackup(CommandSender sender, boolean savePlayerData) {
        try {
            File file = new File(this.plugin.getDataFolder(), "data.yml");
            if (!file.exists()) {
                return;
            }
            this.createBackupFolder();
            LocalTime time = LocalTime.now();
            File backupFile = new File(this.plugin.getDataFolder() + "/backups/backup-" + LocalDate.now() + "_" + time.getHour() + "-" + time.getMinute() + "-" + time.getSecond() + ".yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)backupFile);
            config.set("backup_version", (Object)"1");
            ConfigurationSection skillData = data.getConfigurationSection("skillData");
            if (skillData != null) {
                for (String stringId : skillData.getKeys(false)) {
                    ConfigurationSection skills;
                    ConfigurationSection playerSection = skillData.getConfigurationSection(stringId);
                    if (playerSection == null || (skills = playerSection.getConfigurationSection("skills")) == null) continue;
                    for (String skillName : skills.getKeys(false)) {
                        String[] splitLegacySkillData;
                        String legacySkillData = skills.getString(skillName);
                        if (legacySkillData == null || (splitLegacySkillData = legacySkillData.split(":")).length != 2) continue;
                        int level = Integer.parseInt(splitLegacySkillData[0]);
                        double xp = Double.parseDouble(splitLegacySkillData[1]);
                        String path = "player_data." + stringId + "." + skillName.toLowerCase(Locale.ROOT) + ".";
                        config.set(path + "level", (Object)level);
                        config.set(path + "xp", (Object)xp);
                    }
                }
            }
            config.save(backupFile);
            sender.sendMessage("[AureliumSkills] Backed up legacy data.yml file as " + backupFile.getName());
        }
        catch (Exception e) {
            sender.sendMessage("[AureliumSkills] Error backing up legacy data file! See error below for details:");
            e.printStackTrace();
        }
    }
}

