/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManager {
    private final AureliumSkills plugin;
    private final ConcurrentHashMap<UUID, PlayerData> playerData;

    public PlayerManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.playerData = new ConcurrentHashMap();
        if (OptionL.getBoolean(Option.AUTO_SAVE_ENABLED)) {
            this.startAutoSave();
        }
    }

    @Nullable
    public PlayerData getPlayerData(Player player) {
        return this.playerData.get(player.getUniqueId());
    }

    @Nullable
    public PlayerData getPlayerData(UUID id) {
        return this.playerData.get(id);
    }

    public void addPlayerData(@NotNull PlayerData playerData) {
        this.playerData.put(playerData.getPlayer().getUniqueId(), playerData);
    }

    public void removePlayerData(UUID id) {
        this.playerData.remove(id);
    }

    public boolean hasPlayerData(Player player) {
        return this.playerData.containsKey(player.getUniqueId());
    }

    public ConcurrentHashMap<UUID, PlayerData> getPlayerDataMap() {
        return this.playerData;
    }

    public void startAutoSave() {
        long interval = OptionL.getInt(Option.AUTO_SAVE_INTERVAL_TICKS);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PlayerData playerData = PlayerManager.this.plugin.getPlayerManager().getPlayerData(player);
                    if (playerData == null || playerData.isSaving()) continue;
                    PlayerManager.this.plugin.getStorageProvider().save(player, false);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, interval, interval);
    }
}

