/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.data;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbstractAbility;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.AbilityData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.modifier.Multiplier;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.rewards.RewardTable;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Luck;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.util.misc.KeyIntPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    private final Player player;
    private final AureliumSkills plugin;
    private final Map<Skill, Integer> skillLevels;
    private final Map<Skill, Double> skillXp;
    private final Map<Stat, Double> statLevels;
    private final Map<String, StatModifier> statModifiers;
    private double mana;
    private Locale locale;
    private final Map<AbstractAbility, AbilityData> abilityData;
    private final Map<String, Object> metadata;
    private List<KeyIntPair> unclaimedItems;
    private boolean saving;
    private boolean shouldSave;
    private final Map<String, Multiplier> multipliers;

    public PlayerData(Player player, AureliumSkills plugin) {
        this.player = player;
        this.plugin = plugin;
        this.skillLevels = new HashMap<Skill, Integer>();
        this.skillXp = new HashMap<Skill, Double>();
        this.statLevels = new HashMap<Stat, Double>();
        this.statModifiers = new HashMap<String, StatModifier>();
        this.abilityData = new HashMap<AbstractAbility, AbilityData>();
        this.metadata = new HashMap<String, Object>();
        this.unclaimedItems = new LinkedList<KeyIntPair>();
        this.saving = false;
        this.shouldSave = true;
        this.mana = OptionL.getDouble(Option.BASE_MANA);
        this.multipliers = new HashMap<String, Multiplier>();
    }

    public Player getPlayer() {
        return this.player;
    }

    public AureliumSkills getPlugin() {
        return this.plugin;
    }

    public int getSkillLevel(Skill skill) {
        return this.skillLevels.getOrDefault(skill, 1);
    }

    public void setSkillLevel(Skill skill, int level) {
        this.skillLevels.put(skill, level);
    }

    public double getSkillXp(Skill skill) {
        return this.skillXp.getOrDefault(skill, 0.0);
    }

    public void setSkillXp(Skill skill, double xp) {
        this.skillXp.put(skill, xp);
    }

    public void addSkillXp(Skill skill, double amount) {
        this.skillXp.merge(skill, amount, Double::sum);
    }

    public double getStatLevel(Stat stat) {
        return this.statLevels.getOrDefault(stat, 0.0);
    }

    public void setStatLevel(Stat stat, double level) {
        this.statLevels.put(stat, level);
    }

    public void addStatLevel(Stat stat, double level) {
        this.statLevels.merge(stat, level, Double::sum);
    }

    public void addStatLevel(Stat stat, int level) {
        Double currentLevel = this.statLevels.get(stat);
        if (currentLevel != null) {
            this.statLevels.put(stat, currentLevel + (double)level);
        } else {
            this.statLevels.put(stat, Double.valueOf(level));
        }
    }

    public StatModifier getStatModifier(String name) {
        return this.statModifiers.get(name);
    }

    public Map<String, StatModifier> getStatModifiers() {
        return this.statModifiers;
    }

    public void addStatModifier(StatModifier modifier) {
        this.addStatModifier(modifier, true);
    }

    public void addStatModifier(StatModifier modifier, boolean reload) {
        if (this.statModifiers.containsKey(modifier.getName())) {
            StatModifier oldModifier = this.statModifiers.get(modifier.getName());
            if (oldModifier.getStat() == modifier.getStat() && oldModifier.getValue() == modifier.getValue()) {
                return;
            }
            this.removeStatModifier(modifier.getName());
        }
        this.statModifiers.put(modifier.getName(), modifier);
        this.setStatLevel(modifier.getStat(), this.getStatLevel(modifier.getStat()) + modifier.getValue());
        if (reload) {
            if (modifier.getStat() == Stats.HEALTH) {
                this.plugin.getHealth().reload(this.player);
            } else if (modifier.getStat() == Stats.LUCK) {
                new Luck(this.plugin).reload(this.player);
            }
        }
    }

    public boolean removeStatModifier(String name) {
        return this.removeStatModifier(name, true);
    }

    public boolean removeStatModifier(String name, boolean reload) {
        StatModifier modifier = this.statModifiers.get(name);
        if (modifier == null) {
            return false;
        }
        this.setStatLevel(modifier.getStat(), this.statLevels.get(modifier.getStat()) - modifier.getValue());
        this.statModifiers.remove(name);
        if (reload) {
            if (modifier.getStat() == Stats.HEALTH) {
                this.plugin.getHealth().reload(this.player);
            } else if (modifier.getStat() == Stats.LUCK) {
                new Luck(this.plugin).reload(this.player);
            }
        }
        return true;
    }

    public double getMana() {
        return this.mana;
    }

    public double getMaxMana() {
        return OptionL.getDouble(Option.BASE_MANA) + OptionL.getDouble(Option.WISDOM_MAX_MANA_PER_WISDOM) * this.getStatLevel(Stats.WISDOM);
    }

    public double getManaRegen() {
        return OptionL.getDouble(Option.REGENERATION_BASE_MANA_REGEN) + this.getStatLevel(Stats.REGENERATION) * OptionL.getDouble(Option.REGENERATION_MANA_MODIFIER);
    }

    public void setMana(double mana) {
        this.mana = mana;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Lang.getDefaultLanguage();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public AbilityData getAbilityData(AbstractAbility ability) {
        AbilityData data = this.abilityData.get(ability);
        if (data == null) {
            data = new AbilityData(ability);
            this.abilityData.put(ability, data);
        }
        return data;
    }

    public boolean containsAbilityData(AbstractAbility ability) {
        return this.abilityData.containsKey(ability);
    }

    public Map<AbstractAbility, AbilityData> getAbilityDataMap() {
        return this.abilityData;
    }

    public int getAbilityLevel(Ability ability) {
        Skill skill = ability.getSkill();
        RewardTable rewardTable = this.plugin.getRewardManager().getRewardTable(skill);
        if (this.getSkillLevel(ability.getSkill()) < this.plugin.getAbilityManager().getUnlock(ability)) {
            return 0;
        }
        int level = (this.getSkillLevel(ability.getSkill()) - this.plugin.getAbilityManager().getUnlock(ability)) / this.plugin.getAbilityManager().getLevelUp(ability) + 1;
        if (level <= this.plugin.getAbilityManager().getMaxLevel(ability) || this.plugin.getAbilityManager().getMaxLevel(ability) == 0) {
            return level;
        }
        return this.plugin.getAbilityManager().getMaxLevel(ability);
    }

    public int getManaAbilityLevel(MAbility mAbility) {
        if (this.getSkillLevel(mAbility.getSkill()) < this.plugin.getManaAbilityManager().getUnlock(mAbility)) {
            return 0;
        }
        int level = (this.getSkillLevel(mAbility.getSkill()) - this.plugin.getManaAbilityManager().getUnlock(mAbility)) / this.plugin.getManaAbilityManager().getLevelUp(mAbility) + 1;
        if (level <= this.plugin.getManaAbilityManager().getMaxLevel(mAbility) || this.plugin.getManaAbilityManager().getMaxLevel(mAbility) == 0) {
            return level;
        }
        return this.plugin.getManaAbilityManager().getMaxLevel(mAbility);
    }

    public int getPowerLevel() {
        int power = 0;
        for (int level : this.skillLevels.values()) {
            power += level;
        }
        return power;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<KeyIntPair> getUnclaimedItems() {
        return this.unclaimedItems;
    }

    public void clearInvalidItems() {
        ArrayList<KeyIntPair> toRemove = new ArrayList<KeyIntPair>();
        for (KeyIntPair unclaimedItem : this.unclaimedItems) {
            if (this.plugin.getItemRegistry().getItem(unclaimedItem.getKey()) != null) continue;
            toRemove.add(unclaimedItem);
        }
        for (KeyIntPair unclaimedItemToRemove : toRemove) {
            this.unclaimedItems.remove(unclaimedItemToRemove);
        }
    }

    public void setUnclaimedItems(@NotNull List<KeyIntPair> unclaimedItems) {
        this.unclaimedItems = unclaimedItems;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean shouldNotSave() {
        return !this.shouldSave;
    }

    public void setShouldSave(boolean shouldSave) {
        this.shouldSave = shouldSave;
    }

    public double getTotalMultiplier(@Nullable Skill skill) {
        double totalMultiplier = 0.0;
        for (Multiplier multiplier : this.getMultipliers().values()) {
            if (multiplier.isGlobal()) {
                totalMultiplier += multiplier.getValue();
                continue;
            }
            if (multiplier.getSkill() == null || !multiplier.getSkill().equals(skill)) continue;
            totalMultiplier += multiplier.getValue();
        }
        return totalMultiplier;
    }

    public Map<String, Multiplier> getMultipliers() {
        return this.multipliers;
    }

    public void addMultiplier(Multiplier multiplier) {
        this.multipliers.put(multiplier.getName(), multiplier);
    }

    public void removeMultiplier(String name) {
        this.multipliers.remove(name);
    }
}

