/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.configuration;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionType;
import com.archyx.aureliumskills.configuration.OptionValue;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.mechanics.DamageType;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class OptionL {
    private final AureliumSkills plugin;
    private static final Map<Option, OptionValue> options = new HashMap<Option, OptionValue>();

    public OptionL(AureliumSkills plugin) {
        this.plugin = plugin;
    }

    public void loadOptions() {
        Logger logger = this.plugin.getLogger();
        this.loadDefaultOptions();
        FileConfiguration config = this.plugin.getConfig();
        int loaded = 0;
        long start = System.currentTimeMillis();
        for (Option option : Option.values()) {
            Object value = config.get(option.getPath());
            if (value != null) {
                if ((value instanceof Integer || value instanceof Double) && option.getType() == OptionType.INT) {
                    options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if ((value instanceof Double || value instanceof Integer) && option.getType() == OptionType.DOUBLE) {
                    options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if (value instanceof Boolean && option.getType() == OptionType.BOOLEAN) {
                    options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if ((value instanceof String || value instanceof Integer || value instanceof Double || value instanceof Boolean) && option.getType() == OptionType.STRING) {
                    options.put(option, new OptionValue(String.valueOf(value)));
                    ++loaded;
                    continue;
                }
                if (value instanceof List && option.getType() == OptionType.LIST) {
                    options.put(option, new OptionValue(value));
                    ++loaded;
                    continue;
                }
                if (value instanceof String && option.getType() == OptionType.COLOR) {
                    options.put(option, new OptionValue(ChatColor.valueOf((String)String.valueOf(value))));
                    ++loaded;
                    continue;
                }
                logger.warning("Incorrect type in config.yml: Option " + option.name() + " with path " + option.getPath() + " should be of type " + option.getType().name() + ", using default value instead!");
                continue;
            }
            logger.warning("Missing value in config.yml: Option " + option.name() + " with path " + option.getPath() + " was not found, using default value instead!");
        }
        this.plugin.getHealth().loadHearts(config);
        long end = System.currentTimeMillis();
        logger.info("Loaded " + loaded + " config options in " + (end - start) + " ms");
    }

    private void loadDefaultOptions() {
        InputStream inputStream = this.plugin.getResource("config.yml");
        if (inputStream != null) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
            for (Option option : Option.values()) {
                if (option.getType() == OptionType.INT) {
                    options.put(option, new OptionValue(config.getInt(option.getPath())));
                    continue;
                }
                if (option.getType() == OptionType.DOUBLE) {
                    options.put(option, new OptionValue(config.getDouble(option.getPath())));
                    continue;
                }
                if (option.getType() != OptionType.BOOLEAN) continue;
                options.put(option, new OptionValue(config.getBoolean(option.getPath())));
            }
        }
    }

    public static double getDouble(Option option) {
        return options.get((Object)option).asDouble();
    }

    public static int getInt(Option option) {
        return options.get((Object)option).asInt();
    }

    public static boolean getBoolean(Option option) {
        return options.get((Object)option).asBoolean();
    }

    public static String getString(Option option) {
        return options.get((Object)option).asString();
    }

    public static List<String> getList(Option option) {
        return options.get((Object)option).asList();
    }

    public static ChatColor getColor(Option option) {
        return options.get((Object)option).asColor();
    }

    public static boolean isEnabled(Skill skill) {
        return OptionL.getBoolean(Option.valueOf(skill.name() + "_ENABLED"));
    }

    public static int getMaxLevel(Skill skill) {
        return OptionL.getInt(Option.valueOf(skill.name() + "_MAX_LEVEL"));
    }

    public int getHighestMaxLevel() {
        int highest = 96;
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            int maxLevel = OptionL.getInt(Option.valueOf(skill.name() + "_MAX_LEVEL"));
            if (maxLevel <= highest) continue;
            highest = maxLevel;
        }
        return highest;
    }

    public static boolean criticalEnabled(DamageType type) {
        return OptionL.getBoolean(Option.valueOf("CRITICAL_ENABLED_" + type.name()));
    }
}

