/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.commands;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.acf.BaseCommand;
import com.archyx.aureliumskills.acf.CommandHelp;
import com.archyx.aureliumskills.acf.InvalidCommandArgument;
import com.archyx.aureliumskills.acf.annotation.CommandAlias;
import com.archyx.aureliumskills.acf.annotation.CommandCompletion;
import com.archyx.aureliumskills.acf.annotation.CommandPermission;
import com.archyx.aureliumskills.acf.annotation.Default;
import com.archyx.aureliumskills.acf.annotation.Description;
import com.archyx.aureliumskills.acf.annotation.Flags;
import com.archyx.aureliumskills.acf.annotation.Optional;
import com.archyx.aureliumskills.acf.annotation.Subcommand;
import com.archyx.aureliumskills.acf.annotation.Syntax;
import com.archyx.aureliumskills.commands.ReloadManager;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.backup.BackupProvider;
import com.archyx.aureliumskills.data.storage.StorageProvider;
import com.archyx.aureliumskills.inv.SmartInventory;
import com.archyx.aureliumskills.item.UnclaimedItemsMenu;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.lang.LevelerMessage;
import com.archyx.aureliumskills.leaderboard.SkillValue;
import com.archyx.aureliumskills.menu.SkillsMenu;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.Modifiers;
import com.archyx.aureliumskills.modifier.Multiplier;
import com.archyx.aureliumskills.modifier.Multipliers;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.nbtapi.NBTCompoundList;
import com.archyx.aureliumskills.nbtapi.NBTFile;
import com.archyx.aureliumskills.nbtapi.NBTListCompound;
import com.archyx.aureliumskills.requirement.Requirements;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.ui.ActionBar;
import com.archyx.aureliumskills.util.item.ItemUtils;
import com.archyx.aureliumskills.util.math.NumberUtil;
import com.archyx.aureliumskills.util.misc.KeyIntPair;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.archyx.aureliumskills.util.version.UpdateChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;

@CommandAlias(value="skills|sk|skill")
public class SkillsCommand
extends BaseCommand {
    private final AureliumSkills plugin;
    private final ReloadManager reloadManager;

    public SkillsCommand(AureliumSkills plugin) {
        this.plugin = plugin;
        this.reloadManager = new ReloadManager(plugin);
    }

    @Default
    @CommandPermission(value="aureliumskills.skills")
    @Description(value="Opens the Skills menu, where you can browse skills, progress, and abilities.")
    public void onSkills(Player player) {
        SmartInventory inventory = SkillsMenu.getInventory(player, this.plugin);
        if (inventory != null) {
            inventory.open(player);
        } else {
            player.sendMessage(Lang.getMessage(CommandMessage.NO_PROFILE, Lang.getDefaultLanguage()));
        }
    }

    @Subcommand(value="xp add")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="aureliumskills.xp.add")
    @Description(value="Adds skill XP to a player for a certain skill.")
    public void onXpAdd(CommandSender sender, @Flags(value="other") Player player, Skill skill, double amount, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLang().getLocale(player);
        if (OptionL.isEnabled(skill)) {
            this.plugin.getLeveler().addXp(player, skill, amount);
            if (!silent) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.XP_ADD, locale).replace("{amount}", String.valueOf(amount)).replace("{skill}", skill.getDisplayName(locale)).replace("{player}", player.getName()));
            }
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + ChatColor.YELLOW + Lang.getMessage(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="xp set")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="aureliumskills.xp.set")
    @Description(value="Sets a player's skill XP for a certain skill to an amount.")
    public void onXpSet(CommandSender sender, @Flags(value="other") Player player, Skill skill, double amount, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLang().getLocale(player);
        if (OptionL.isEnabled(skill)) {
            this.plugin.getLeveler().setXp(player, skill, amount);
            if (!silent) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.XP_SET, locale).replace("{amount}", String.valueOf(amount)).replace("{skill}", skill.getDisplayName(locale)).replace("{player}", player.getName()));
            }
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + ChatColor.YELLOW + Lang.getMessage(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="xp remove")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="aureliumskills.xp.remove")
    @Description(value="Removes skill XP from a player in a certain skill.")
    public void onXpRemove(CommandSender sender, @Flags(value="other") Player player, Skill skill, double amount, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLang().getLocale(player);
        if (OptionL.isEnabled(skill)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            if (playerData.getSkillXp(skill) - amount >= 0.0) {
                this.plugin.getLeveler().setXp(player, skill, playerData.getSkillXp(skill) - amount);
                if (!silent) {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.XP_REMOVE, locale).replace("{amount}", String.valueOf(amount)).replace("{skill}", skill.getDisplayName(locale)).replace("{player}", player.getName()));
                }
            } else {
                if (!silent) {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.XP_REMOVE, locale).replace("{amount}", String.valueOf(playerData.getSkillXp(skill))).replace("{skill}", skill.getDisplayName(locale)).replace("{player}", player.getName()));
                }
                this.plugin.getLeveler().setXp(player, skill, 0.0);
            }
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + ChatColor.YELLOW + Lang.getMessage(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="top")
    @CommandAlias(value="skilltop")
    @CommandCompletion(value="@skillTop")
    @CommandPermission(value="aureliumskills.top")
    @Description(value="Shows the top players in a skill")
    @Syntax(value="Usage: /sk top <page> or /sk top [skill] <page>")
    public void onTop(CommandSender sender, String[] args) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (args.length == 0) {
            List<SkillValue> lb = this.plugin.getLeaderboardManager().getPowerLeaderboard(1, 10);
            sender.sendMessage(Lang.getMessage(CommandMessage.TOP_POWER_HEADER, locale));
            for (SkillValue skillValue : lb) {
                String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                sender.sendMessage(Lang.getMessage(CommandMessage.TOP_POWER_ENTRY, locale).replace("{rank}", String.valueOf(lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.getLevel())));
            }
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("average")) {
                List<SkillValue> lb = this.plugin.getLeaderboardManager().getAverageLeaderboard(1, 10);
                sender.sendMessage(Lang.getMessage(CommandMessage.TOP_AVERAGE_HEADER, locale));
                this.sendLeaderboardEntries(sender, locale, lb);
            } else {
                try {
                    int page = Integer.parseInt(args[0]);
                    List<SkillValue> lb = this.plugin.getLeaderboardManager().getPowerLeaderboard(page, 10);
                    sender.sendMessage(Lang.getMessage(CommandMessage.TOP_POWER_HEADER_PAGE, locale).replace("{page}", String.valueOf(page)));
                    for (SkillValue skillValue : lb) {
                        String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                        sender.sendMessage(Lang.getMessage(CommandMessage.TOP_POWER_ENTRY, locale).replace("{rank}", String.valueOf((page - 1) * 10 + lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.getLevel())));
                    }
                }
                catch (Exception e) {
                    Skill skill = this.plugin.getSkillRegistry().getSkill(args[0]);
                    if (skill != null) {
                        List<SkillValue> lb = this.plugin.getLeaderboardManager().getLeaderboard(skill, 1, 10);
                        sender.sendMessage(Lang.getMessage(CommandMessage.TOP_SKILL_HEADER, locale).replace("{skill}", skill.getDisplayName(locale)));
                        for (SkillValue skillValue : lb) {
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                            sender.sendMessage(Lang.getMessage(CommandMessage.TOP_SKILL_ENTRY, locale).replace("{rank}", String.valueOf(lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.getLevel())));
                        }
                    }
                    sender.sendMessage(Lang.getMessage(CommandMessage.TOP_USAGE, locale));
                }
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("average")) {
                try {
                    int page = Integer.parseInt(args[1]);
                    List<SkillValue> lb = this.plugin.getLeaderboardManager().getAverageLeaderboard(page, 10);
                    sender.sendMessage(TextUtil.replace(Lang.getMessage(CommandMessage.TOP_AVERAGE_HEADER_PAGE, locale), "{page}", String.valueOf(page)));
                    this.sendLeaderboardEntries(sender, locale, lb);
                }
                catch (Exception e) {
                    sender.sendMessage(Lang.getMessage(CommandMessage.TOP_USAGE, locale));
                }
            } else {
                Skill skill = this.plugin.getSkillRegistry().getSkill(args[0]);
                if (skill != null) {
                    try {
                        int page = Integer.parseInt(args[1]);
                        List<SkillValue> lb = this.plugin.getLeaderboardManager().getLeaderboard(skill, page, 10);
                        sender.sendMessage(Lang.getMessage(CommandMessage.TOP_SKILL_HEADER_PAGE, locale).replace("{page}", String.valueOf(page)).replace("{skill}", skill.getDisplayName(locale)));
                        for (SkillValue skillValue : lb) {
                            String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
                            sender.sendMessage(Lang.getMessage(CommandMessage.TOP_SKILL_ENTRY, locale).replace("{rank}", String.valueOf((page - 1) * 10 + lb.indexOf(skillValue) + 1)).replace("{player}", name != null ? name : "?").replace("{level}", String.valueOf(skillValue.getLevel())));
                        }
                    }
                    catch (Exception e) {
                        sender.sendMessage(Lang.getMessage(CommandMessage.TOP_USAGE, locale));
                    }
                } else {
                    sender.sendMessage(Lang.getMessage(CommandMessage.TOP_USAGE, locale));
                }
            }
        }
    }

    private void sendLeaderboardEntries(CommandSender sender, Locale locale, List<SkillValue> lb) {
        for (SkillValue skillValue : lb) {
            String name = Bukkit.getOfflinePlayer((UUID)skillValue.getId()).getName();
            sender.sendMessage(TextUtil.replace(Lang.getMessage(CommandMessage.TOP_AVERAGE_ENTRY, locale), "{rank}", String.valueOf(lb.indexOf(skillValue) + 1), "{player}", name != null ? name : "?", "{level}", NumberUtil.format2(skillValue.getXp())));
        }
    }

    @Subcommand(value="save")
    @CommandPermission(value="aureliumskills.save")
    @Description(value="Saves skill data")
    public void onSave(final CommandSender sender) {
        new BukkitRunnable(){

            public void run() {
                final Locale locale = SkillsCommand.this.plugin.getLang().getLocale(sender);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SkillsCommand.this.plugin.getStorageProvider().save(player, false);
                }
                new BukkitRunnable(){

                    public void run() {
                        sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SAVE_SAVED, locale));
                    }
                }.runTask((Plugin)SkillsCommand.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    @Subcommand(value="updateleaderboards")
    @CommandPermission(value="aureliumskills.updateleaderboards")
    @Description(value="Updates and sorts the leaderboards")
    public void onUpdateLeaderboards(final CommandSender sender) {
        final Locale locale = this.plugin.getLang().getLocale(sender);
        if (this.plugin.getLeaderboardManager().isNotSorting()) {
            new BukkitRunnable(){

                public void run() {
                    SkillsCommand.this.plugin.getStorageProvider().updateLeaderboards();
                    new BukkitRunnable(){

                        public void run() {
                            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.UPDATELEADERBOARDS_UPDATED, locale));
                        }
                    }.runTask((Plugin)SkillsCommand.this.plugin);
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.UPDATELEADERBOARDS_ALREADY_UPDATING, locale));
        }
    }

    @Subcommand(value="toggle")
    @CommandAlias(value="abtoggle")
    @CommandPermission(value="aureliumskills.abtoggle")
    @Description(value="Toggle your own action bar")
    public void onActionBarToggle(Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ActionBar actionBar = this.plugin.getActionBar();
        if (OptionL.getBoolean(Option.ACTION_BAR_ENABLED)) {
            if (actionBar.getActionBarDisabled().contains(player.getUniqueId())) {
                actionBar.getActionBarDisabled().remove(player.getUniqueId());
                player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.TOGGLE_ENABLED, locale));
            } else {
                actionBar.getActionBarDisabled().add(player.getUniqueId());
                player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.TOGGLE_DISABLED, locale));
            }
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.TOGGLE_NOT_ENABLED, locale));
        }
    }

    @Subcommand(value="rank")
    @CommandAlias(value="skillrank")
    @CommandPermission(value="aureliumskills.rank")
    @Description(value="Shows your skill rankings")
    public void onRank(Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        player.sendMessage(Lang.getMessage(CommandMessage.RANK_HEADER, locale));
        player.sendMessage(Lang.getMessage(CommandMessage.RANK_POWER, locale).replace("{rank}", String.valueOf(this.plugin.getLeaderboardManager().getPowerRank(player.getUniqueId()))).replace("{total}", String.valueOf(this.plugin.getLeaderboardManager().getPowerLeaderboard().size())));
        for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
            if (!OptionL.isEnabled(skill)) continue;
            player.sendMessage(Lang.getMessage(CommandMessage.RANK_ENTRY, locale).replace("{skill}", String.valueOf(skill.getDisplayName(locale))).replace("{rank}", String.valueOf(this.plugin.getLeaderboardManager().getSkillRank(skill, player.getUniqueId()))).replace("{total}", String.valueOf(this.plugin.getLeaderboardManager().getLeaderboard(skill).size())));
        }
    }

    @Subcommand(value="lang")
    @CommandCompletion(value="@lang")
    @CommandPermission(value="aureliumskills.lang")
    @Description(value="Changes your player language")
    public void onLanguage(Player player, String language) {
        Locale locale = new Locale(language.toLowerCase(Locale.ENGLISH));
        if (Lang.hasLocale(locale)) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            playerData.setLocale(locale);
            this.plugin.getCommandManager().setPlayerLocale(player, locale);
            player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.LANG_SET, locale).replace("{lang}", Lang.getDefinedLanguages().get(locale)));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.LANG_NOT_FOUND, this.plugin.getLang().getLocale(player)));
        }
    }

    @Subcommand(value="reload")
    @CommandPermission(value="aureliumskills.reload")
    @Description(value="Reloads the config, messages, menus, loot tables, action bars, boss bars, and health and luck stats.")
    public void reload(CommandSender sender) {
        this.reloadManager.reload(sender);
    }

    @Subcommand(value="skill setlevel")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="aureliumskills.skill.setlevel")
    @Description(value="Sets a specific skill to a level for a player.")
    public void onSkillSetlevel(CommandSender sender, @Flags(value="other") Player player, Skill skill, int level) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (OptionL.isEnabled(skill)) {
            if (level > 0) {
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                int oldLevel = playerData.getSkillLevel(skill);
                playerData.setSkillLevel(skill, level);
                playerData.setSkillXp(skill, 0.0);
                this.plugin.getLeveler().updateStats(player);
                this.plugin.getLeveler().updatePermissions(player);
                this.plugin.getLeveler().applyRevertCommands(player, skill, oldLevel, level);
                this.plugin.getLeveler().applyLevelUpCommands(player, skill, oldLevel, level);
                this.plugin.getModifierManager().reloadPlayer(player);
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SKILL_SETLEVEL_SET, locale).replace("{skill}", skill.getDisplayName(locale)).replace("{level}", String.valueOf(level)).replace("{player}", player.getName()));
            } else {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SKILL_SETLEVEL_AT_LEAST_ONE, locale));
            }
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="skill setall")
    @CommandCompletion(value="@players")
    @CommandPermission(value="aureliumskills.skill.setlevel")
    @Description(value="Sets all of a player's skills to a level.")
    public void onSkillSetall(CommandSender sender, @Flags(value="other") Player player, int level) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (level > 0) {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
                if (!OptionL.isEnabled(skill)) continue;
                int oldLevel = playerData.getSkillLevel(skill);
                playerData.setSkillLevel(skill, level);
                playerData.setSkillXp(skill, 0.0);
                this.plugin.getModifierManager().reloadPlayer(player);
                this.plugin.getLeveler().applyRevertCommands(player, skill, oldLevel, level);
                this.plugin.getLeveler().applyLevelUpCommands(player, skill, oldLevel, level);
            }
            this.plugin.getLeveler().updateStats(player);
            this.plugin.getLeveler().updatePermissions(player);
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SKILL_SETALL_SET, locale).replace("{level}", String.valueOf(level)).replace("{player}", player.getName()));
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SKILL_SETALL_AT_LEAST_ONE, locale));
        }
    }

    @Subcommand(value="skill reset")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="aureliumskills.skill.reset")
    @Description(value="Resets all skills or a specific skill to level 1 for a player.")
    public void onSkillReset(CommandSender sender, @Flags(value="other") Player player, @Optional Skill skill) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (skill != null) {
            if (OptionL.isEnabled(skill)) {
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
                if (playerData == null) {
                    return;
                }
                this.resetPlayerSkills(player, playerData, skill);
                this.plugin.getModifierManager().reloadPlayer(player);
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SKILL_RESET_RESET_SKILL, locale).replace("{skill}", skill.getDisplayName(locale)).replace("{player}", player.getName()));
            } else {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.UNKNOWN_SKILL, locale));
            }
        } else {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            for (Skill s : this.plugin.getSkillRegistry().getSkills()) {
                this.resetPlayerSkills(player, playerData, s);
            }
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.SKILL_RESET_RESET_ALL, locale).replace("{player}", player.getName()));
        }
    }

    private void resetPlayerSkills(@Flags(value="other") Player player, PlayerData playerData, Skill skill) {
        int oldLevel = playerData.getSkillLevel(skill);
        playerData.setSkillLevel(skill, 1);
        playerData.setSkillXp(skill, 0.0);
        this.plugin.getLeveler().updateStats(player);
        this.plugin.getLeveler().updatePermissions(player);
        this.plugin.getLeveler().applyRevertCommands(player, skill, oldLevel, 1);
    }

    @Subcommand(value="modifier add")
    @CommandPermission(value="aureliumskills.modifier.add")
    @CommandCompletion(value="@players @stats @nothing @nothing true")
    @Description(value="Adds a stat modifier to a player.")
    public void onAdd(CommandSender sender, @Flags(value="other") Player player, Stat stat, String name, double value, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            StatModifier modifier = new StatModifier(name, stat, value);
            if (!playerData.getStatModifiers().containsKey(name)) {
                playerData.addStatModifier(modifier);
                if (!silent) {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_ADD_ADDED, locale), modifier, player, locale));
                }
            } else if (!silent) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_ADD_ALREADY_EXISTS, locale), modifier, player, locale));
            }
        } else if (!silent) {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.NO_PROFILE, locale));
        }
    }

    @Subcommand(value="modifier remove")
    @CommandPermission(value="aureliumskills.modifier.remove")
    @CommandCompletion(value="@players @modifiers true")
    @Description(value="Removes a specific stat modifier from a player.")
    public void onRemove(CommandSender sender, @Flags(value="other") Player player, String name, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            if (playerData.removeStatModifier(name)) {
                if (!silent) {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_REMOVE_REMOVED, locale), name, player));
                }
            } else if (!silent) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_REMOVE_NOT_FOUND, locale), name, player));
            }
        } else if (!silent) {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.NO_PROFILE, locale));
        }
    }

    @Subcommand(value="modifier list")
    @CommandCompletion(value="@players @stats")
    @CommandPermission(value="aureliumskills.modifier.list")
    @Description(value="Lists all or a specific stat's modifiers for a player.")
    public void onList(CommandSender sender, @Flags(value="other") @Optional Player player, @Optional Stat stat) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (player == null) {
            if (sender instanceof Player) {
                Player target = (Player)sender;
                this.listModifiers(sender, target, stat, locale);
            } else {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.MODIFIER_LIST_PLAYERS_ONLY, locale));
            }
        } else {
            this.listModifiers(sender, player, stat, locale);
        }
    }

    private void listModifiers(CommandSender sender, @Optional @Flags(value="other") Player player, @Optional Stat stat, Locale locale) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            StringBuilder message;
            if (stat == null) {
                message = new StringBuilder(StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_LIST_ALL_STATS_HEADER, locale), player));
                for (String key : playerData.getStatModifiers().keySet()) {
                    StatModifier modifier = playerData.getStatModifiers().get(key);
                    message.append("\n").append(StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_LIST_ALL_STATS_ENTRY, locale), modifier, player, locale));
                }
            } else {
                message = new StringBuilder(StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_LIST_ONE_STAT_HEADER, locale), stat, player, locale));
                for (String key : playerData.getStatModifiers().keySet()) {
                    StatModifier modifier = playerData.getStatModifiers().get(key);
                    if (modifier.getStat() != stat) continue;
                    message.append("\n").append(StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_LIST_ONE_STAT_ENTRY, locale), modifier, player, locale));
                }
            }
            sender.sendMessage(message.toString());
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.NO_PROFILE, locale));
        }
    }

    @Subcommand(value="modifier removeall")
    @CommandCompletion(value="@players @stats")
    @CommandPermission(value="aureliumskills.modifier.removeall")
    @Description(value="Removes all stat modifiers from a player.")
    public void onRemoveAll(CommandSender sender, @Flags(value="other") @Optional Player player, @Optional Stat stat, @Default(value="false") boolean silent) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (player == null) {
            if (sender instanceof Player) {
                Player target = (Player)sender;
                PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(target);
                this.removeAllModifiers(sender, stat, silent, locale, target, playerData);
            } else if (!silent) {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.MODIFIER_REMOVEALL_PLAYERS_ONLY, locale));
            }
        } else {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            this.removeAllModifiers(sender, stat, silent, locale, player, playerData);
        }
    }

    private void removeAllModifiers(CommandSender sender, @Optional Stat stat, @Default(value="false") boolean silent, Locale locale, Player target, PlayerData playerData) {
        if (playerData != null) {
            int removed = 0;
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : playerData.getStatModifiers().keySet()) {
                if (stat == null) {
                    toRemove.add(key);
                    ++removed;
                    continue;
                }
                if (playerData.getStatModifiers().get(key).getStat() != stat) continue;
                toRemove.add(key);
                ++removed;
            }
            for (String key : toRemove) {
                playerData.removeStatModifier(key);
            }
            if (!silent) {
                if (stat == null) {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_REMOVEALL_REMOVED_ALL_STATS, locale), target).replace("{num}", String.valueOf(removed)));
                } else {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.MODIFIER_REMOVEALL_REMOVED_ONE_STAT, locale), stat, target, locale).replace("{num}", String.valueOf(removed)));
                }
            }
        } else if (!silent) {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.NO_PROFILE, locale));
        }
    }

    @Subcommand(value="item modifier add")
    @CommandCompletion(value="@stats @nothing false|true")
    @CommandPermission(value="aureliumskills.item.modifier.add")
    @Description(value="Adds an item stat modifier to the item held, along with lore by default.")
    public void onItemModifierAdd(@Flags(value="itemheld") Player player, Stat stat, double value, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        Modifiers modifiers = new Modifiers(this.plugin);
        for (StatModifier statModifier : modifiers.getModifiers(ModifierType.ITEM, item)) {
            if (statModifier.getStat() != stat) continue;
            player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ITEM_MODIFIER_ADD_ALREADY_EXISTS, locale), stat, locale));
            return;
        }
        if (lore) {
            modifiers.addLore(ModifierType.ITEM, item, stat, value, locale);
        }
        ItemStack newItem = modifiers.addModifier(ModifierType.ITEM, item, stat, value);
        player.getInventory().setItemInMainHand(newItem);
        player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ITEM_MODIFIER_ADD_ADDED, locale), stat, value, locale));
    }

    @Subcommand(value="item modifier remove")
    @CommandCompletion(value="@stats false|true")
    @CommandPermission(value="aureliumskills.item.modifier.remove")
    @Description(value="Removes an item stat modifier from the item held, and the lore associated with it by default.")
    public void onItemModifierRemove(@Flags(value="itemheld") Player player, Stat stat, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean removed = false;
        Modifiers modifiers = new Modifiers(this.plugin);
        for (StatModifier modifier : modifiers.getModifiers(ModifierType.ITEM, item)) {
            if (modifier.getStat() != stat) continue;
            item = modifiers.removeModifier(ModifierType.ITEM, item, stat);
            removed = true;
            break;
        }
        if (lore) {
            modifiers.removeLore(item, stat, locale);
        }
        player.getInventory().setItemInMainHand(item);
        if (removed) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ITEM_MODIFIER_REMOVE_REMOVED, locale), stat, locale));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ITEM_MODIFIER_REMOVE_DOES_NOT_EXIST, locale), stat, locale));
        }
    }

    @Subcommand(value="item modifier list")
    @CommandPermission(value="aureliumskills.item.modifier.list")
    @Description(value="Lists all item stat modifiers on the item held.")
    public void onItemModifierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(Lang.getMessage(CommandMessage.ITEM_MODIFIER_LIST_HEADER, locale));
        Modifiers modifiers = new Modifiers(this.plugin);
        for (StatModifier modifier : modifiers.getModifiers(ModifierType.ITEM, item)) {
            message.append("\n").append(StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ITEM_MODIFIER_LIST_ENTRY, locale), modifier, locale));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="item modifier removeall")
    @CommandPermission(value="aureliumskills.item.modifier.removall")
    @Description(value="Removes all item stat modifiers from the item held.")
    public void onItemModifierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Modifiers modifiers = new Modifiers(this.plugin);
        ItemStack item = modifiers.removeAllModifiers(ModifierType.ITEM, player.getInventory().getItemInMainHand());
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ITEM_MODIFIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="armor modifier add")
    @CommandCompletion(value="@stats @nothing false|true")
    @CommandPermission(value="aureliumskills.armor.modifier.add")
    @Description(value="Adds an armor stat modifier to the item held, along with lore by default.")
    public void onArmorModifierAdd(@Flags(value="itemheld") Player player, Stat stat, int value, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        Modifiers modifiers = new Modifiers(this.plugin);
        for (StatModifier statModifier : modifiers.getModifiers(ModifierType.ARMOR, item)) {
            if (statModifier.getStat() != stat) continue;
            player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ARMOR_MODIFIER_ADD_ALREADY_EXISTS, locale), stat, locale));
            return;
        }
        if (lore) {
            modifiers.addLore(ModifierType.ARMOR, item, stat, value, locale);
        }
        ItemStack newItem = modifiers.addModifier(ModifierType.ARMOR, item, stat, value);
        player.getInventory().setItemInMainHand(newItem);
        player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ARMOR_MODIFIER_ADD_ADDED, locale), stat, value, locale));
    }

    @Subcommand(value="armor modifier remove")
    @CommandCompletion(value="@stats false|true")
    @CommandPermission(value="aureliumskills.armor.modifier.remove")
    @Description(value="Removes an armor stat modifier from the item held, and the lore associated with it by default.")
    public void onArmorModifierRemove(@Flags(value="itemheld") Player player, Stat stat, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean removed = false;
        Modifiers modifiers = new Modifiers(this.plugin);
        for (StatModifier modifier : modifiers.getModifiers(ModifierType.ARMOR, item)) {
            if (modifier.getStat() != stat) continue;
            item = modifiers.removeModifier(ModifierType.ARMOR, item, stat);
            removed = true;
            break;
        }
        if (lore) {
            modifiers.removeLore(item, stat, locale);
        }
        player.getInventory().setItemInMainHand(item);
        if (removed) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ARMOR_MODIFIER_REMOVE_REMOVED, locale), stat, locale));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ARMOR_MODIFIER_REMOVE_DOES_NOT_EXIST, locale), stat, locale));
        }
    }

    @Subcommand(value="armor modifier list")
    @CommandPermission(value="aureliumskills.armor.modifier.list")
    @Description(value="Lists all armor stat modifiers on the item held.")
    public void onArmorModifierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(Lang.getMessage(CommandMessage.ARMOR_MODIFIER_LIST_HEADER, locale));
        Modifiers modifiers = new Modifiers(this.plugin);
        for (StatModifier modifier : modifiers.getModifiers(ModifierType.ARMOR, item)) {
            message.append("\n").append(StatModifier.applyPlaceholders(Lang.getMessage(CommandMessage.ARMOR_MODIFIER_LIST_ENTRY, locale), modifier, locale));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="armor modifier removeall")
    @CommandPermission(value="aureliumskills.armor.modifier.removeall")
    @Description(value="Removes all armor stat modifiers from the item held.")
    public void onArmorModifierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Modifiers modifiers = new Modifiers(this.plugin);
        ItemStack item = modifiers.removeAllModifiers(ModifierType.ARMOR, player.getInventory().getItemInMainHand());
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ARMOR_MODIFIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="item requirement add")
    @CommandPermission(value="aureliumskills.item.requirement.add")
    @CommandCompletion(value="@skills @nothing false|true")
    @Description(value="Adds an item requirement to the item held, along with lore by default.")
    public void onItemRequirementAdd(@Flags(value="itemheld") Player player, Skill skill, int level, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Requirements requirements = new Requirements(this.plugin);
        ItemStack item = player.getInventory().getItemInMainHand();
        if (requirements.hasRequirement(ModifierType.ITEM, item, skill)) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_ADD_ALREADY_EXISTS, locale), "{skill}", skill.getDisplayName(locale)));
            return;
        }
        item = requirements.addRequirement(ModifierType.ITEM, item, skill, level);
        if (lore) {
            requirements.addLore(ModifierType.ITEM, item, skill, level, locale);
        }
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_ADD_ADDED, locale), "{skill}", skill.getDisplayName(locale), "{level}", String.valueOf(level)));
    }

    @Subcommand(value="item requirement remove")
    @CommandPermission(value="aureliumskills.item.requirement.remove")
    @CommandCompletion(value="@skills false|true")
    @Description(value="Removes an item requirement from the item held, and the lore associated with it by default.")
    public void onItemRequirementRemove(@Flags(value="itemheld") Player player, Skill skill, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Requirements requirements = new Requirements(this.plugin);
        ItemStack item = player.getInventory().getItemInMainHand();
        if (requirements.hasRequirement(ModifierType.ITEM, item, skill)) {
            item = requirements.removeRequirement(ModifierType.ITEM, item, skill);
            if (lore) {
                requirements.removeLore(item, skill);
            }
            player.getInventory().setItemInMainHand(item);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_REMOVE_REMOVED, locale), "{skill}", skill.getDisplayName(locale)));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_REMOVE_DOES_NOT_EXIST, locale), "{skill}", skill.getDisplayName(locale)));
        }
    }

    @Subcommand(value="item requirement list")
    @CommandPermission(value="aureliumskills.item.requirement.list")
    @Description(value="Lists the item requirements on the item held.")
    public void onItemRequirementList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        player.sendMessage(Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_LIST_HEADER, locale));
        Requirements requirements = new Requirements(this.plugin);
        for (Map.Entry<Skill, Integer> entry : requirements.getRequirements(ModifierType.ITEM, player.getInventory().getItemInMainHand()).entrySet()) {
            player.sendMessage(TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_LIST_ENTRY, locale), "{skill}", entry.getKey().getDisplayName(locale), "{level}", String.valueOf(entry.getValue())));
        }
    }

    @Subcommand(value="item requirement removeall")
    @CommandPermission(value="aureliumskills.item.requirement.removeall")
    @Description(value="Removes all item requirements from the item held.")
    public void onItemRequirementRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Requirements requirements = new Requirements(this.plugin);
        ItemStack item = requirements.removeAllRequirements(ModifierType.ITEM, player.getInventory().getItemInMainHand());
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ITEM_REQUIREMENT_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="armor requirement add")
    @CommandPermission(value="aureliumskills.armor.requirement.add")
    @CommandCompletion(value="@skills @nothing false|true")
    @Description(value="Adds an armor requirement to the item held, along with lore by default")
    public void onArmorRequirementAdd(@Flags(value="itemheld") Player player, Skill skill, int level, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Requirements requirements = new Requirements(this.plugin);
        ItemStack item = player.getInventory().getItemInMainHand();
        if (requirements.hasRequirement(ModifierType.ARMOR, item, skill)) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_ADD_ALREADY_EXISTS, locale), "{skill}", skill.getDisplayName(locale)));
            return;
        }
        item = requirements.addRequirement(ModifierType.ARMOR, item, skill, level);
        if (lore) {
            requirements.addLore(ModifierType.ARMOR, item, skill, level, locale);
        }
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_ADD_ADDED, locale), "{skill}", skill.getDisplayName(locale), "{level}", String.valueOf(level)));
    }

    @Subcommand(value="armor requirement remove")
    @CommandPermission(value="aureliumskills.armor.requirement.remove")
    @CommandCompletion(value="@skills false|true")
    @Description(value="Removes an armor requirement from the item held, along with the lore associated it by default.")
    public void onArmorRequirementRemove(@Flags(value="itemheld") Player player, Skill skill, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Requirements requirements = new Requirements(this.plugin);
        ItemStack item = player.getInventory().getItemInMainHand();
        if (requirements.hasRequirement(ModifierType.ARMOR, item, skill)) {
            item = requirements.removeRequirement(ModifierType.ARMOR, item, skill);
            if (lore) {
                requirements.removeLore(item, skill);
            }
            player.getInventory().setItemInMainHand(item);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_REMOVE_REMOVED, locale), "{skill}", skill.getDisplayName(locale)));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_REMOVE_DOES_NOT_EXIST, locale), "{skill}", skill.getDisplayName(locale)));
        }
    }

    @Subcommand(value="armor requirement list")
    @CommandPermission(value="aureliumskills.armor.requirement.list")
    @Description(value="Lists the armor requirements on the item held.")
    public void onArmorRequirementList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        player.sendMessage(Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_LIST_HEADER, locale));
        Requirements requirements = new Requirements(this.plugin);
        for (Map.Entry<Skill, Integer> entry : requirements.getRequirements(ModifierType.ARMOR, player.getInventory().getItemInMainHand()).entrySet()) {
            player.sendMessage(TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_LIST_ENTRY, locale), "{skill}", entry.getKey().getDisplayName(locale), "{level}", String.valueOf(entry.getValue())));
        }
    }

    @Subcommand(value="armor requirement removeall")
    @CommandPermission(value="aureliumskills.armor.requirement.removeall")
    @Description(value="Removes all armor requirements from the item held.")
    public void onArmorRequirementRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Requirements requirements = new Requirements(this.plugin);
        ItemStack item = requirements.removeAllRequirements(ModifierType.ARMOR, player.getInventory().getItemInMainHand());
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ARMOR_REQUIREMENT_REMOVEALL_REMOVED, locale));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Subcommand(value="multiplier")
    @CommandCompletion(value="@players")
    @CommandPermission(value="aureliumskills.multipliercommand")
    @Description(value="Shows a player's current XP multiplier based on their permissions.")
    public void onMultiplier(CommandSender sender, @Optional @Flags(value="other") Player player) {
        Player target;
        if (player == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(AureliumSkills.getPrefix(Lang.getDefaultLanguage()) + Lang.getMessage(CommandMessage.MULTIPLIER_PLAYERS_ONLY, Lang.getDefaultLanguage()));
                return;
            }
            target = (Player)sender;
        } else {
            target = player;
        }
        Locale locale = this.plugin.getLang().getLocale(target);
        double multiplier = this.plugin.getLeveler().getMultiplier(target);
        sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.MULTIPLIER_LIST, locale), "{player}", target.getName(), "{multiplier}", NumberUtil.format2(multiplier), "{percent}", NumberUtil.format2((multiplier - 1.0) * 100.0)));
        Iterator<Skill> iterator = this.plugin.getSkillRegistry().getSkills().iterator();
        while (iterator.hasNext()) {
            Skill skill = iterator.next();
            double skillMultiplier = this.plugin.getLeveler().getMultiplier(target, skill);
            if (skillMultiplier == multiplier) continue;
            sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.MULTIPLIER_SKILL_ENTRY, locale), "{skill}", skill.getDisplayName(locale), "{multiplier}", NumberUtil.format2(skillMultiplier), "{percent}", NumberUtil.format2((skillMultiplier - 1.0) * 100.0)));
        }
        return;
    }

    @Subcommand(value="resethealth")
    @CommandPermission(value="aureliumskills.*")
    @Description(value="Removes all attribute modifiers by Aurelium Skills for easy uninstalling. This only works on offline players.")
    public void onResetHealth(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            File playerDataFolder = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder(), "playerdata");
            int successful = 0;
            int error = 0;
            int total = 0;
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (player.isOnline()) continue;
                ++total;
                File playerFile = new File(playerDataFolder, player.getUniqueId() + ".dat");
                if (!playerFile.exists() || !playerFile.canWrite()) continue;
                try {
                    NBTFile nbtFile = new NBTFile(playerFile);
                    NBTCompoundList compoundList = nbtFile.getCompoundList("Attributes");
                    if (compoundList == null) continue;
                    boolean save = false;
                    block16: for (NBTListCompound listCompound : compoundList.subList(0, compoundList.size())) {
                        switch (listCompound.getString("Name")) {
                            case "generic.maxHealth": 
                            case "minecraft:generic.max_health": {
                                NBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                                if (modifierList == null) break;
                                for (NBTListCompound modifier : modifierList.subList(0, modifierList.size())) {
                                    if (!modifier.getString("Name").equals("skillsHealth")) continue;
                                    modifierList.remove(modifier);
                                    if (modifierList.size() == 0) {
                                        listCompound.removeKey("Modifiers");
                                    }
                                    save = true;
                                }
                                continue block16;
                            }
                            case "generic.luck": 
                            case "minecraft:generic.luck": {
                                NBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                                if (modifierList == null) break;
                                for (NBTListCompound modifier : modifierList.subList(0, modifierList.size())) {
                                    if (!modifier.getString("Name").equals("AureliumSkills-Luck")) continue;
                                    modifierList.remove(modifier);
                                    if (modifierList.size() == 0) {
                                        listCompound.removeKey("Modifiers");
                                    }
                                    save = true;
                                }
                                continue block16;
                            }
                            case "generic.attackSpeed": 
                            case "minecraft:generic.attack_speed": {
                                NBTCompoundList modifierList = listCompound.getCompoundList("Modifiers");
                                if (modifierList == null) break;
                                for (NBTListCompound modifier : modifierList.subList(0, modifierList.size())) {
                                    if (!modifier.getString("Name").equals("AureliumSkills-LightningBlade")) continue;
                                    modifierList.remove(modifier);
                                    if (modifierList.size() == 0) {
                                        listCompound.removeKey("Modifiers");
                                    }
                                    save = true;
                                }
                                continue block16;
                            }
                        }
                    }
                    if (!save) continue;
                    nbtFile.save();
                    ++successful;
                }
                catch (Exception e) {
                    ++error;
                }
            }
            sender.sendMessage("Searched " + total + " offline players. Successfully removed attributes from " + successful + " players. Failed to remove on " + error + " players.");
        } else {
            sender.sendMessage(ChatColor.RED + "Only console may execute this command!");
        }
    }

    @Subcommand(value="backup save")
    @CommandPermission(value="aureliumskills.backup.save")
    public void onBackupSave(CommandSender sender) {
        BackupProvider backupProvider = this.plugin.getBackupProvider();
        if (backupProvider != null) {
            Locale locale = this.plugin.getLang().getLocale(sender);
            sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_SAVE_SAVING, locale));
            backupProvider.saveBackup(sender, true);
        }
    }

    @Subcommand(value="backup load")
    @CommandPermission(value="aureliumskills.backup.load")
    public void onBackupLoad(CommandSender sender, String fileName) {
        StorageProvider storageProvider = this.plugin.getStorageProvider();
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (storageProvider != null) {
            File file = new File(this.plugin.getDataFolder() + "/backups/" + fileName);
            if (file.exists()) {
                if (file.getName().endsWith(".yml")) {
                    if (sender instanceof Player) {
                        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData((Player)sender);
                        if (playerData == null) {
                            return;
                        }
                        Object typed = playerData.getMetadata().get("backup_command");
                        if (typed != null) {
                            if (typed instanceof String) {
                                String typedFile = (String)typed;
                                if (typedFile.equals(file.getName())) {
                                    sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_LOADING, locale));
                                    storageProvider.loadBackup((FileConfiguration)YamlConfiguration.loadConfiguration((File)file), sender);
                                    playerData.getMetadata().remove("backup_command");
                                } else {
                                    this.backupLoadConfirm(playerData, sender, file);
                                }
                            } else {
                                this.backupLoadConfirm(playerData, sender, file);
                            }
                        } else {
                            this.backupLoadConfirm(playerData, sender, file);
                        }
                    } else {
                        sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_LOADING, locale));
                        storageProvider.loadBackup((FileConfiguration)YamlConfiguration.loadConfiguration((File)file), sender);
                    }
                } else {
                    sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_MUST_BE_YAML, locale));
                }
            } else {
                sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_FILE_NOT_FOUND, locale));
            }
        }
    }

    private void backupLoadConfirm(final PlayerData playerData, CommandSender sender, File file) {
        Locale locale = playerData.getLocale();
        sender.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.BACKUP_LOAD_CONFIRM, locale));
        playerData.getMetadata().put("backup_command", file.getName());
        new BukkitRunnable(){

            public void run() {
                playerData.getMetadata().remove("backup_command");
            }
        }.runTaskLater((Plugin)this.plugin, 1200L);
    }

    @Subcommand(value="claimitems")
    @CommandPermission(value="aureliumskills.claimitems")
    public void onClaimItems(Player player) {
        PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
        Locale locale = Lang.getDefaultLanguage();
        if (playerData != null) {
            locale = playerData.getLocale();
        }
        if (playerData == null || playerData.getUnclaimedItems().size() == 0) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.CLAIMITEMS_NO_ITEMS, locale));
            return;
        }
        UnclaimedItemsMenu.getInventory(this.plugin, playerData).open(player);
    }

    @Subcommand(value="item register")
    @CommandPermission(value="aureliumskills.item.register")
    public void onItemRegister(@Flags(value="itemheld") Player player, String key) {
        Locale locale = this.plugin.getLang().getLocale(player);
        if (key.contains(" ")) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ITEM_REGISTER_NO_SPACES, locale));
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.plugin.getItemRegistry().getItem(key) == null) {
            this.plugin.getItemRegistry().register(key, item);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REGISTER_REGISTERED, locale), "{key}", key));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_REGISTER_ALREADY_REGISTERED, locale), "{key}", key));
        }
    }

    @Subcommand(value="item unregister")
    @CommandPermission(value="aureliumskills.item.register")
    @CommandCompletion(value="@item_keys")
    public void onItemUnregister(Player player, String key) {
        Locale locale = this.plugin.getLang().getLocale(player);
        if (this.plugin.getItemRegistry().getItem(key) != null) {
            this.plugin.getItemRegistry().unregister(key);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_UNREGISTER_UNREGISTERED, locale), "{key}", key));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_UNREGISTER_NOT_REGISTERED, locale), "{key}", key));
        }
    }

    @Subcommand(value="item give")
    @CommandPermission(value="aureliumskills.item.give")
    @CommandCompletion(value="@players @item_keys")
    public void onItemGive(CommandSender sender, @Flags(value="other") Player player, String key, @Default(value="-1") int amount) {
        ItemStack item = this.plugin.getItemRegistry().getItem(key);
        Locale locale = this.plugin.getLang().getLocale(sender);
        if (item != null) {
            PlayerData playerData;
            if (amount != -1) {
                item.setAmount(amount);
            }
            ItemStack leftoverItem = ItemUtils.addItemToInventory(player, item);
            sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_GIVE_SENDER, locale), "{amount}", String.valueOf(item.getAmount()), "{key}", key, "{player}", player.getName()));
            if (!sender.equals(player)) {
                player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_GIVE_RECEIVER, locale), "{amount}", String.valueOf(item.getAmount()), "{key}", key));
            }
            if (leftoverItem != null && (playerData = this.plugin.getPlayerManager().getPlayerData(player)) != null) {
                playerData.getUnclaimedItems().add(new KeyIntPair(key, leftoverItem.getAmount()));
                player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(LevelerMessage.UNCLAIMED_ITEM, locale));
            }
        } else {
            sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_UNREGISTER_NOT_REGISTERED, locale), "{key}", key));
        }
    }

    @Subcommand(value="item multiplier add")
    @CommandCompletion(value="@skills_global @nothing true|false")
    @CommandPermission(value="aureliumskills.item.multiplier.add")
    @Description(value="Adds an item multiplier to the held item to global or a specific skill where value is the percent more XP gained.")
    public void onItemMultiplierAdd(@Flags(value="itemheld") Player player, String target, double value, @Default(value="true") boolean lore) {
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = this.plugin.getSkillRegistry().getSkill(target);
        Locale locale = this.plugin.getLang().getLocale(player);
        Multipliers multipliers = new Multipliers(this.plugin);
        if (skill != null) {
            for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, item)) {
                if (multiplier.getSkill() != skill) continue;
                player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", skill.getDisplayName(locale)));
                return;
            }
            if (lore) {
                multipliers.addLore(ModifierType.ITEM, item, skill, value, locale);
            }
            ItemStack newItem = multipliers.addMultiplier(ModifierType.ITEM, item, skill, value);
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_ADD_ADDED, locale), "{target}", skill.getDisplayName(locale), "{value}", String.valueOf(value)));
        } else if (target.equalsIgnoreCase("global")) {
            String global = Lang.getMessage(CommandMessage.MULTIPLIER_GLOBAL, locale);
            for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, item)) {
                if (multiplier.getSkill() != null) continue;
                player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", global));
                return;
            }
            if (lore) {
                multipliers.addLore(ModifierType.ITEM, item, null, value, locale);
            }
            ItemStack newItem = multipliers.addMultiplier(ModifierType.ITEM, item, null, value);
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_ADD_ADDED, locale), "{target}", global, "{value}", String.valueOf(value)));
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
    }

    @Subcommand(value="item multiplier remove")
    @CommandCompletion(value="@skills_global")
    @CommandPermission(value="aureliumskills.item.multiplier.remove")
    @Description(value="Removes an item multiplier of a the specified skill or global from the held item.")
    public void onItemMultiplierRemove(@Flags(value="itemheld") Player player, String target) {
        String targetName;
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = this.plugin.getSkillRegistry().getSkill(target);
        boolean removed = false;
        Multipliers multipliers = new Multipliers(this.plugin);
        for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, item)) {
            if (multiplier.getSkill() != skill) continue;
            item = multipliers.removeMultiplier(ModifierType.ITEM, item, skill);
            removed = true;
            break;
        }
        player.getInventory().setItemInMainHand(item);
        if (skill != null) {
            targetName = skill.getDisplayName(locale);
        } else if (target.equalsIgnoreCase("global")) {
            targetName = Lang.getMessage(CommandMessage.MULTIPLIER_GLOBAL, locale);
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
        if (removed) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_REMOVE_REMOVED, locale), "{target}", targetName));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_REMOVE_DOES_NOT_EXIST, locale), "{target}", targetName));
        }
    }

    @Subcommand(value="item multiplier list")
    @CommandPermission(value="aureliumskills.item.multiplier.list")
    @Description(value="Lists all item multipliers on the held item.")
    public void onItemMultiplierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_LIST_HEADER, locale));
        Multipliers multipliers = new Multipliers(this.plugin);
        for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ITEM, item)) {
            String targetName = multiplier.getSkill() != null ? multiplier.getSkill().getDisplayName(locale) : Lang.getMessage(CommandMessage.MULTIPLIER_GLOBAL, locale);
            message.append("\n").append(TextUtil.replace(Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_LIST_ENTRY, locale), "{target}", targetName, "{value}", String.valueOf(multiplier.getValue())));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="item multiplier removeall")
    @CommandPermission(value="aureliumskills.item.multiplier.removeall")
    @Description(value="Removes all item multipliers from the item held.")
    public void onItemMultiplierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Multipliers multipliers = new Multipliers(this.plugin);
        ItemStack item = multipliers.removeAllMultipliers(ModifierType.ITEM, player.getInventory().getItemInMainHand());
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ITEM_MULTIPLIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="armor multiplier add")
    @CommandCompletion(value="@skills_global @nothing true|false")
    @CommandPermission(value="aureliumskills.armor.multiplier.add")
    @Description(value="Adds an armor multiplier to the held item to global or a specific skill where value is the percent more XP gained.")
    public void onArmorMultiplierAdd(@Flags(value="itemheld") Player player, String target, double value, @Default(value="true") boolean lore) {
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = this.plugin.getSkillRegistry().getSkill(target);
        Locale locale = this.plugin.getLang().getLocale(player);
        Multipliers multipliers = new Multipliers(this.plugin);
        if (skill != null) {
            for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ARMOR, item)) {
                if (multiplier.getSkill() != skill) continue;
                player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", skill.getDisplayName(locale)));
                return;
            }
            if (lore) {
                multipliers.addLore(ModifierType.ARMOR, item, skill, value, locale);
            }
            ItemStack newItem = multipliers.addMultiplier(ModifierType.ARMOR, item, skill, value);
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_ADD_ADDED, locale), "{target}", skill.getDisplayName(locale), "{value}", String.valueOf(value)));
        } else if (target.equalsIgnoreCase("global")) {
            String global = Lang.getMessage(CommandMessage.MULTIPLIER_GLOBAL, locale);
            for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ARMOR, item)) {
                if (multiplier.getSkill() != null) continue;
                player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", global));
                return;
            }
            if (lore) {
                multipliers.addLore(ModifierType.ARMOR, item, null, value, locale);
            }
            ItemStack newItem = multipliers.addMultiplier(ModifierType.ARMOR, item, null, value);
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_ADD_ADDED, locale), "{target}", global, "{value}", String.valueOf(value)));
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
    }

    @Subcommand(value="armor multiplier remove")
    @CommandCompletion(value="@skills_global")
    @CommandPermission(value="aureliumskills.armor.multiplier.remove")
    @Description(value="Removes an armor multiplier of a the specified skill or global from the held item.")
    public void onArmorMultiplierRemove(@Flags(value="itemheld") Player player, String target) {
        String targetName;
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = this.plugin.getSkillRegistry().getSkill(target);
        boolean removed = false;
        Multipliers multipliers = new Multipliers(this.plugin);
        for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ARMOR, item)) {
            if (multiplier.getSkill() != skill) continue;
            item = multipliers.removeMultiplier(ModifierType.ARMOR, item, skill);
            removed = true;
            break;
        }
        player.getInventory().setItemInMainHand(item);
        if (skill != null) {
            targetName = skill.getDisplayName(locale);
        } else if (target.equalsIgnoreCase("global")) {
            targetName = Lang.getMessage(CommandMessage.MULTIPLIER_GLOBAL, locale);
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
        if (removed) {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_REMOVE_REMOVED, locale), "{target}", targetName));
        } else {
            player.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_REMOVE_DOES_NOT_EXIST, locale), "{target}", targetName));
        }
    }

    @Subcommand(value="armor multiplier list")
    @CommandPermission(value="aureliumskills.armor.multiplier.list")
    @Description(value="Lists all armor multipliers on the held item.")
    public void onArmorMultiplierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_LIST_HEADER, locale));
        Multipliers multipliers = new Multipliers(this.plugin);
        for (Multiplier multiplier : multipliers.getMultipliers(ModifierType.ARMOR, item)) {
            String targetName = multiplier.getSkill() != null ? multiplier.getSkill().getDisplayName(locale) : Lang.getMessage(CommandMessage.MULTIPLIER_GLOBAL, locale);
            message.append("\n").append(TextUtil.replace(Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_LIST_ENTRY, locale), "{target}", targetName, "{value}", String.valueOf(multiplier.getValue())));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="armor multiplier removeall")
    @CommandPermission(value="aureliumskills.armor.multiplier.removeall")
    @Description(value="Removes all armor multipliers from the item held.")
    public void onArmorMultiplierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getLang().getLocale(player);
        Multipliers multipliers = new Multipliers(this.plugin);
        ItemStack item = multipliers.removeAllMultipliers(ModifierType.ARMOR, player.getInventory().getItemInMainHand());
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(AureliumSkills.getPrefix(locale) + Lang.getMessage(CommandMessage.ARMOR_MULTIPLIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="version")
    @CommandPermission(value="aureliumskills.version")
    public void onVersion(CommandSender sender) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        new UpdateChecker((Plugin)this.plugin, 81069).getVersion((Consumer<String>)((Consumer)latestVersion -> sender.sendMessage(AureliumSkills.getPrefix(locale) + TextUtil.replace(Lang.getMessage(CommandMessage.VERSION, locale), "{current_version}", this.plugin.getDescription().getVersion(), "{latest_version}", latestVersion))));
    }

    @Subcommand(value="help")
    @CommandPermission(value="aureliumskills.help")
    public void onHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }
}

