/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.commands;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.stats.Luck;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReloadManager {
    private final AureliumSkills plugin;
    private final Lang lang;

    public ReloadManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLang();
    }

    public void reload(CommandSender sender) {
        Locale locale = this.plugin.getLang().getLocale(sender);
        this.plugin.reloadConfig();
        this.plugin.saveDefaultConfig();
        this.plugin.getOptionLoader().loadOptions();
        this.plugin.getRequirementManager().load();
        this.plugin.getSourceManager().loadSources();
        this.plugin.getCheckBlockReplace().reloadCustomBlocks();
        this.plugin.getRewardManager().loadRewards();
        this.lang.loadLanguageFiles();
        this.lang.loadEmbeddedMessages(this.plugin.getCommandManager());
        this.lang.loadLanguages(this.plugin.getCommandManager());
        try {
            this.plugin.getMenuLoader().load();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            if (sender instanceof Player) {
                sender.sendMessage(ChatColor.YELLOW + "[AureliumSkills] Error while loading menus, see console for details");
            }
            Bukkit.getLogger().warning("[AureliumSkills] Error while loading menus!");
        }
        this.plugin.getAbilityManager().loadOptions();
        this.plugin.getLeveler().loadLevelRequirements();
        this.plugin.getLootTableManager().loadLootTables();
        this.plugin.getWorldManager().loadWorlds();
        if (this.plugin.isWorldGuardEnabled()) {
            this.plugin.getWorldGuardSupport().loadRegions();
        }
        Luck luck = new Luck(this.plugin);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.plugin.getHealth().reload(player);
            luck.reload(player);
        }
        this.plugin.getActionBar().resetActionBars();
        this.plugin.getBossBar().loadOptions();
        sender.sendMessage(AureliumSkills.getPrefix(locale) + ChatColor.GREEN + Lang.getMessage(CommandMessage.RELOAD, locale));
    }
}

