/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.api;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.modifier.ModifierType;
import com.archyx.aureliumskills.modifier.Modifiers;
import com.archyx.aureliumskills.modifier.Multipliers;
import com.archyx.aureliumskills.modifier.StatModifier;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.stats.Stat;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AureliumAPI {
    private static AureliumSkills plugin;

    public static void setPlugin(AureliumSkills plugin) {
        if (AureliumAPI.plugin != null) {
            throw new IllegalStateException("The AureliumSkills API is already registered");
        }
        AureliumAPI.plugin = plugin;
    }

    public static AureliumSkills getPlugin() {
        if (plugin == null) {
            throw new IllegalStateException("The AureliumSkills API is not loaded yet");
        }
        return plugin;
    }

    public static double getMana(Player player) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getMana();
        }
        return 0.0;
    }

    @Deprecated
    public static double getMana(UUID playerId) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            return playerData.getMana();
        }
        return 0.0;
    }

    public static double getMaxMana(Player player) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getMaxMana();
        }
        return OptionL.getDouble(Option.BASE_MANA);
    }

    public static double getManaRegen(Player player) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getManaRegen();
        }
        return OptionL.getDouble(Option.REGENERATION_BASE_MANA_REGEN);
    }

    @Deprecated
    public static double getMaxMana(UUID playerId) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            return playerData.getMaxMana();
        }
        return OptionL.getDouble(Option.BASE_MANA);
    }

    public static void setMana(Player player, double amount) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            playerData.setMana(amount);
        }
    }

    @Deprecated
    public static void setMana(UUID playerId, double amount) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            playerData.setMana(amount);
        }
    }

    public static void addXp(Player player, Skill skill, double amount) {
        plugin.getLeveler().addXp(player, skill, amount);
    }

    public static void addXpRaw(Player player, Skill skill, double amount) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            playerData.addSkillXp(skill, amount);
            plugin.getLeveler().checkLevelUp(player, skill);
        }
    }

    @Deprecated
    public static boolean addXpOffline(OfflinePlayer player, Skill skill, double amount) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player.getUniqueId());
        if (playerData != null) {
            playerData.addSkillXp(skill, amount);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean addXpOffline(UUID playerId, Skill skill, double amount) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            playerData.addSkillXp(skill, amount);
            return true;
        }
        return false;
    }

    public static int getSkillLevel(Player player, Skill skill) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getSkillLevel(skill);
        }
        return 1;
    }

    @Deprecated
    public static int getSkillLevel(UUID playerId, Skill skill) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            return playerData.getSkillLevel(skill);
        }
        return 1;
    }

    public static double getXp(Player player, Skill skill) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getSkillXp(skill);
        }
        return 1.0;
    }

    @Deprecated
    public static double getXp(UUID playerId, Skill skill) {
        PlayerData playerSkill = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerSkill != null) {
            return playerSkill.getSkillXp(skill);
        }
        return 1.0;
    }

    public static double getStatLevel(Player player, Stat stat) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getStatLevel(stat);
        }
        return 0.0;
    }

    @Deprecated
    public static double getStatLevel(UUID playerId, Stat stat) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            return playerData.getStatLevel(stat);
        }
        return 0.0;
    }

    @Deprecated
    public static double getBaseStatLevel(Player player, Stat stat) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            return playerData.getStatLevel(stat);
        }
        return 0.0;
    }

    @Deprecated
    public static double getBaseStatLevel(UUID playerId, Stat stat) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            return playerData.getStatLevel(stat);
        }
        return 0.0;
    }

    public static boolean addStatModifier(Player player, String name, Stat stat, double value) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            playerData.addStatModifier(new StatModifier(name, stat, value));
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean addStatModifier(UUID playerId, String name, Stat stat, double value) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            playerData.addStatModifier(new StatModifier(name, stat, value));
            return true;
        }
        return false;
    }

    public static boolean removeStatModifier(Player player, String name) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(player);
        if (playerData != null) {
            playerData.removeStatModifier(name);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean removeStatModifier(UUID playerId, String name) {
        PlayerData playerData = plugin.getPlayerManager().getPlayerData(playerId);
        if (playerData != null) {
            playerData.removeStatModifier(name);
            return true;
        }
        return false;
    }

    public static ItemStack addItemModifier(ItemStack item, Stat stat, double value, boolean lore) {
        Modifiers modifiers = new Modifiers(plugin);
        ItemStack modifiedItem = modifiers.addModifier(ModifierType.ITEM, item, stat, value);
        if (lore) {
            modifiers.addLore(ModifierType.ITEM, modifiedItem, stat, value, Lang.getDefaultLanguage());
        }
        return modifiedItem;
    }

    public static ItemStack addArmorModifier(ItemStack item, Stat stat, double value, boolean lore) {
        Modifiers modifiers = new Modifiers(plugin);
        ItemStack modifiedItem = modifiers.addModifier(ModifierType.ARMOR, item, stat, value);
        if (lore) {
            modifiers.addLore(ModifierType.ARMOR, modifiedItem, stat, value, Lang.getDefaultLanguage());
        }
        return modifiedItem;
    }

    public static ItemStack addItemMultiplier(ItemStack item, Skill skill, double value, boolean lore) {
        Multipliers multipliers = new Multipliers(plugin);
        ItemStack modifiedItem = multipliers.addMultiplier(ModifierType.ITEM, item, skill, value);
        if (lore) {
            multipliers.addLore(ModifierType.ITEM, modifiedItem, skill, value, Lang.getDefaultLanguage());
        }
        return modifiedItem;
    }

    public static ItemStack addArmorMultiplier(ItemStack item, Skill skill, double value, boolean lore) {
        Multipliers multipliers = new Multipliers(plugin);
        ItemStack modifiedItem = multipliers.addMultiplier(ModifierType.ITEM, item, skill, value);
        if (lore) {
            multipliers.addLore(ModifierType.ARMOR, modifiedItem, skill, value, Lang.getDefaultLanguage());
        }
        return modifiedItem;
    }
}

