/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills.ability;

import com.archyx.aureliumskills.AureliumSkills;
import com.archyx.aureliumskills.ability.Ability;
import com.archyx.aureliumskills.ability.AbilityOption;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.configuration.OptionValue;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.mana.MAbility;
import com.archyx.aureliumskills.mana.ManaAbilityOption;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.util.text.TextUtil;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class AbilityManager {
    private final Map<Ability, AbilityOption> abilityOptions;
    private final Map<MAbility, ManaAbilityOption> manaAbilityOptions;
    private final AureliumSkills plugin;

    public AbilityManager(AureliumSkills plugin) {
        this.plugin = plugin;
        this.abilityOptions = new HashMap<Ability, AbilityOption>();
        this.manaAbilityOptions = new HashMap<MAbility, ManaAbilityOption>();
    }

    public void loadOptions() {
        ConfigurationSection manaAbilities;
        File file = new File(this.plugin.getDataFolder(), "abilities_config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("abilities_config.yml", false);
        }
        FileConfiguration config = this.updateFile(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        this.migrateOptions(file, config);
        int amountLoaded = 0;
        int amountDisabled = 0;
        long startTime = System.currentTimeMillis();
        ConfigurationSection abilities = config.getConfigurationSection("abilities");
        if (abilities != null) {
            for (Skill skill : this.plugin.getSkillRegistry().getSkills()) {
                String skillName = skill.name().toLowerCase(Locale.ENGLISH);
                ConfigurationSection skillAbilities = abilities.getConfigurationSection(skillName);
                if (skillAbilities == null) continue;
                for (String abilityName : skillAbilities.getKeys(false)) {
                    AbilityOption option;
                    int hasKey = 0;
                    for (Ability ability : Ability.values()) {
                        if (!abilityName.toUpperCase().equals(ability.name())) continue;
                        hasKey = 1;
                        break;
                    }
                    if (hasKey == 0) continue;
                    String path = "abilities." + skillName + "." + abilityName + ".";
                    Ability ability = Ability.valueOf(abilityName.toUpperCase());
                    boolean enabled = config.getBoolean(path + "enabled", true);
                    if (!enabled) {
                        ++amountDisabled;
                    }
                    double baseValue = config.getDouble(path + "base", ability.getDefaultBaseValue());
                    double valuePerLevel = config.getDouble(path + "per_level", ability.getDefaultValuePerLevel());
                    int defUnlock = 2;
                    for (int i = 0; i < skill.getAbilities().size(); ++i) {
                        if (((Supplier)skill.getAbilities().get(i)).get() != ability) continue;
                        defUnlock += i;
                        break;
                    }
                    int unlock = config.getInt(path + "unlock", defUnlock);
                    int levelUp = config.getInt(path + "level_up", 5);
                    int maxLevel = config.getInt(path + "max_level", 0);
                    Set<String> optionKeys = this.getOptionKeys(ability);
                    HashMap<String, OptionValue> options = null;
                    if (optionKeys != null) {
                        options = new HashMap<String, OptionValue>();
                        for (String key : optionKeys) {
                            Object value = config.get(path + key);
                            if (value == null) continue;
                            options.put(key, new OptionValue(value));
                        }
                    }
                    if (ability.hasTwoValues()) {
                        double baseValue2 = config.getDouble(path + "base_2", ability.getDefaultBaseValue2());
                        double valuePerLevel2 = config.getDouble(path + "per_level_2", ability.getDefaultValuePerLevel2());
                        option = options != null ? new AbilityOption(enabled, baseValue, valuePerLevel, baseValue2, valuePerLevel2, unlock, levelUp, maxLevel, options) : new AbilityOption(enabled, baseValue, valuePerLevel, baseValue2, valuePerLevel2, unlock, levelUp, maxLevel);
                    } else {
                        option = options != null ? new AbilityOption(enabled, baseValue, valuePerLevel, unlock, levelUp, maxLevel, options) : new AbilityOption(enabled, baseValue, valuePerLevel, unlock, levelUp, maxLevel);
                    }
                    this.abilityOptions.put(ability, option);
                    ++amountLoaded;
                }
            }
        }
        if ((manaAbilities = config.getConfigurationSection("mana_abilities")) != null) {
            for (String manaAbilityName : manaAbilities.getKeys(false)) {
                boolean hasKey = false;
                for (MAbility manaAbility : MAbility.values()) {
                    if (!manaAbilityName.toUpperCase().equals(manaAbility.name())) continue;
                    hasKey = true;
                    break;
                }
                if (!hasKey) continue;
                MAbility mAbility = MAbility.valueOf(manaAbilityName.toUpperCase());
                String path = "mana_abilities." + manaAbilityName + ".";
                boolean enabled = config.getBoolean(path + "enabled", true);
                if (!enabled) {
                    ++amountDisabled;
                }
                double baseValue = config.getDouble(path + "base_value", mAbility.getDefaultBaseValue());
                double valuePerLevel = config.getDouble(path + "value_per_level", mAbility.getDefaultValuePerLevel());
                double cooldown = config.getDouble(path + "cooldown", mAbility.getDefaultBaseCooldown());
                double cooldownPerLevel = config.getDouble(path + "cooldown_per_level", mAbility.getDefaultCooldownPerLevel());
                double manaCost = config.getDouble(path + "mana_cost", (double)mAbility.getDefaultBaseManaCost());
                double manaCostPerLevel = config.getDouble(path + "mana_cost_per_level", (double)mAbility.getDefaultManaCostPerLevel());
                int unlock = config.getInt(path + "unlock", 7);
                int levelUp = config.getInt(path + "level_up", 7);
                int maxLevel = config.getInt(path + "max_level", 0);
                Set<String> optionKeys = this.plugin.getManaAbilityManager().getOptionKeys(mAbility);
                HashMap<String, OptionValue> options = null;
                if (optionKeys != null) {
                    options = new HashMap<String, OptionValue>();
                    for (String key : optionKeys) {
                        Object value = config.get(path + key);
                        if (value == null) continue;
                        options.put(key, new OptionValue(value));
                    }
                }
                ManaAbilityOption option = options != null ? new ManaAbilityOption(enabled, baseValue, valuePerLevel, cooldown, cooldownPerLevel, manaCost, manaCostPerLevel, unlock, levelUp, maxLevel, options) : new ManaAbilityOption(enabled, baseValue, valuePerLevel, cooldown, cooldownPerLevel, manaCost, manaCostPerLevel, unlock, levelUp, maxLevel);
                this.manaAbilityOptions.put(mAbility, option);
                ++amountLoaded;
            }
        }
        long l = System.currentTimeMillis();
        long timeElapsed = l - startTime;
        if (amountDisabled > 0) {
            this.plugin.getLogger().info("Disabled " + amountDisabled + " Abilities");
        }
        this.plugin.getLogger().info("Loaded " + amountLoaded + " Ability Options in " + timeElapsed + "ms");
    }

    private FileConfiguration updateFile(File file, FileConfiguration config) {
        YamlConfiguration imbConfig;
        int imbVersion;
        int currentVersion;
        InputStream stream;
        if (config.contains("file_version") && (stream = this.plugin.getResource("abilities_config.yml")) != null && (currentVersion = config.getInt("file_version")) != (imbVersion = (imbConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8))).getInt("file_version"))) {
            try {
                ConfigurationSection configSection = imbConfig.getConfigurationSection("");
                if (configSection != null) {
                    for (String key : configSection.getKeys(true)) {
                        if (configSection.isConfigurationSection(key) || config.contains(key)) continue;
                        config.set(key, imbConfig.get(key));
                    }
                }
                config.set("file_version", (Object)imbVersion);
                config.save(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void migrateOptions(File file, FileConfiguration abilitiesConfig) {
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection abilities = config.getConfigurationSection("abilities");
        if (abilities == null) {
            return;
        }
        try {
            for (String abilityName : abilities.getKeys(false)) {
                String newKey = TextUtil.replace(abilityName, "-", "_").toUpperCase();
                if (!this.isAbility(newKey)) continue;
                Ability ability = Ability.valueOf(newKey);
                boolean enabled = abilities.getBoolean(abilityName + ".enabled", true);
                double base = abilities.getDouble(abilityName + ".base", ability.getDefaultBaseValue());
                double per_level = abilities.getDouble(abilityName + ".per-level", ability.getDefaultValuePerLevel());
                String path = "abilities." + ability.getSkill().name().toLowerCase(Locale.ENGLISH) + "." + newKey.toLowerCase(Locale.ENGLISH) + ".";
                abilitiesConfig.set(path + "enabled", (Object)enabled);
                abilitiesConfig.set(path + "base", (Object)base);
                abilitiesConfig.set(path + "per_level", (Object)per_level);
                if (!ability.hasTwoValues()) continue;
                double base_2 = abilities.getDouble(abilityName + ".base-2", ability.getDefaultBaseValue2());
                double per_level_2 = abilities.getDouble(abilityName + ".per_level-2", ability.getDefaultValuePerLevel2());
                abilitiesConfig.set(path + "base_2", (Object)base_2);
                abilitiesConfig.set(path + "per_level_2", (Object)per_level_2);
            }
            config.set("abilities", null);
            ConfigurationSection manaAbilities = config.getConfigurationSection("mana-abilities");
            if (manaAbilities != null) {
                for (String manaAbilityName : manaAbilities.getKeys(false)) {
                    String newKey = TextUtil.replace(manaAbilityName, "-", "_").toUpperCase();
                    if (!this.isManaAbility(newKey)) continue;
                    MAbility mAbility = MAbility.valueOf(newKey);
                    boolean enabled = manaAbilities.getBoolean(manaAbilityName + ".enabled", true);
                    double base = manaAbilities.getDouble(manaAbilityName + ".base-value", mAbility.getDefaultBaseValue());
                    double per_level = manaAbilities.getDouble(manaAbilityName + ".value-per-level", mAbility.getDefaultValuePerLevel());
                    double cooldown = manaAbilities.getDouble(manaAbilityName + ".cooldown", mAbility.getDefaultBaseCooldown());
                    double cooldown_per_level = manaAbilities.getDouble(manaAbilityName + ".cooldown-per-level", mAbility.getDefaultCooldownPerLevel());
                    double mana_cost = manaAbilities.getDouble(manaAbilityName + ".mana-cost", (double)mAbility.getDefaultBaseManaCost());
                    double mana_cost_per_level = manaAbilities.getDouble(manaAbilityName + ".mana-cost-per-level", (double)mAbility.getDefaultManaCostPerLevel());
                    String path = "mana_abilities." + newKey.toLowerCase(Locale.ENGLISH) + ".";
                    abilitiesConfig.set(path + "enabled", (Object)enabled);
                    abilitiesConfig.set(path + "base_value", (Object)base);
                    abilitiesConfig.set(path + "value_per_level", (Object)per_level);
                    abilitiesConfig.set(path + "cooldown", (Object)cooldown);
                    abilitiesConfig.set(path + "cooldown_per_level", (Object)cooldown_per_level);
                    abilitiesConfig.set(path + "mana_cost", (Object)mana_cost);
                    abilitiesConfig.set(path + "mana_cost_per_level", (Object)mana_cost_per_level);
                }
                config.set("mana-abilities", null);
            }
            this.plugin.saveConfig();
            abilitiesConfig.save(file);
            Bukkit.getLogger().warning("[AureliumSkills] Your existing ability options have been migrated to abilities_config.yml and the old options in config.yml have been deleted, this is normal if you are updating to Alpha 1.6.0 or above from before Alpha 1.6.0!");
        }
        catch (Exception e) {
            e.printStackTrace();
            Bukkit.getLogger().severe("[AureliumSkills] An error occurred while migrating ability options, please report this as a bug!");
        }
    }

    public AbilityOption getAbilityOption(Ability ability) {
        return this.abilityOptions.get(ability);
    }

    public ManaAbilityOption getAbilityOption(MAbility mAbility) {
        return this.manaAbilityOptions.get(mAbility);
    }

    public boolean isEnabled(Ability ability) {
        if (this.abilityOptions.containsKey(ability)) {
            return this.abilityOptions.get(ability).isEnabled();
        }
        return true;
    }

    public boolean isEnabled(MAbility mAbility) {
        if (this.manaAbilityOptions.containsKey(mAbility)) {
            return this.manaAbilityOptions.get(mAbility).isEnabled();
        }
        return true;
    }

    public double getValue(Ability ability, int level) {
        return this.getBaseValue(ability) + this.getValuePerLevel(ability) * (double)(level - 1);
    }

    public double getBaseValue(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getBaseValue();
        }
        return ability.getDefaultBaseValue();
    }

    public double getValuePerLevel(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getValuePerLevel();
        }
        return ability.getDefaultValuePerLevel();
    }

    public double getValue2(Ability ability, int level) {
        return this.getBaseValue2(ability) + this.getValuePerLevel2(ability) * (double)(level - 1);
    }

    public double getBaseValue2(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getBaseValue2();
        }
        return ability.getDefaultBaseValue2();
    }

    public double getValuePerLevel2(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getValuePerLevel2();
        }
        return ability.getDefaultValuePerLevel2();
    }

    public int getUnlock(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getUnlock();
        }
        int defUnlock = 2;
        Skill skill = ability.getSkill();
        for (int i = 0; i < skill.getAbilities().size(); ++i) {
            if (((Supplier)skill.getAbilities().get(i)).get() != ability) continue;
            defUnlock += i;
            break;
        }
        return defUnlock;
    }

    public int getLevelUp(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getLevelUp();
        }
        return 5;
    }

    public int getMaxLevel(Ability ability) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            return option.getMaxLevel();
        }
        return 0;
    }

    public List<Ability> getAbilities(Skill skill, int level) {
        ImmutableList<Supplier<Ability>> skillAbilities = skill.getAbilities();
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        if (skillAbilities.size() == 5) {
            for (Supplier abilitySupplier : skillAbilities) {
                Ability ability = (Ability)abilitySupplier.get();
                if (level < this.getUnlock(ability) || (level - this.getUnlock(ability)) % this.getLevelUp(ability) != 0) continue;
                abilities.add(ability);
            }
        }
        return abilities;
    }

    public OptionValue getOption(Ability ability, String key) {
        AbilityOption option = this.getAbilityOption(ability);
        if (option != null) {
            OptionValue optionValue = option.getOption(key);
            if (optionValue != null) {
                return optionValue;
            }
            return ability.getDefaultOptions().get(key);
        }
        return ability.getDefaultOptions().get(key);
    }

    public boolean getOptionAsBooleanElseTrue(Ability ability, String key) {
        OptionValue value = this.getOption(ability, key);
        if (value != null && value.getValue() != null) {
            return value.asBoolean();
        }
        return true;
    }

    @Nullable
    public Set<String> getOptionKeys(Ability ability) {
        if (ability.getDefaultOptions() != null) {
            return ability.getDefaultOptions().keySet();
        }
        return null;
    }

    public void sendMessage(Player player, String message) {
        if (OptionL.getBoolean(Option.ACTION_BAR_ABILITY) && OptionL.getBoolean(Option.ACTION_BAR_ENABLED)) {
            this.plugin.getActionBar().sendAbilityActionBar(player, message);
        } else {
            PlayerData playerData = this.plugin.getPlayerManager().getPlayerData(player);
            if (playerData == null) {
                return;
            }
            player.sendMessage(AureliumSkills.getPrefix(playerData.getLocale()) + message);
        }
    }

    private boolean isAbility(String abilityName) {
        for (Ability ability : Ability.values()) {
            if (!ability.toString().equals(abilityName)) continue;
            return true;
        }
        return false;
    }

    private boolean isManaAbility(String manaAbilityName) {
        for (MAbility mAbility : MAbility.values()) {
            if (!mAbility.toString().equals(manaAbilityName)) continue;
            return true;
        }
        return false;
    }
}

