/*
 * Decompiled with CFR 0.152.
 */
package com.archyx.aureliumskills;

import com.archyx.aureliumskills.ability.AbilityManager;
import com.archyx.aureliumskills.acf.InvalidCommandArgument;
import com.archyx.aureliumskills.acf.PaperCommandManager;
import com.archyx.aureliumskills.api.AureliumAPI;
import com.archyx.aureliumskills.bstats.bukkit.Metrics;
import com.archyx.aureliumskills.commands.ManaCommand;
import com.archyx.aureliumskills.commands.SkillCommands;
import com.archyx.aureliumskills.commands.SkillsCommand;
import com.archyx.aureliumskills.commands.StatsCommand;
import com.archyx.aureliumskills.configuration.Option;
import com.archyx.aureliumskills.configuration.OptionL;
import com.archyx.aureliumskills.data.PlayerData;
import com.archyx.aureliumskills.data.PlayerManager;
import com.archyx.aureliumskills.data.backup.BackupProvider;
import com.archyx.aureliumskills.data.backup.LegacyFileBackup;
import com.archyx.aureliumskills.data.backup.MysqlBackup;
import com.archyx.aureliumskills.data.backup.YamlBackup;
import com.archyx.aureliumskills.data.converter.LegacyFileToYamlConverter;
import com.archyx.aureliumskills.data.converter.LegacyMysqlToMysqlConverter;
import com.archyx.aureliumskills.data.storage.MySqlStorageProvider;
import com.archyx.aureliumskills.data.storage.StorageProvider;
import com.archyx.aureliumskills.data.storage.YamlStorageProvider;
import com.archyx.aureliumskills.inv.InventoryManager;
import com.archyx.aureliumskills.item.ItemRegistry;
import com.archyx.aureliumskills.lang.CommandMessage;
import com.archyx.aureliumskills.lang.Lang;
import com.archyx.aureliumskills.leaderboard.LeaderboardManager;
import com.archyx.aureliumskills.leveler.Leveler;
import com.archyx.aureliumskills.listeners.DamageListener;
import com.archyx.aureliumskills.listeners.PlayerJoinQuit;
import com.archyx.aureliumskills.loot.LootTableManager;
import com.archyx.aureliumskills.mana.ManaAbilityManager;
import com.archyx.aureliumskills.mana.ManaManager;
import com.archyx.aureliumskills.menu.MenuLoader;
import com.archyx.aureliumskills.modifier.ArmorModifierListener;
import com.archyx.aureliumskills.modifier.ItemListener;
import com.archyx.aureliumskills.modifier.ModifierManager;
import com.archyx.aureliumskills.nbtapi.utils.MinecraftVersion;
import com.archyx.aureliumskills.region.RegionBlockListener;
import com.archyx.aureliumskills.region.RegionListener;
import com.archyx.aureliumskills.region.RegionManager;
import com.archyx.aureliumskills.requirement.RequirementListener;
import com.archyx.aureliumskills.requirement.RequirementManager;
import com.archyx.aureliumskills.rewards.RewardManager;
import com.archyx.aureliumskills.skills.Skill;
import com.archyx.aureliumskills.skills.SkillRegistry;
import com.archyx.aureliumskills.skills.Skills;
import com.archyx.aureliumskills.skills.agility.AgilityAbilities;
import com.archyx.aureliumskills.skills.agility.AgilityLeveler;
import com.archyx.aureliumskills.skills.alchemy.AlchemyAbilities;
import com.archyx.aureliumskills.skills.alchemy.AlchemyLeveler;
import com.archyx.aureliumskills.skills.archery.ArcheryAbilities;
import com.archyx.aureliumskills.skills.archery.ArcheryLeveler;
import com.archyx.aureliumskills.skills.defense.DefenseAbilities;
import com.archyx.aureliumskills.skills.defense.DefenseLeveler;
import com.archyx.aureliumskills.skills.enchanting.EnchantingAbilities;
import com.archyx.aureliumskills.skills.enchanting.EnchantingLeveler;
import com.archyx.aureliumskills.skills.endurance.EnduranceAbilities;
import com.archyx.aureliumskills.skills.endurance.EnduranceLeveler;
import com.archyx.aureliumskills.skills.excavation.ExcavationAbilities;
import com.archyx.aureliumskills.skills.excavation.ExcavationLeveler;
import com.archyx.aureliumskills.skills.excavation.ExcavationLootHandler;
import com.archyx.aureliumskills.skills.farming.FarmingAbilities;
import com.archyx.aureliumskills.skills.farming.FarmingLeveler;
import com.archyx.aureliumskills.skills.fighting.FightingAbilities;
import com.archyx.aureliumskills.skills.fighting.FightingLeveler;
import com.archyx.aureliumskills.skills.fishing.FishingAbilities;
import com.archyx.aureliumskills.skills.fishing.FishingLeveler;
import com.archyx.aureliumskills.skills.fishing.FishingLootHandler;
import com.archyx.aureliumskills.skills.foraging.ForagingAbilities;
import com.archyx.aureliumskills.skills.foraging.ForagingLeveler;
import com.archyx.aureliumskills.skills.foraging.ForagingLootHandler;
import com.archyx.aureliumskills.skills.forging.ForgingAbilities;
import com.archyx.aureliumskills.skills.forging.ForgingLeveler;
import com.archyx.aureliumskills.skills.healing.HealingAbilities;
import com.archyx.aureliumskills.skills.healing.HealingLeveler;
import com.archyx.aureliumskills.skills.mining.MiningAbilities;
import com.archyx.aureliumskills.skills.mining.MiningLeveler;
import com.archyx.aureliumskills.skills.mining.MiningLootHandler;
import com.archyx.aureliumskills.skills.sorcery.SorceryLeveler;
import com.archyx.aureliumskills.source.SourceManager;
import com.archyx.aureliumskills.source.SourceRegistry;
import com.archyx.aureliumskills.stats.Health;
import com.archyx.aureliumskills.stats.Luck;
import com.archyx.aureliumskills.stats.Regeneration;
import com.archyx.aureliumskills.stats.Stat;
import com.archyx.aureliumskills.stats.StatRegistry;
import com.archyx.aureliumskills.stats.Stats;
import com.archyx.aureliumskills.stats.Wisdom;
import com.archyx.aureliumskills.support.HologramSupport;
import com.archyx.aureliumskills.support.LuckPermsSupport;
import com.archyx.aureliumskills.support.PlaceholderSupport;
import com.archyx.aureliumskills.support.ProtocolLibSupport;
import com.archyx.aureliumskills.support.SlimefunSupport;
import com.archyx.aureliumskills.support.TownySupport;
import com.archyx.aureliumskills.support.WorldGuardFlags;
import com.archyx.aureliumskills.support.WorldGuardSupport;
import com.archyx.aureliumskills.ui.ActionBar;
import com.archyx.aureliumskills.ui.ActionBarCompatHandler;
import com.archyx.aureliumskills.ui.SkillBossBar;
import com.archyx.aureliumskills.util.armor.ArmorListener;
import com.archyx.aureliumskills.util.version.UpdateChecker;
import com.archyx.aureliumskills.util.world.WorldManager;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Locale;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.Nullable;

public class AureliumSkills
extends JavaPlugin {
    private PlayerManager playerManager;
    private StorageProvider storageProvider;
    private BackupProvider backupProvider;
    private MenuLoader menuLoader;
    private LootTableManager lootTableManager;
    private InventoryManager inventoryManager;
    private AbilityManager abilityManager;
    private WorldGuardSupport worldGuardSupport;
    private WorldGuardFlags worldGuardFlags;
    private WorldManager worldManager;
    private ManaManager manaManager;
    private ManaAbilityManager manaAbilityManager;
    private RewardManager rewardManager;
    private boolean holographicDisplaysEnabled;
    private boolean worldGuardEnabled;
    private boolean placeholderAPIEnabled;
    private boolean vaultEnabled;
    private boolean protocolLibEnabled;
    private boolean townyEnabled;
    private TownySupport townySupport;
    private boolean luckPermsEnabled;
    private boolean slimefunEnabled;
    private Economy economy;
    private OptionL optionLoader;
    private PaperCommandManager commandManager;
    private ActionBar actionBar;
    private SkillBossBar bossBar;
    private SourceManager sourceManager;
    private SorceryLeveler sorceryLeveler;
    private RegionBlockListener regionBlockListener;
    private RequirementManager requirementManager;
    private ModifierManager modifierManager;
    private Lang lang;
    private Leveler leveler;
    private Health health;
    private LeaderboardManager leaderboardManager;
    private RegionManager regionManager;
    private StatRegistry statRegistry;
    private SkillRegistry skillRegistry;
    private ExcavationAbilities excavationAbilities;
    private LuckPermsSupport luckPermsSupport;
    private SourceRegistry sourceRegistry;
    private ItemRegistry itemRegistry;
    private ProtocolLibSupport protocolLibSupport;

    public void onEnable() {
        Health health;
        this.statRegistry = new StatRegistry();
        this.registerStats();
        this.skillRegistry = new SkillRegistry();
        this.registerSkills();
        this.sourceRegistry = new SourceRegistry();
        this.itemRegistry = new ItemRegistry(this);
        this.inventoryManager = new InventoryManager(this);
        this.inventoryManager.init();
        AureliumAPI.setPlugin(this);
        if (this.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
            if (WorldGuardPlugin.inst().getDescription().getVersion().contains("7.0")) {
                this.worldGuardEnabled = true;
                this.worldGuardSupport = new WorldGuardSupport(this);
                this.worldGuardSupport.loadRegions();
            }
        } else {
            this.worldGuardEnabled = false;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderSupport(this).register();
            this.placeholderAPIEnabled = true;
            this.getLogger().info("PlaceholderAPI Support Enabled!");
        } else {
            this.placeholderAPIEnabled = false;
        }
        if (this.setupEconomy()) {
            this.vaultEnabled = true;
            this.getLogger().info("Vault Support Enabled!");
        } else {
            this.vaultEnabled = false;
        }
        this.protocolLibEnabled = Bukkit.getPluginManager().isPluginEnabled("ProtocolLib");
        this.townyEnabled = Bukkit.getPluginManager().isPluginEnabled("Towny");
        this.townySupport = new TownySupport(this);
        this.luckPermsEnabled = Bukkit.getPluginManager().isPluginEnabled("LuckPerms");
        if (this.luckPermsEnabled) {
            this.luckPermsSupport = new LuckPermsSupport();
        }
        this.slimefunEnabled = Bukkit.getPluginManager().isPluginEnabled("Slimefun");
        if (this.slimefunEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new SlimefunSupport(this), (Plugin)this);
            this.getLogger().info("Slimefun Support Enabled!");
        }
        this.health = health = new Health(this);
        this.getServer().getPluginManager().registerEvents((Listener)health, (Plugin)this);
        this.loadConfig();
        this.requirementManager = new RequirementManager(this);
        this.optionLoader = new OptionL(this);
        this.optionLoader.loadOptions();
        this.requirementManager.load();
        this.modifierManager = new ModifierManager(this);
        this.sourceManager = new SourceManager(this);
        this.sourceManager.loadSources();
        this.bossBar = new SkillBossBar(this);
        this.bossBar.loadOptions();
        if (Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays")) {
            this.holographicDisplaysEnabled = true;
            this.getServer().getPluginManager().registerEvents((Listener)new HologramSupport(this), (Plugin)this);
            this.getLogger().info("HolographicDisplays Support Enabled!");
        } else {
            this.holographicDisplaysEnabled = false;
        }
        this.commandManager = new PaperCommandManager((Plugin)this);
        this.itemRegistry.loadFromFile();
        this.lang = new Lang(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.lang, (Plugin)this);
        this.lang.init();
        this.lang.loadEmbeddedMessages(this.commandManager);
        this.lang.loadLanguages(this.commandManager);
        this.rewardManager = new RewardManager(this);
        this.rewardManager.loadRewards();
        this.registerCommands();
        this.menuLoader = new MenuLoader(this);
        try {
            this.menuLoader.load();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            this.getLogger().warning("Error loading menus!");
        }
        this.regionManager = new RegionManager(this);
        this.registerEvents();
        this.manaAbilityManager = new ManaAbilityManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.manaAbilityManager, (Plugin)this);
        this.manaAbilityManager.init();
        this.abilityManager = new AbilityManager(this);
        this.abilityManager.loadOptions();
        Regeneration regeneration = new Regeneration(this);
        this.getServer().getPluginManager().registerEvents((Listener)regeneration, (Plugin)this);
        regeneration.startRegen();
        regeneration.startSaturationRegen();
        if (this.protocolLibEnabled) {
            this.protocolLibSupport = new ProtocolLibSupport();
            new ActionBarCompatHandler(this).registerListeners();
        }
        this.actionBar.startUpdateActionBar();
        this.playerManager = new PlayerManager(this);
        this.leaderboardManager = new LeaderboardManager();
        if (OptionL.getBoolean(Option.MYSQL_ENABLED)) {
            MySqlStorageProvider mySqlStorageProvider = new MySqlStorageProvider(this);
            mySqlStorageProvider.init();
            MysqlBackup mysqlBackup = new MysqlBackup(this, mySqlStorageProvider);
            if (!mySqlStorageProvider.localeColumnExists()) {
                mysqlBackup.saveBackup((CommandSender)Bukkit.getConsoleSender(), false);
            }
            new LegacyMysqlToMysqlConverter(this, mySqlStorageProvider).convert();
            this.setStorageProvider(mySqlStorageProvider);
            this.backupProvider = mysqlBackup;
        } else {
            new LegacyFileBackup(this).saveBackup((CommandSender)Bukkit.getConsoleSender(), false);
            new LegacyFileToYamlConverter(this).convert();
            this.setStorageProvider(new YamlStorageProvider(this));
            this.backupProvider = new YamlBackup(this);
        }
        new BukkitRunnable(){

            public void run() {
                if (AureliumSkills.this.leaderboardManager.isNotSorting()) {
                    AureliumSkills.this.storageProvider.updateLeaderboards();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this, 0L, 12000L);
        this.leveler = new Leveler(this);
        this.leveler.loadLevelRequirements();
        this.lootTableManager = new LootTableManager(this);
        this.worldManager = new WorldManager((Plugin)this);
        this.worldManager.loadWorlds();
        int pluginId = 8629;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("Aurelium Skills has been enabled");
        if (System.currentTimeMillis() > 1642487648443L) {
            this.checkUpdates();
        }
        MinecraftVersion.disableUpdateCheck();
    }

    public void onDisable() {
        for (PlayerData playerData : this.playerManager.getPlayerDataMap().values()) {
            this.storageProvider.save(playerData.getPlayer(), false);
        }
        this.playerManager.getPlayerDataMap().clear();
        File file = new File(this.getDataFolder(), "config.yml");
        if (file.exists()) {
            this.reloadConfig();
            this.saveConfig();
        }
        this.regionManager.saveAllRegions(false, true);
        this.regionManager.clearRegionMap();
        this.backupAutomatically();
        this.itemRegistry.saveToFile();
        AgilityAbilities agilityAbilities = new AgilityAbilities(this);
        for (Player player : Bukkit.getOnlinePlayers()) {
            agilityAbilities.removeFleetingQuit(player);
        }
    }

    private void backupAutomatically() {
        File metaFile;
        YamlConfiguration metaConfig;
        long lastBackup;
        if (OptionL.getBoolean(Option.AUTOMATIC_BACKUPS_ENABLED) && (lastBackup = (metaConfig = YamlConfiguration.loadConfiguration((File)(metaFile = new File(this.getDataFolder(), "/backups/meta.yml")))).getLong("last_automatic_backup", 0L)) + (long)(OptionL.getDouble(Option.AUTOMATIC_BACKUPS_MINIMUM_INTERVAL_HOURS) * 3600000.0) <= System.currentTimeMillis() && this.backupProvider != null) {
            this.backupProvider.saveBackup((CommandSender)this.getServer().getConsoleSender(), false);
            metaConfig.set("last_automatic_backup", (Object)System.currentTimeMillis());
            try {
                metaConfig.save(metaFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null && WorldGuardPlugin.inst().getDescription().getVersion().contains("7.0")) {
            this.worldGuardFlags = new WorldGuardFlags();
            this.worldGuardFlags.register();
        }
    }

    public void checkUpdates() {
        if (!OptionL.getBoolean(Option.CHECK_FOR_UPDATES)) {
            return;
        }
        new UpdateChecker((Plugin)this, 81069).getVersion((Consumer<String>)((Consumer)version -> {
            if (!this.getDescription().getVersion().contains("Pre-Release") && !this.getDescription().getVersion().contains("Build")) {
                if (!this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                    this.getLogger().info("New update available! You are on version " + this.getDescription().getVersion() + ", latest version is " + version);
                    this.getLogger().info("Download it on Spigot:");
                    this.getLogger().info("https://spigotmc.org/resources/81069");
                }
            } else {
                this.getLogger().info("You are on an in development version of the plugin, plugin may be buggy or unstable!");
                this.getLogger().info("Report any bugs to the support discord server or submit an issue here: https://github.com/Archy-X/AureliumSkills/issues");
            }
        }));
    }

    public void loadConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        try {
            InputStream is = this.getResource("config.yml");
            if (is != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(is));
                ConfigurationSection config = defConfig.getConfigurationSection("");
                if (config != null) {
                    for (String key : config.getKeys(true)) {
                        if (this.getConfig().contains(key)) continue;
                        this.getConfig().set(key, defConfig.get(key));
                    }
                }
                this.saveConfig();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerCommands() {
        this.commandManager.enableUnstableAPI("help");
        this.commandManager.usePerIssuerLocale(true, false);
        this.commandManager.getCommandContexts().registerContext(Stat.class, c -> {
            String input = c.popFirstArg();
            Stat stat = this.statRegistry.getStat(input);
            if (stat != null) {
                return stat;
            }
            throw new InvalidCommandArgument("Stat " + input + " not found!");
        });
        this.commandManager.getCommandContexts().registerContext(Skill.class, c -> {
            String input = c.popFirstArg();
            Skill skill = this.skillRegistry.getSkill(input);
            if (skill != null) {
                return skill;
            }
            throw new InvalidCommandArgument("Skill " + input + " not found!");
        });
        this.commandManager.getCommandCompletions().registerAsyncCompletion("skills", c -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Skill skill : this.skillRegistry.getSkills()) {
                if (!OptionL.isEnabled(skill)) continue;
                values.add(skill.toString().toLowerCase(Locale.ENGLISH));
            }
            return values;
        });
        this.commandManager.getCommandCompletions().registerAsyncCompletion("skills_global", c -> {
            ArrayList<String> values = new ArrayList<String>();
            values.add("global");
            for (Skill skill : this.skillRegistry.getSkills()) {
                if (!OptionL.isEnabled(skill)) continue;
                values.add(skill.toString().toLowerCase(Locale.ENGLISH));
            }
            return values;
        });
        this.commandManager.getCommandCompletions().registerAsyncCompletion("skillTop", c -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Skill skill : this.skillRegistry.getSkills()) {
                if (!OptionL.isEnabled(skill)) continue;
                values.add(skill.toString().toLowerCase(Locale.ENGLISH));
            }
            values.add("average");
            return values;
        });
        this.commandManager.getCommandCompletions().registerAsyncCompletion("stats", c -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Stat stat : this.statRegistry.getStats()) {
                values.add(stat.toString().toLowerCase(Locale.ENGLISH));
            }
            return values;
        });
        this.commandManager.getCommandCompletions().registerAsyncCompletion("lang", c -> Lang.getDefinedLanguagesSet());
        this.commandManager.getCommandCompletions().registerAsyncCompletion("modifiers", c -> {
            Player player = c.getPlayer();
            PlayerData playerData = this.getPlayerManager().getPlayerData(player);
            if (playerData != null) {
                return playerData.getStatModifiers().keySet();
            }
            return null;
        });
        this.commandManager.getCommandCompletions().registerAsyncCompletion("item_keys", c -> this.itemRegistry.getKeys());
        this.commandManager.registerCommand(new SkillsCommand(this));
        this.commandManager.registerCommand(new StatsCommand(this));
        this.commandManager.registerCommand(new ManaCommand(this));
        if (OptionL.getBoolean(Option.ENABLE_SKILL_COMMANDS)) {
            if (OptionL.isEnabled(Skills.FARMING)) {
                this.commandManager.registerCommand(new SkillCommands.FarmingCommand(this));
            }
            if (OptionL.isEnabled(Skills.FORAGING)) {
                this.commandManager.registerCommand(new SkillCommands.ForagingCommand(this));
            }
            if (OptionL.isEnabled(Skills.MINING)) {
                this.commandManager.registerCommand(new SkillCommands.MiningCommand(this));
            }
            if (OptionL.isEnabled(Skills.FISHING)) {
                this.commandManager.registerCommand(new SkillCommands.FishingCommand(this));
            }
            if (OptionL.isEnabled(Skills.EXCAVATION)) {
                this.commandManager.registerCommand(new SkillCommands.ExcavationCommand(this));
            }
            if (OptionL.isEnabled(Skills.ARCHERY)) {
                this.commandManager.registerCommand(new SkillCommands.ArcheryCommand(this));
            }
            if (OptionL.isEnabled(Skills.DEFENSE)) {
                this.commandManager.registerCommand(new SkillCommands.DefenseCommand(this));
            }
            if (OptionL.isEnabled(Skills.FIGHTING)) {
                this.commandManager.registerCommand(new SkillCommands.FightingCommand(this));
            }
            if (OptionL.isEnabled(Skills.ENDURANCE)) {
                this.commandManager.registerCommand(new SkillCommands.EnduranceCommand(this));
            }
            if (OptionL.isEnabled(Skills.AGILITY)) {
                this.commandManager.registerCommand(new SkillCommands.AgilityCommand(this));
            }
            if (OptionL.isEnabled(Skills.ALCHEMY)) {
                this.commandManager.registerCommand(new SkillCommands.AlchemyCommand(this));
            }
            if (OptionL.isEnabled(Skills.ENCHANTING)) {
                this.commandManager.registerCommand(new SkillCommands.EnchantingCommand(this));
            }
            if (OptionL.isEnabled(Skills.SORCERY)) {
                this.commandManager.registerCommand(new SkillCommands.SorceryCommand(this));
            }
            if (OptionL.isEnabled(Skills.HEALING)) {
                this.commandManager.registerCommand(new SkillCommands.HealingCommand(this));
            }
            if (OptionL.isEnabled(Skills.FORGING)) {
                this.commandManager.registerCommand(new SkillCommands.ForgingCommand(this));
            }
        }
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerJoinQuit(this), (Plugin)this);
        this.regionBlockListener = new RegionBlockListener(this);
        pm.registerEvents((Listener)this.regionBlockListener, (Plugin)this);
        pm.registerEvents((Listener)new FarmingLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new ForagingLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new MiningLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new ExcavationLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new FishingLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new FightingLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new ArcheryLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new DefenseLeveler(this), (Plugin)this);
        EnduranceLeveler enduranceLeveler = new EnduranceLeveler(this);
        enduranceLeveler.startTracking();
        pm.registerEvents((Listener)enduranceLeveler, (Plugin)this);
        pm.registerEvents((Listener)new AgilityLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new AlchemyLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new EnchantingLeveler(this), (Plugin)this);
        this.sorceryLeveler = new SorceryLeveler(this);
        pm.registerEvents((Listener)new HealingLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new ForgingLeveler(this), (Plugin)this);
        pm.registerEvents((Listener)new Luck(this), (Plugin)this);
        pm.registerEvents((Listener)new Wisdom(this), (Plugin)this);
        pm.registerEvents((Listener)new FarmingAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new ForagingAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new MiningAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new FishingAbilities(this), (Plugin)this);
        this.excavationAbilities = new ExcavationAbilities(this);
        pm.registerEvents((Listener)this.excavationAbilities, (Plugin)this);
        pm.registerEvents((Listener)new ArcheryAbilities(this), (Plugin)this);
        DefenseAbilities defenseAbilities = new DefenseAbilities(this);
        pm.registerEvents((Listener)defenseAbilities, (Plugin)this);
        FightingAbilities fightingAbilities = new FightingAbilities(this);
        pm.registerEvents((Listener)fightingAbilities, (Plugin)this);
        pm.registerEvents((Listener)new FightingAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new EnduranceAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new AgilityAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new AlchemyAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new EnchantingAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new HealingAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new ForgingAbilities(this), (Plugin)this);
        pm.registerEvents((Listener)new DamageListener(this, defenseAbilities, fightingAbilities), (Plugin)this);
        this.manaManager = new ManaManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.manaManager, (Plugin)this);
        this.manaManager.startRegen();
        ItemListener itemListener = new ItemListener(this);
        pm.registerEvents((Listener)itemListener, (Plugin)this);
        itemListener.scheduleTask();
        pm.registerEvents((Listener)new ArmorListener(OptionL.getList(Option.MODIFIER_ARMOR_EQUIP_BLOCKED_MATERIALS)), (Plugin)this);
        pm.registerEvents((Listener)new ArmorModifierListener(this), (Plugin)this);
        pm.registerEvents((Listener)new RequirementListener(this), (Plugin)this);
        this.actionBar = new ActionBar(this);
        pm.registerEvents((Listener)this.actionBar, (Plugin)this);
        pm.registerEvents((Listener)new RegionListener(this), (Plugin)this);
        pm.registerEvents((Listener)new FishingLootHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new ExcavationLootHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new MiningLootHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new ForagingLootHandler(this), (Plugin)this);
    }

    private boolean setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return true;
    }

    private void registerStats() {
        this.statRegistry.register("strength", Stats.STRENGTH);
        this.statRegistry.register("health", Stats.HEALTH);
        this.statRegistry.register("regeneration", Stats.REGENERATION);
        this.statRegistry.register("luck", Stats.LUCK);
        this.statRegistry.register("wisdom", Stats.WISDOM);
        this.statRegistry.register("toughness", Stats.TOUGHNESS);
    }

    private void registerSkills() {
        this.skillRegistry.register("farming", Skills.FARMING);
        this.skillRegistry.register("foraging", Skills.FORAGING);
        this.skillRegistry.register("mining", Skills.MINING);
        this.skillRegistry.register("fishing", Skills.FISHING);
        this.skillRegistry.register("excavation", Skills.EXCAVATION);
        this.skillRegistry.register("archery", Skills.ARCHERY);
        this.skillRegistry.register("defense", Skills.DEFENSE);
        this.skillRegistry.register("fighting", Skills.FIGHTING);
        this.skillRegistry.register("endurance", Skills.ENDURANCE);
        this.skillRegistry.register("agility", Skills.AGILITY);
        this.skillRegistry.register("alchemy", Skills.ALCHEMY);
        this.skillRegistry.register("enchanting", Skills.ENCHANTING);
        this.skillRegistry.register("sorcery", Skills.SORCERY);
        this.skillRegistry.register("healing", Skills.HEALING);
        this.skillRegistry.register("forging", Skills.FORGING);
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public MenuLoader getMenuLoader() {
        return this.menuLoader;
    }

    public LootTableManager getLootTableManager() {
        return this.lootTableManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public AbilityManager getAbilityManager() {
        return this.abilityManager;
    }

    public WorldGuardSupport getWorldGuardSupport() {
        return this.worldGuardSupport;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public ManaManager getManaManager() {
        return this.manaManager;
    }

    public ManaAbilityManager getManaAbilityManager() {
        return this.manaAbilityManager;
    }

    public PaperCommandManager getCommandManager() {
        return this.commandManager;
    }

    public static String getPrefix(Locale locale) {
        return Lang.getMessage(CommandMessage.PREFIX, locale);
    }

    public ActionBar getActionBar() {
        return this.actionBar;
    }

    public SkillBossBar getBossBar() {
        return this.bossBar;
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public SorceryLeveler getSorceryLeveler() {
        return this.sorceryLeveler;
    }

    public RegionBlockListener getCheckBlockReplace() {
        return this.regionBlockListener;
    }

    public RequirementManager getRequirementManager() {
        return this.requirementManager;
    }

    public OptionL getOptionLoader() {
        return this.optionLoader;
    }

    public ModifierManager getModifierManager() {
        return this.modifierManager;
    }

    public Lang getLang() {
        return this.lang;
    }

    public Leveler getLeveler() {
        return this.leveler;
    }

    public boolean isHolographicDisplaysEnabled() {
        return this.holographicDisplaysEnabled;
    }

    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }

    public void setWorldGuardEnabled(boolean worldGuardEnabled) {
        this.worldGuardEnabled = worldGuardEnabled;
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }

    public boolean isVaultEnabled() {
        return this.vaultEnabled;
    }

    public boolean isProtocolLibEnabled() {
        return this.protocolLibEnabled;
    }

    public boolean isLuckPermsEnabled() {
        return this.luckPermsEnabled;
    }

    public boolean isSlimefunEnabled() {
        return this.slimefunEnabled;
    }

    public Health getHealth() {
        return this.health;
    }

    public StorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProvider(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public BackupProvider getBackupProvider() {
        return this.backupProvider;
    }

    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    public boolean isTownyEnabled() {
        return this.townyEnabled;
    }

    public TownySupport getTownySupport() {
        return this.townySupport;
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public StatRegistry getStatRegistry() {
        return this.statRegistry;
    }

    public SkillRegistry getSkillRegistry() {
        return this.skillRegistry;
    }

    public ExcavationAbilities getExcavationAbilities() {
        return this.excavationAbilities;
    }

    public LuckPermsSupport getLuckPermsSupport() {
        return this.luckPermsSupport;
    }

    public SourceRegistry getSourceRegistry() {
        return this.sourceRegistry;
    }

    public ItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    @Nullable
    public WorldGuardFlags getWorldGuardFlags() {
        return this.worldGuardFlags;
    }

    public ProtocolLibSupport getProtocolLibSupport() {
        return this.protocolLibSupport;
    }
}

