/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrency.SortedCopyOnWriteArray;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.injector.PrioritizedListener;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractConcurrentListenerMultimap<T> {
    private final ConcurrentMap<PacketType, SortedCopyOnWriteArray<PrioritizedListener<T>>> mapListeners = new ConcurrentHashMap<PacketType, SortedCopyOnWriteArray<PrioritizedListener<T>>>();

    protected AbstractConcurrentListenerMultimap() {
    }

    public void addListener(T listener, ListeningWhitelist whitelist) {
        PrioritizedListener<T> prioritized = new PrioritizedListener<T>(listener, whitelist.getPriority());
        for (PacketType type : whitelist.getTypes()) {
            this.addListener(type, prioritized);
        }
    }

    private void addListener(PacketType type, PrioritizedListener<T> listener) {
        SortedCopyOnWriteArray value;
        SortedCopyOnWriteArray<PrioritizedListener<T>> list = (SortedCopyOnWriteArray<PrioritizedListener<T>>)this.mapListeners.get(type);
        if (list == null && (list = this.mapListeners.putIfAbsent(type, value = new SortedCopyOnWriteArray())) == null) {
            list = value;
        }
        list.add(listener);
    }

    public List<PacketType> removeListener(T listener, ListeningWhitelist whitelist) {
        ArrayList<PacketType> removedPackets = new ArrayList<PacketType>();
        for (PacketType type : whitelist.getTypes()) {
            SortedCopyOnWriteArray list = (SortedCopyOnWriteArray)this.mapListeners.get(type);
            if (list == null || list.isEmpty()) continue;
            list.remove(new PrioritizedListener<T>(listener, whitelist.getPriority()));
            if (!list.isEmpty()) continue;
            this.mapListeners.remove(type);
            removedPackets.add(type);
        }
        return removedPackets;
    }

    public Collection<PrioritizedListener<T>> getListener(PacketType type) {
        return (Collection)this.mapListeners.get(type);
    }

    public Iterable<PrioritizedListener<T>> values() {
        return Iterables.concat(this.mapListeners.values());
    }

    public Set<PacketType> keySet() {
        return this.mapListeners.keySet();
    }

    protected void clearListeners() {
        this.mapListeners.clear();
    }
}

