/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.worldguard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.types.ActionParserType;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.types.UnlockedAbilities;

public class WGRegion {
    boolean failedLoad = false;
    private HashMap<Material, List<String>> breakExpressions = new HashMap();
    private HashMap<EntityType, List<String>> attackExpressions = new HashMap();
    private HashMap<String, List<String>> expGainExpressions = new HashMap();
    private HashMap<String, List<String>> abilityExpressions = new HashMap();
    private List<String> enterExpressions;
    private double expMultiplier;

    public WGRegion(String string) {
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.WORLDGUARD_CONFIG);
        this.expMultiplier = fileConfiguration.getDouble(string + "RegionExpMultiplier");
        this.enterExpressions = fileConfiguration.getStringList(string + "McRPGLimiters.BanEntry");
        List list = fileConfiguration.getStringList(string + "McRPGLimiters.BanAction");
        for (String string2 : list) {
            Object object;
            String[] stringArray = string2.split("-");
            ActionParserType actionParserType = ActionParserType.fromString(stringArray[0]);
            if (actionParserType == null) {
                Bukkit.getConsoleSender().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.WorldGuard.InvalidActionType").replace("%path%", string)));
                this.failedLoad = true;
                return;
            }
            if (actionParserType == ActionParserType.BREAK) {
                object = Material.getMaterial((String)stringArray[1]);
                if (object == null) {
                    Bukkit.getConsoleSender().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.WorldGuard.InvalidMaterial").replace("%path%", string)));
                    this.failedLoad = true;
                    return;
                }
                if (this.breakExpressions.containsKey(object)) {
                    this.breakExpressions.get(object).add(stringArray[2]);
                    continue;
                }
                this.breakExpressions.put((Material)object, Collections.singletonList(stringArray[2]));
                continue;
            }
            if (actionParserType == ActionParserType.ATTACK) {
                object = EntityType.fromName((String)stringArray[1]);
                if (object == null) {
                    Bukkit.getConsoleSender().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.WorldGuard.InvalidEntity").replace("%path%", string)));
                    this.failedLoad = true;
                    return;
                }
                if (this.attackExpressions.containsKey(object)) {
                    this.attackExpressions.get(object).add(stringArray[2]);
                    continue;
                }
                this.attackExpressions.put((EntityType)object, Collections.singletonList(stringArray[2]));
                continue;
            }
            if (actionParserType == ActionParserType.EXP_GAIN) {
                if (!stringArray[1].equalsIgnoreCase("all") && !Skills.isSkill(stringArray[1])) {
                    Bukkit.getConsoleSender().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.WorldGuard.InvalidSkillParameter").replace("%path%", string)));
                    this.failedLoad = true;
                    return;
                }
                if (this.expGainExpressions.containsKey(stringArray[1])) {
                    this.expGainExpressions.get(stringArray[1]).add(stringArray[2]);
                    continue;
                }
                this.expGainExpressions.put(stringArray[1], Collections.singletonList(stringArray[2]));
                continue;
            }
            if (actionParserType != ActionParserType.ABILITY_ACTIVATE) continue;
            object = stringArray[1];
            if (!(((String)object).equalsIgnoreCase("all") || Skills.isSkill((String)object) || UnlockedAbilities.isAbility((String)object))) {
                Bukkit.getConsoleSender().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.WorldGuard.InvalidAbilityParameter").replace("%path%", string)));
                this.failedLoad = true;
            }
            if (this.abilityExpressions.containsKey(object)) {
                this.abilityExpressions.get(object).add(stringArray[2]);
                continue;
            }
            this.abilityExpressions.put((String)object, Collections.singletonList(stringArray[2]));
        }
    }

    public boolean isFailedLoad() {
        return this.failedLoad;
    }

    public HashMap<Material, List<String>> getBreakExpressions() {
        return this.breakExpressions;
    }

    public HashMap<EntityType, List<String>> getAttackExpressions() {
        return this.attackExpressions;
    }

    public HashMap<String, List<String>> getExpGainExpressions() {
        return this.expGainExpressions;
    }

    public HashMap<String, List<String>> getAbilityExpressions() {
        return this.abilityExpressions;
    }

    public List<String> getEnterExpressions() {
        return this.enterExpressions;
    }

    public double getExpMultiplier() {
        return this.expMultiplier;
    }
}

