/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.worldguard;

import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.worldguard.McRPGParser;

public class ActionLimiterParser
extends McRPGParser {
    private String equation;
    private McRPGPlayer[] players;

    public ActionLimiterParser(String string, McRPGPlayer ... mcRPGPlayerArray) {
        this.equation = string;
        this.players = mcRPGPlayerArray;
    }

    public boolean evaluateExpression() {
        boolean bl = false;
        McRPGPlayer mcRPGPlayer = this.players[0];
        String[] stringArray = this.equation.split(" ");
        if (Skills.isSkill(stringArray[0])) {
            int n = mcRPGPlayer.getSkill(stringArray[0]).getCurrentLevel();
            int n2 = Integer.parseInt(stringArray[2]);
            bl = this.evaluate(stringArray[1], n, n2);
        } else if (stringArray[0].equals("power_level")) {
            int n = mcRPGPlayer.getPowerLevel();
            int n3 = Integer.parseInt(stringArray[2]);
            bl = this.evaluate(stringArray[1], n, n3);
        } else if (stringArray[0].equals("power_level_difference")) {
            McRPGPlayer mcRPGPlayer2 = this.players[1];
            int n = mcRPGPlayer.getPowerLevel() - mcRPGPlayer2.getPowerLevel();
            int n4 = Integer.parseInt(stringArray[2]);
            bl = this.evaluate(stringArray[1], n, n4);
        } else if (stringArray[0].contains("skill_difference")) {
            McRPGPlayer mcRPGPlayer3 = this.players[1];
            String string = stringArray[0].replace("skill_difference(", "").replace(")", "");
            int n = mcRPGPlayer.getSkill(string).getCurrentLevel() - mcRPGPlayer3.getSkill(string).getCurrentLevel();
            int n5 = Integer.parseInt(stringArray[2]);
            bl = this.evaluate(stringArray[1], n, n5);
        } else if (stringArray[0].contains("skill_level")) {
            String string = stringArray[0].replace("skill_level(", "").replace(")", "");
            int n = mcRPGPlayer.getSkill(string).getCurrentLevel();
            int n6 = Integer.parseInt(stringArray[2]);
            bl = this.evaluate(stringArray[1], n, n6);
        } else if (stringArray[0].contains("ability_tier")) {
            String string = stringArray[0].replace("ability_tier(", "").replace("}", "");
            int n = mcRPGPlayer.getBaseAbility(UnlockedAbilities.fromString(string)).getCurrentTier();
            int n7 = Integer.parseInt(stringArray[2]);
            bl = this.evaluate(stringArray[1], n, n7);
        }
        return bl;
    }

    public boolean evaluateExpression(UnlockedAbilities unlockedAbilities) {
        boolean bl = false;
        McRPGPlayer mcRPGPlayer = this.players[0];
        String[] stringArray = this.equation.split(" ");
        if (stringArray[0].contains("ability_tier") && stringArray[0].contains("self")) {
            bl = this.evaluate(stringArray[1], mcRPGPlayer.getBaseAbility(unlockedAbilities).getCurrentTier(), Integer.parseInt(stringArray[2]));
        }
        return bl;
    }

    public boolean evaluateExpression(Skills skills) {
        boolean bl = false;
        McRPGPlayer mcRPGPlayer = this.players[0];
        String[] stringArray = this.equation.split(" ");
        if (stringArray[0].contains("skill_level") && stringArray[0].contains("self")) {
            bl = this.evaluate(stringArray[1], mcRPGPlayer.getSkill(skills).getCurrentLevel(), Integer.parseInt(stringArray[2]));
        }
        return bl;
    }

    public String getEquation() {
        return this.equation;
    }

    public McRPGPlayer[] getPlayers() {
        return this.players;
    }
}

